package io.dekorate.option.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class VcsConfigBuilder extends VcsConfigFluentImpl<VcsConfigBuilder> implements VisitableBuilder<VcsConfig,VcsConfigBuilder> {

    VcsConfigFluent<?> fluent;
    Boolean validationEnabled;

    public VcsConfigBuilder() {
        this(true);
    }

    public VcsConfigBuilder(Boolean validationEnabled) {
        this(new VcsConfig(), validationEnabled);
    }

    public VcsConfigBuilder(VcsConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public VcsConfigBuilder(VcsConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new VcsConfig(), validationEnabled);
    }

    public VcsConfigBuilder(VcsConfigFluent<?> fluent,VcsConfig instance) {
        this(fluent, instance, true);
    }

    public VcsConfigBuilder(VcsConfigFluent<?> fluent,VcsConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withRemote(instance.getRemote()); 
        fluent.withHttpsPreferred(instance.isHttpsPreferred()); 
        this.validationEnabled = validationEnabled; 
    }

    public VcsConfigBuilder(VcsConfig instance) {
        this(instance,true);
    }

    public VcsConfigBuilder(VcsConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withRemote(instance.getRemote()); 
        this.withHttpsPreferred(instance.isHttpsPreferred()); 
        this.validationEnabled = validationEnabled; 
    }

    public EditableVcsConfig build() {
        EditableVcsConfig buildable = new EditableVcsConfig(fluent.getProject(),fluent.getAttributes(),fluent.getRemote(),fluent.isHttpsPreferred());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VcsConfigBuilder that = (VcsConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
