package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class VcsConfig extends Configuration {

    private String remote = "origin";
    private boolean httpsPreferred = false;

    public VcsConfig() {
    }

    public VcsConfig(Project project,Map<ConfigKey,Object> attributes,String remote,boolean httpsPreferred) {
        super(project, attributes);
        this.remote = remote != null ? remote : "origin";
        this.httpsPreferred = httpsPreferred;
    }

    public String getRemote() {
        return this.remote;
    }

    public boolean isHttpsPreferred() {
        return this.httpsPreferred;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        VcsConfig that = (VcsConfig) o;
        if (remote != null ? !remote.equals(that.remote) :that.remote != null) return false;
        if (httpsPreferred != that.httpsPreferred) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(remote,  httpsPreferred,  super.hashCode());
    }

}
