/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.dekorate.option.annotation.GarbageCollector;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.option.config.JvmConfig;
import io.dekorate.option.config.JvmConfigFluent;
import java.util.Objects;

public class JvmConfigFluentImpl<A extends JvmConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements JvmConfigFluent<A> {
    private int xms = 0;
    private int xmx = 0;
    private boolean server = false;
    private boolean useStringDeduplication = false;
    private boolean preferIPv4Stack = false;
    private boolean heapDumpOnOutOfMemoryError = false;
    private boolean useGCOverheadLimit = false;
    private GarbageCollector gc = GarbageCollector.Undefined;
    private SecureRandomSource secureRandom = SecureRandomSource.Undefined;

    public JvmConfigFluentImpl() {
    }

    public JvmConfigFluentImpl(JvmConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withXms(instance.getXms());
        this.withXmx(instance.getXmx());
        this.withServer(instance.isServer());
        this.withUseStringDeduplication(instance.isUseStringDeduplication());
        this.withPreferIPv4Stack(instance.isPreferIPv4Stack());
        this.withHeapDumpOnOutOfMemoryError(instance.isHeapDumpOnOutOfMemoryError());
        this.withUseGCOverheadLimit(instance.isUseGCOverheadLimit());
        this.withGc(instance.getGc());
        this.withSecureRandom(instance.getSecureRandom());
    }

    @Override
    public int getXms() {
        return this.xms;
    }

    @Override
    public A withXms(int xms) {
        this.xms = xms;
        return (A)this;
    }

    @Override
    public Boolean hasXms() {
        return true;
    }

    @Override
    public int getXmx() {
        return this.xmx;
    }

    @Override
    public A withXmx(int xmx) {
        this.xmx = xmx;
        return (A)this;
    }

    @Override
    public Boolean hasXmx() {
        return true;
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public A withServer(boolean server) {
        this.server = server;
        return (A)this;
    }

    @Override
    public Boolean hasServer() {
        return true;
    }

    @Override
    public boolean isUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    @Override
    public A withUseStringDeduplication(boolean useStringDeduplication) {
        this.useStringDeduplication = useStringDeduplication;
        return (A)this;
    }

    @Override
    public Boolean hasUseStringDeduplication() {
        return true;
    }

    @Override
    public boolean isPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    @Override
    public A withPreferIPv4Stack(boolean preferIPv4Stack) {
        this.preferIPv4Stack = preferIPv4Stack;
        return (A)this;
    }

    @Override
    public Boolean hasPreferIPv4Stack() {
        return true;
    }

    @Override
    public boolean isHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    @Override
    public A withHeapDumpOnOutOfMemoryError(boolean heapDumpOnOutOfMemoryError) {
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        return (A)this;
    }

    @Override
    public Boolean hasHeapDumpOnOutOfMemoryError() {
        return true;
    }

    @Override
    public boolean isUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    @Override
    public A withUseGCOverheadLimit(boolean useGCOverheadLimit) {
        this.useGCOverheadLimit = useGCOverheadLimit;
        return (A)this;
    }

    @Override
    public Boolean hasUseGCOverheadLimit() {
        return true;
    }

    @Override
    public GarbageCollector getGc() {
        return this.gc;
    }

    @Override
    public A withGc(GarbageCollector gc) {
        this.gc = gc;
        return (A)this;
    }

    @Override
    public Boolean hasGc() {
        return this.gc != null;
    }

    @Override
    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    @Override
    public A withSecureRandom(SecureRandomSource secureRandom) {
        this.secureRandom = secureRandom;
        return (A)this;
    }

    @Override
    public Boolean hasSecureRandom() {
        return this.secureRandom != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmConfigFluentImpl that = (JvmConfigFluentImpl)o;
        if (this.xms != that.xms) {
            return false;
        }
        if (this.xmx != that.xmx) {
            return false;
        }
        if (this.server != that.server) {
            return false;
        }
        if (this.useStringDeduplication != that.useStringDeduplication) {
            return false;
        }
        if (this.preferIPv4Stack != that.preferIPv4Stack) {
            return false;
        }
        if (this.heapDumpOnOutOfMemoryError != that.heapDumpOnOutOfMemoryError) {
            return false;
        }
        if (this.useGCOverheadLimit != that.useGCOverheadLimit) {
            return false;
        }
        if (this.gc != null ? !this.gc.equals((Object)that.gc) : that.gc != null) {
            return false;
        }
        return !(this.secureRandom != null ? !this.secureRandom.equals((Object)that.secureRandom) : that.secureRandom != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.xms, this.xmx, this.server, this.useStringDeduplication, this.preferIPv4Stack, this.heapDumpOnOutOfMemoryError, this.useGCOverheadLimit, this.gc, this.secureRandom, super.hashCode()});
    }
}

