package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import java.lang.Object;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.option.annotation.SecureRandomSource;
import java.lang.Boolean;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

public interface JvmConfigFluent<A extends JvmConfigFluent<A>> extends ConfigurationFluent<A> {


    public int getXms();
    public A withXms(int xms);
    public Boolean hasXms();
    public int getXmx();
    public A withXmx(int xmx);
    public Boolean hasXmx();
    public boolean isServer();
    public A withServer(boolean server);
    public Boolean hasServer();
    public boolean isUseStringDeduplication();
    public A withUseStringDeduplication(boolean useStringDeduplication);
    public Boolean hasUseStringDeduplication();
    public boolean isPreferIPv4Stack();
    public A withPreferIPv4Stack(boolean preferIPv4Stack);
    public Boolean hasPreferIPv4Stack();
    public boolean isHeapDumpOnOutOfMemoryError();
    public A withHeapDumpOnOutOfMemoryError(boolean heapDumpOnOutOfMemoryError);
    public Boolean hasHeapDumpOnOutOfMemoryError();
    public boolean isUseGCOverheadLimit();
    public A withUseGCOverheadLimit(boolean useGCOverheadLimit);
    public Boolean hasUseGCOverheadLimit();
    public GarbageCollector getGc();
    public A withGc(GarbageCollector gc);
    public Boolean hasGc();
    public SecureRandomSource getSecureRandom();
    public A withSecureRandom(SecureRandomSource secureRandom);
    public Boolean hasSecureRandom();
}
