/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.doc.Description;
import io.dekorate.option.adapter.JvmConfigAdapter;
import io.dekorate.option.annotation.JvmOptions;
import io.dekorate.option.generator.JvmOptionsGenerator;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Jvm options, which are used for the target deployment.")
@SupportedAnnotationTypes(value={"io.dekorate.option.annotation.JvmOptions"})
public class JvmOptionsProcessor
extends AbstractAnnotationProcessor
implements JvmOptionsGenerator,
WithSession {
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                JvmOptions options = element.getAnnotation(JvmOptions.class);
                if (options == null) continue;
                this.add(element);
            }
        }
        return false;
    }

    public void add(Element element) {
        JvmOptions jvmOptions = element.getAnnotation(JvmOptions.class);
        if (jvmOptions != null) {
            AnnotationConfiguration config = new AnnotationConfiguration((VisitableBuilder)JvmConfigAdapter.newBuilder(jvmOptions));
            this.on((ConfigurationSupplier)config);
        }
    }
}

