/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.option.annotation.GarbageCollector;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class JvmConfig
extends Configuration {
    private int xms = 0;
    private int xmx = 0;
    private boolean server = false;
    private boolean useStringDeduplication = false;
    private boolean preferIPv4Stack = false;
    private boolean heapDumpOnOutOfMemoryError = false;
    private boolean useGCOverheadLimit = false;
    private GarbageCollector gc = GarbageCollector.Undefined;
    private SecureRandomSource secureRandom = SecureRandomSource.Undefined;

    public JvmConfig() {
    }

    public JvmConfig(Project project, Map<ConfigKey, Object> attributes, int xms, int xmx, boolean server, boolean useStringDeduplication, boolean preferIPv4Stack, boolean heapDumpOnOutOfMemoryError, boolean useGCOverheadLimit, GarbageCollector gc, SecureRandomSource secureRandom) {
        super(project, attributes);
        this.xms = xms;
        this.xmx = xmx;
        this.server = server;
        this.useStringDeduplication = useStringDeduplication;
        this.preferIPv4Stack = preferIPv4Stack;
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        this.useGCOverheadLimit = useGCOverheadLimit;
        this.gc = gc != null ? gc : GarbageCollector.Undefined;
        this.secureRandom = secureRandom != null ? secureRandom : SecureRandomSource.Undefined;
    }

    public int getXms() {
        return this.xms;
    }

    public int getXmx() {
        return this.xmx;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public boolean isPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public boolean isHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public boolean isUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmConfig that = (JvmConfig)((Object)o);
        if (this.xms != that.xms) {
            return false;
        }
        if (this.xmx != that.xmx) {
            return false;
        }
        if (this.server != that.server) {
            return false;
        }
        if (this.useStringDeduplication != that.useStringDeduplication) {
            return false;
        }
        if (this.preferIPv4Stack != that.preferIPv4Stack) {
            return false;
        }
        if (this.heapDumpOnOutOfMemoryError != that.heapDumpOnOutOfMemoryError) {
            return false;
        }
        if (this.useGCOverheadLimit != that.useGCOverheadLimit) {
            return false;
        }
        if (this.gc != null ? !this.gc.equals((Object)that.gc) : that.gc != null) {
            return false;
        }
        return !(this.secureRandom != null ? !this.secureRandom.equals((Object)that.secureRandom) : that.secureRandom != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.xms, this.xmx, this.server, this.useStringDeduplication, this.preferIPv4Stack, this.heapDumpOnOutOfMemoryError, this.useGCOverheadLimit, this.gc, this.secureRandom, super.hashCode()});
    }
}

