package io.dekorate.option.adapter;

import java.nio.file.Path;
import io.dekorate.option.config.JvmConfigBuilder;
import java.lang.String;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.option.annotation.JvmOptions;
import java.lang.Object;
import java.util.List;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.project.ScmInfo;
import io.dekorate.option.config.JvmConfig;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

public class JvmConfigAdapter {


    public static JvmConfig adapt(JvmOptions instance) {
        return newBuilder(instance).build();
    }

    public static JvmConfigBuilder newBuilder(JvmOptions instance) {
        return new JvmConfigBuilder(new io.dekorate.option.config.JvmConfig(null,
                    null,
                    instance.xms(),
                    instance.xmx(),
                    instance.server(),
                    instance.useStringDeduplication(),
                    instance.preferIPv4Stack(),
                    instance.heapDumpOnOutOfMemoryError(),
                    instance.useGCOverheadLimit(),
                    instance.gc(),
                    instance.secureRandom()));
    }

    public static JvmConfig adapt(Map map) {
        return new io.dekorate.option.config.JvmConfig(
        null,
        null,
                       Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xms","0") : "0")),
                       Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xmx","0") : "0")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("server","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useStringDeduplication","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("preferIPv4Stack","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("heapDumpOnOutOfMemoryError","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useGCOverheadLimit","false") : "false")),
                       GarbageCollector.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("gc","Undefined") : "Undefined")),
                       SecureRandomSource.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("secureRandom","Undefined") : "Undefined")));
    }

    public static JvmConfigBuilder newBuilder(Map map) {
        return new JvmConfigBuilder(new io.dekorate.option.config.JvmConfig(
        null,
        null,
                       Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xms","0") : "0")),
                       Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xmx","0") : "0")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("server","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useStringDeduplication","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("preferIPv4Stack","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("heapDumpOnOutOfMemoryError","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useGCOverheadLimit","false") : "false")),
                       GarbageCollector.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("gc","Undefined") : "Undefined")),
                       SecureRandomSource.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("secureRandom","Undefined") : "Undefined"))));
    }

    public static String[] toStringArray(Object o) {
                if (o instanceof String[]) {
                  return (String[]) o;
                }
                if (o instanceof String) {
                  String s =  (String) o;
                  return s.split(",[ ]*");
                }
                else if (o instanceof List) {
                  List c = (List) o;
                  String[] result = new String[c.size()]; 
                  for (int i=0; i <= c.size(); i++) {
                    result[i] = String.valueOf(c.get(i));
                  }
                  return result;
                }
                return new String[0];
            
    }

}
