/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.option.adapter.JvmConfigAdapter;
import io.dekorate.option.config.JvmConfig;
import io.dekorate.option.configurator.ApplyJvmOptsConfigurator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Map;

public interface JvmOptionsGenerator
extends Generator {
    public static final String JVM = "jvm";

    default public String getKey() {
        return JVM;
    }

    default public Class<? extends Configuration> getConfigType() {
        return JvmConfig.class;
    }

    default public void addAnnotationConfiguration(Map map) {
        this.on((ConfigurationSupplier<JvmConfig>)new AnnotationConfiguration((VisitableBuilder)JvmConfigAdapter.newBuilder(this.propertiesMap(map, JvmConfig.class))));
    }

    default public void addPropertyConfiguration(Map map) {
        this.on((ConfigurationSupplier<JvmConfig>)new PropertyConfiguration((VisitableBuilder)JvmConfigAdapter.newBuilder(this.propertiesMap(map, JvmConfig.class))));
    }

    default public void on(ConfigurationSupplier<JvmConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.configurators().add((Configurator)new ApplyJvmOptsConfigurator(config));
    }
}

