package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.option.annotation.GarbageCollector;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class JvmConfig extends Configuration{

    private int xms = 0;
    private int xmx = 0;
    private boolean server = false;
    private boolean useStringDeduplication = false;
    private boolean preferIPv4Stack = false;
    private boolean heapDumpOnOutOfMemoryError = false;
    private boolean useGCOverheadLimit = false;
    private GarbageCollector gc = io.dekorate.option.annotation.GarbageCollector.Undefined;
    private SecureRandomSource secureRandom = io.dekorate.option.annotation.SecureRandomSource.Undefined;

    public JvmConfig(){
    }
    public JvmConfig(Project project,Map<ConfigKey,Object> attributes,int xms,int xmx,boolean server,boolean useStringDeduplication,boolean preferIPv4Stack,boolean heapDumpOnOutOfMemoryError,boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom){
            super(project, attributes);
            this.xms = xms;
            this.xmx = xmx;
            this.server = server;
            this.useStringDeduplication = useStringDeduplication;
            this.preferIPv4Stack = preferIPv4Stack;
            this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
            this.useGCOverheadLimit = useGCOverheadLimit;
            this.gc = gc != null ? gc : io.dekorate.option.annotation.GarbageCollector.Undefined;
            this.secureRandom = secureRandom != null ? secureRandom : io.dekorate.option.annotation.SecureRandomSource.Undefined;
    }

    public int getXms(){
            return this.xms;
    }

    public int getXmx(){
            return this.xmx;
    }

    public boolean isServer(){
            return this.server;
    }

    public boolean isUseStringDeduplication(){
            return this.useStringDeduplication;
    }

    public boolean isPreferIPv4Stack(){
            return this.preferIPv4Stack;
    }

    public boolean isHeapDumpOnOutOfMemoryError(){
            return this.heapDumpOnOutOfMemoryError;
    }

    public boolean isUseGCOverheadLimit(){
            return this.useGCOverheadLimit;
    }

    public GarbageCollector getGc(){
            return this.gc;
    }

    public SecureRandomSource getSecureRandom(){
            return this.secureRandom;
    }




}
