/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.config;

import io.dekorate.option.config.EditableJvmConfig;
import io.dekorate.option.config.JvmConfig;
import io.dekorate.option.config.JvmConfigFluent;
import io.dekorate.option.config.JvmConfigFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class JvmConfigBuilder
extends JvmConfigFluentImpl<JvmConfigBuilder>
implements VisitableBuilder<JvmConfig, JvmConfigBuilder> {
    JvmConfigFluent<?> fluent;
    Boolean validationEnabled;

    public JvmConfigBuilder() {
        this(true);
    }

    public JvmConfigBuilder(Boolean validationEnabled) {
        this(new JvmConfig(), validationEnabled);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new JvmConfig(), validationEnabled);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent, JvmConfig instance) {
        this(fluent, instance, true);
    }

    public JvmConfigBuilder(JvmConfigFluent<?> fluent, JvmConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withXms(instance.getXms());
        fluent.withXmx(instance.getXmx());
        fluent.withServer(instance.isServer());
        fluent.withUseStringDeduplication(instance.isUseStringDeduplication());
        fluent.withPreferIPv4Stack(instance.isPreferIPv4Stack());
        fluent.withHeapDumpOnOutOfMemoryError(instance.isHeapDumpOnOutOfMemoryError());
        fluent.withUseGCOverheadLimit(instance.isUseGCOverheadLimit());
        fluent.withGc(instance.getGc());
        fluent.withSecureRandom(instance.getSecureRandom());
        this.validationEnabled = validationEnabled;
    }

    public JvmConfigBuilder(JvmConfig instance) {
        this(instance, (Boolean)true);
    }

    public JvmConfigBuilder(JvmConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withXms(instance.getXms());
        this.withXmx(instance.getXmx());
        this.withServer(instance.isServer());
        this.withUseStringDeduplication(instance.isUseStringDeduplication());
        this.withPreferIPv4Stack(instance.isPreferIPv4Stack());
        this.withHeapDumpOnOutOfMemoryError(instance.isHeapDumpOnOutOfMemoryError());
        this.withUseGCOverheadLimit(instance.isUseGCOverheadLimit());
        this.withGc(instance.getGc());
        this.withSecureRandom(instance.getSecureRandom());
        this.validationEnabled = validationEnabled;
    }

    public EditableJvmConfig build() {
        EditableJvmConfig buildable = new EditableJvmConfig(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getXms(), this.fluent.getXmx(), this.fluent.isServer(), this.fluent.isUseStringDeduplication(), this.fluent.isPreferIPv4Stack(), this.fluent.isHeapDumpOnOutOfMemoryError(), this.fluent.isUseGCOverheadLimit(), this.fluent.getGc(), this.fluent.getSecureRandom());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JvmConfigBuilder that = (JvmConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

