package io.dekorate.option.adapter;

import java.nio.file.Path;
import io.dekorate.option.config.JvmConfigBuilder;
import java.lang.String;
import java.util.Comparator;
import io.dekorate.project.Project;
import io.dekorate.project.BuildInfo;
import io.dekorate.option.annotation.JvmOptions;
import io.dekorate.option.annotation.SecureRandomSource;
import io.dekorate.project.ScmInfo;
import io.dekorate.option.config.JvmConfig;
import java.util.Map;
import io.dekorate.option.annotation.GarbageCollector;

public class JvmConfigAdapter{



    public static JvmConfig adapt(JvmOptions instance){
            return newBuilder(instance).build();
    }

    public static JvmConfigBuilder newBuilder(JvmOptions instance){
            return new JvmConfigBuilder(new io.dekorate.option.config.JvmConfig(null,
            null,
            instance.xms(),
            instance.xmx(),
            instance.server(),
            instance.useStringDeduplication(),
            instance.preferIPv4Stack(),
            instance.heapDumpOnOutOfMemoryError(),
            instance.useGCOverheadLimit(),
            instance.gc(),
            instance.secureRandom()));
    }

    public static JvmConfig adapt(Map map){
            return new io.dekorate.option.config.JvmConfig(
null,
null,
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xms","0") : "0")),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xmx","0") : "0")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("server","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useStringDeduplication","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("preferIPv4Stack","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("heapDumpOnOutOfMemoryError","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useGCOverheadLimit","false") : "false")),
               GarbageCollector.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("gc","Undefined") : "Undefined")),
               SecureRandomSource.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("secureRandom","Undefined") : "Undefined")));
    }

    public static JvmConfigBuilder newBuilder(Map map){
            return new JvmConfigBuilder(new io.dekorate.option.config.JvmConfig(
null,
null,
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xms","0") : "0")),
               Integer.parseInt(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("xmx","0") : "0")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("server","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useStringDeduplication","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("preferIPv4Stack","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("heapDumpOnOutOfMemoryError","false") : "false")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("useGCOverheadLimit","false") : "false")),
               GarbageCollector.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("gc","Undefined") : "Undefined")),
               SecureRandomSource.valueOf(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("secureRandom","Undefined") : "Undefined"))));
    }




}
