package io.dekorate.option.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JvmConfigBuilder extends JvmConfigFluentImpl<JvmConfigBuilder> implements VisitableBuilder<JvmConfig,JvmConfigBuilder> {

    JvmConfigFluent<?> fluent;
    Boolean validationEnabled;

    public JvmConfigBuilder() { 
        this(true);
    }


    public JvmConfigBuilder(Boolean validationEnabled) { 
        this(new JvmConfig(), validationEnabled);
    }


    public JvmConfigBuilder(JvmConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public JvmConfigBuilder(JvmConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new JvmConfig(), validationEnabled);
    }


    public JvmConfigBuilder(JvmConfigFluent<?> fluent,JvmConfig instance) { 
        this(fluent, instance, true);
    }


    public JvmConfigBuilder(JvmConfigFluent<?> fluent,JvmConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withProject(instance.getProject()); 
        fluent.withAttributes(instance.getAttributes()); 
        fluent.withXms(instance.getXms()); 
        fluent.withXmx(instance.getXmx()); 
        fluent.withServer(instance.isServer()); 
        fluent.withUseStringDeduplication(instance.isUseStringDeduplication()); 
        fluent.withPreferIPv4Stack(instance.isPreferIPv4Stack()); 
        fluent.withHeapDumpOnOutOfMemoryError(instance.isHeapDumpOnOutOfMemoryError()); 
        fluent.withUseGCOverheadLimit(instance.isUseGCOverheadLimit()); 
        fluent.withGc(instance.getGc()); 
        fluent.withSecureRandom(instance.getSecureRandom()); 
        this.validationEnabled = validationEnabled; 
    }


    public JvmConfigBuilder(JvmConfig instance) { 
        this(instance,true);
    }


    public JvmConfigBuilder(JvmConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withProject(instance.getProject()); 
        this.withAttributes(instance.getAttributes()); 
        this.withXms(instance.getXms()); 
        this.withXmx(instance.getXmx()); 
        this.withServer(instance.isServer()); 
        this.withUseStringDeduplication(instance.isUseStringDeduplication()); 
        this.withPreferIPv4Stack(instance.isPreferIPv4Stack()); 
        this.withHeapDumpOnOutOfMemoryError(instance.isHeapDumpOnOutOfMemoryError()); 
        this.withUseGCOverheadLimit(instance.isUseGCOverheadLimit()); 
        this.withGc(instance.getGc()); 
        this.withSecureRandom(instance.getSecureRandom()); 
        this.validationEnabled = validationEnabled; 
    }


    public EditableJvmConfig build() {
        EditableJvmConfig buildable = new EditableJvmConfig(fluent.getProject(),fluent.getAttributes(),fluent.getXms(),fluent.getXmx(),fluent.isServer(),fluent.isUseStringDeduplication(),fluent.isPreferIPv4Stack(),fluent.isHeapDumpOnOutOfMemoryError(),fluent.isUseGCOverheadLimit(),fluent.getGc(),fluent.getSecureRandom());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmConfigBuilder that = (JvmConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
