package io.dekorate.option.config;

import io.dekorate.project.Project;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.Object;
import io.dekorate.option.annotation.SecureRandomSource;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;
import io.dekorate.option.annotation.GarbageCollector;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class JvmConfig extends Configuration {

    private int xms = 0;
    private int xmx = 0;
    private boolean server = false;
    private boolean useStringDeduplication = false;
    private boolean preferIPv4Stack = false;
    private boolean heapDumpOnOutOfMemoryError = false;
    private boolean useGCOverheadLimit = false;
    private GarbageCollector gc = io.dekorate.option.annotation.GarbageCollector.Undefined;
    private SecureRandomSource secureRandom = io.dekorate.option.annotation.SecureRandomSource.Undefined;

    public JvmConfig() { 
    }


    public JvmConfig(Project project,Map<ConfigKey,Object> attributes,int xms,int xmx,boolean server,boolean useStringDeduplication,boolean preferIPv4Stack,boolean heapDumpOnOutOfMemoryError,boolean useGCOverheadLimit,GarbageCollector gc,SecureRandomSource secureRandom) { 
        super(project, attributes);
        this.xms = xms;
        this.xmx = xmx;
        this.server = server;
        this.useStringDeduplication = useStringDeduplication;
        this.preferIPv4Stack = preferIPv4Stack;
        this.heapDumpOnOutOfMemoryError = heapDumpOnOutOfMemoryError;
        this.useGCOverheadLimit = useGCOverheadLimit;
        this.gc = gc != null ? gc : io.dekorate.option.annotation.GarbageCollector.Undefined;
        this.secureRandom = secureRandom != null ? secureRandom : io.dekorate.option.annotation.SecureRandomSource.Undefined;
    }


    public int getXms() {
        return this.xms;
    }

    public int getXmx() {
        return this.xmx;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean isUseStringDeduplication() {
        return this.useStringDeduplication;
    }

    public boolean isPreferIPv4Stack() {
        return this.preferIPv4Stack;
    }

    public boolean isHeapDumpOnOutOfMemoryError() {
        return this.heapDumpOnOutOfMemoryError;
    }

    public boolean isUseGCOverheadLimit() {
        return this.useGCOverheadLimit;
    }

    public GarbageCollector getGc() {
        return this.gc;
    }

    public SecureRandomSource getSecureRandom() {
        return this.secureRandom;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JvmConfig that = (JvmConfig) o;
        if (xms != that.xms) return false;
        if (xmx != that.xmx) return false;
        if (server != that.server) return false;
        if (useStringDeduplication != that.useStringDeduplication) return false;
        if (preferIPv4Stack != that.preferIPv4Stack) return false;
        if (heapDumpOnOutOfMemoryError != that.heapDumpOnOutOfMemoryError) return false;
        if (useGCOverheadLimit != that.useGCOverheadLimit) return false;
        if (gc != null ? !gc.equals(that.gc) :that.gc != null) return false;
        if (secureRandom != null ? !secureRandom.equals(that.secureRandom) :that.secureRandom != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(xms,  xmx,  server,  useStringDeduplication,  preferIPv4Stack,  heapDumpOnOutOfMemoryError,  useGCOverheadLimit,  gc,  secureRandom,  super.hashCode());
    }

}
