package io.dekorate.option.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GeneratorConfigBuilder extends GeneratorConfigFluentImpl<GeneratorConfigBuilder> implements VisitableBuilder<GeneratorConfig,GeneratorConfigBuilder>{

    GeneratorConfigFluent<?> fluent;
    Boolean validationEnabled;

    public GeneratorConfigBuilder(){
            this(true);
    }
    public GeneratorConfigBuilder(Boolean validationEnabled){
            this(new GeneratorConfig(), validationEnabled);
    }
    public GeneratorConfigBuilder(GeneratorConfigFluent<?> fluent){
            this(fluent, true);
    }
    public GeneratorConfigBuilder(GeneratorConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GeneratorConfig(), validationEnabled);
    }
    public GeneratorConfigBuilder(GeneratorConfigFluent<?> fluent,GeneratorConfig instance){
            this(fluent, instance, true);
    }
    public GeneratorConfigBuilder(GeneratorConfigFluent<?> fluent,GeneratorConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProject(instance.getProject()); 
            fluent.withAttributes(instance.getAttributes()); 
            fluent.withInputPath(instance.getInputPath()); 
            fluent.withOutputPath(instance.getOutputPath()); 
            this.validationEnabled = validationEnabled; 
    }
    public GeneratorConfigBuilder(GeneratorConfig instance){
            this(instance,true);
    }
    public GeneratorConfigBuilder(GeneratorConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProject(instance.getProject()); 
            this.withAttributes(instance.getAttributes()); 
            this.withInputPath(instance.getInputPath()); 
            this.withOutputPath(instance.getOutputPath()); 
            this.validationEnabled = validationEnabled; 
    }

    public EditableGeneratorConfig build(){
            EditableGeneratorConfig buildable = new EditableGeneratorConfig(fluent.getProject(),fluent.getAttributes(),fluent.getInputPath(),fluent.getOutputPath());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GeneratorConfigBuilder that = (GeneratorConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
