/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.handler;

import io.dekorate.DekorateException;
import io.dekorate.Handler;
import io.dekorate.Resources;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.option.config.EditableGeneratorConfig;
import io.dekorate.option.config.GeneratorConfig;
import io.dekorate.utils.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class GeneratorOptionsHandler
implements Handler<GeneratorConfig> {
    protected final Resources resources;
    protected final Function<String, InputStream> read;

    public GeneratorOptionsHandler(Resources resources, Function<String, InputStream> read) {
        this.resources = resources;
        this.read = read;
    }

    public int order() {
        return 100;
    }

    public void handle(GeneratorConfig config) {
        this.resources.groups().keySet().forEach(n -> this.read((String)n).forEach(i -> this.resources.add(n, i)));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(GeneratorConfig.class) || type.equals(EditableGeneratorConfig.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<HasMetadata> read(String name) {
        try (InputStream is = this.read.apply(name);){
            if (is == null) {
                List<HasMetadata> list = Collections.emptyList();
                return list;
            }
            KubernetesList list = Serialization.unmarshalAsList((InputStream)is);
            List list2 = list.getItems();
            return list2;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((String)("Failed ot read resource with name:" + name), (Throwable)e);
        }
    }
}

