/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.option.apt;

import io.dekorate.Session;
import io.dekorate.WithSession;
import io.dekorate.doc.Description;
import io.dekorate.option.annotation.GeneratorOptions;
import io.dekorate.option.handler.GeneratorOptionsHandler;
import io.dekorate.processor.AbstractAnnotationProcessor;
import io.dekorate.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@Description(value="Processing generator options, which are used for customizing the generation process")
@SupportedAnnotationTypes(value={"io.dekorate.option.annotation.GeneratorOptions"})
public class GeneratorOptionsProcessor
extends AbstractAnnotationProcessor
implements WithSession {
    private static final String INPUT_DIR = "dekorate.input.dir";
    private static final String OUTPUT_DIR = "dekorate.output.dir";

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Session session = this.getSession();
        if (roundEnv.processingOver()) {
            session.close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                GeneratorOptions options = element.getAnnotation(GeneratorOptions.class);
                if (options == null) continue;
                String inputPath = System.getProperty(INPUT_DIR, options.inputPath());
                String outputPath = System.getProperty(OUTPUT_DIR, options.outputPath());
                if (Strings.isNotNullOrEmpty((String)inputPath)) {
                    this.applyToProject(p -> p.withDekorateInputDir(inputPath));
                    session.handlers().add(new GeneratorOptionsHandler(session.resources(), new ResourceReader(inputPath)));
                }
                if (Strings.isNotNullOrEmpty((String)outputPath)) {
                    this.applyToProject(p -> p.withDekorateOutputDir(outputPath));
                }
                return false;
            }
        }
        return false;
    }

    private class ResourceReader
    implements Function<String, InputStream> {
        private final String path;

        private ResourceReader(String path) {
            this.path = path;
        }

        @Override
        public InputStream apply(String resource) {
            try {
                FileObject fileObject = GeneratorOptionsProcessor.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path + "/" + resource + "." + "yml");
                if (fileObject == null) {
                    fileObject = GeneratorOptionsProcessor.this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.path + "/" + resource + "." + "json");
                }
                return fileObject != null ? fileObject.openInputStream() : null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

