package io.dekorate.testing.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubernetesIntegrationTestConfigFluent<A extends KubernetesIntegrationTestConfigFluent<A>> extends BaseFluent<A>{
  public KubernetesIntegrationTestConfigFluent() {
  }
  
  public KubernetesIntegrationTestConfigFluent(KubernetesIntegrationTestConfig instance) {
    this.copyInstance(instance);
  }
  private boolean deployEnabled;
  private boolean buildEnabled;
  private long readinessTimeout;
  private List<String> additionalModules = new ArrayList<String>();
  
  protected void copyInstance(KubernetesIntegrationTestConfig instance) {
    instance = (instance != null ? instance : new KubernetesIntegrationTestConfig());
    if (instance != null) {
          this.withDeployEnabled(instance.isDeployEnabled());
          this.withBuildEnabled(instance.isBuildEnabled());
          this.withReadinessTimeout(instance.getReadinessTimeout());
          this.withAdditionalModules(instance.getAdditionalModules());
        }
  }
  
  public boolean isDeployEnabled() {
    return this.deployEnabled;
  }
  
  public A withDeployEnabled(boolean deployEnabled) {
    this.deployEnabled = deployEnabled;
    return (A) this;
  }
  
  public boolean hasDeployEnabled() {
    return true;
  }
  
  public boolean isBuildEnabled() {
    return this.buildEnabled;
  }
  
  public A withBuildEnabled(boolean buildEnabled) {
    this.buildEnabled = buildEnabled;
    return (A) this;
  }
  
  public boolean hasBuildEnabled() {
    return true;
  }
  
  public long getReadinessTimeout() {
    return this.readinessTimeout;
  }
  
  public A withReadinessTimeout(long readinessTimeout) {
    this.readinessTimeout = readinessTimeout;
    return (A) this;
  }
  
  public boolean hasReadinessTimeout() {
    return true;
  }
  
  public A withAdditionalModules(java.lang.String... additionalModules) {
    if (this.additionalModules != null) {
        this.additionalModules.clear();
        _visitables.remove("additionalModules");
    }
    if (additionalModules != null) {
      for (String item : additionalModules) {
        this.addToAdditionalModules(item);
      }
    }
    return (A) this;
  }
  
  public String[] getAdditionalModules() {
    int size = additionalModules != null ? additionalModules.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : additionalModules) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToAdditionalModules(int index,String item) {
    if (this.additionalModules == null) {this.additionalModules = new ArrayList<String>();}
    this.additionalModules.add(index, item);
    return (A)this;
  }
  
  public A setToAdditionalModules(int index,String item) {
    if (this.additionalModules == null) {this.additionalModules = new ArrayList<String>();}
    this.additionalModules.set(index, item); return (A)this;
  }
  
  public A addToAdditionalModules(java.lang.String... items) {
    if (this.additionalModules == null) {this.additionalModules = new ArrayList<String>();}
    for (String item : items) {this.additionalModules.add(item);} return (A)this;
  }
  
  public A addAllToAdditionalModules(Collection<String> items) {
    if (this.additionalModules == null) {this.additionalModules = new ArrayList<String>();}
    for (String item : items) {this.additionalModules.add(item);} return (A)this;
  }
  
  public A removeFromAdditionalModules(java.lang.String... items) {
    if (this.additionalModules == null) return (A)this;
    for (String item : items) { this.additionalModules.remove(item);} return (A)this;
  }
  
  public A removeAllFromAdditionalModules(Collection<String> items) {
    if (this.additionalModules == null) return (A)this;
    for (String item : items) { this.additionalModules.remove(item);} return (A)this;
  }
  
  public boolean hasAdditionalModules() {
    return this.additionalModules != null && !this.additionalModules.isEmpty();
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesIntegrationTestConfigFluent that = (KubernetesIntegrationTestConfigFluent) o;
    if (deployEnabled != that.deployEnabled) return false;
    if (buildEnabled != that.buildEnabled) return false;
    if (readinessTimeout != that.readinessTimeout) return false;
    if (!java.util.Objects.equals(additionalModules, that.additionalModules)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(deployEnabled,  buildEnabled,  readinessTimeout,  additionalModules,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    sb.append("deployEnabled:"); sb.append(deployEnabled + ",");
    sb.append("buildEnabled:"); sb.append(buildEnabled + ",");
    sb.append("readinessTimeout:"); sb.append(readinessTimeout + ",");
    if (additionalModules != null && !additionalModules.isEmpty()) { sb.append("additionalModules:"); sb.append(additionalModules); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withDeployEnabled() {
    return withDeployEnabled(true);
  }
  
  public A withBuildEnabled() {
    return withBuildEnabled(true);
  }
  

}