package io.dekorate.testing.adapter;

import io.dekorate.testing.annotation.KubernetesIntegrationTest;
import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import java.lang.Object;
import java.util.List;
import io.dekorate.testing.config.KubernetesIntegrationTestConfigBuilder;
import java.lang.String;
import java.util.Map;

public class KubernetesIntegrationTestConfigAdapter {


    public static KubernetesIntegrationTestConfig adapt(KubernetesIntegrationTest instance) {
        return newBuilder(instance).build();
    }

    public static KubernetesIntegrationTestConfigBuilder newBuilder(KubernetesIntegrationTest instance) {
        return new KubernetesIntegrationTestConfigBuilder(new io.dekorate.testing.config.KubernetesIntegrationTestConfig(instance.deployEnabled(),
                    instance.buildEnabled(),
                    instance.readinessTimeout()));
    }

    public static KubernetesIntegrationTestConfig adapt(Map map) {
        return new io.dekorate.testing.config.KubernetesIntegrationTestConfig(
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("deployEnabled","false") : "false")),
                       Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("buildEnabled","false") : "false")),
                       Long.parseLong(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("readinessTimeout","0") : "0")));
    }

    public static String[] toStringArray(Object o) {
                if (o instanceof String[]) {
                  return (String[]) o;
                }
                if (o instanceof String) {
                  String s =  (String) o;
                  return s.split(",[ ]*");
                }
                else if (o instanceof List) {
                  List c = (List) o;
                  String[] result = new String[c.size()]; 
                  for (int i=0; i <= c.size(); i++) {
                    result[i] = String.valueOf(c.get(i));
                  }
                  return result;
                }
                return new String[0];
            
    }

}
