/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.kubernetes;

import io.dekorate.DekorateException;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.utils.Serialization;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

public interface WithKubernetesConfig {
    public static final String CONFIG_DIR = "config";
    public static final String KUBERNETES_YML = "kubernetes.yml";

    default public boolean hasKubernetesConfig() {
        return this.getKubernetesConfigPath().toFile().exists();
    }

    default public KubernetesConfig getKubernetesConfig() {
        return this.getKubernetesConfig(this.getKubernetesConfigPath());
    }

    default public Path getKubernetesConfigPath() {
        new FileProjectFactory();
        Project p = FileProjectFactory.create((File)new File("."));
        return p.getBuildInfo().getClassOutputDir().resolve(p.getDekorateMetaDir()).resolve(CONFIG_DIR).resolve(KUBERNETES_YML);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public KubernetesConfig getKubernetesConfig(Path path) {
        File f = path.toFile();
        if (!f.exists()) throw new IllegalStateException("Expected to find kubernetes config at: " + path + "!");
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesConfig kubernetesConfig = (KubernetesConfig)Serialization.unmarshal((InputStream)is, KubernetesConfig.class);
            return kubernetesConfig;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }
}

