package io.dekorate.testing.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesIntegrationTestConfigBuilder extends KubernetesIntegrationTestConfigFluentImpl<KubernetesIntegrationTestConfigBuilder> implements VisitableBuilder<KubernetesIntegrationTestConfig,KubernetesIntegrationTestConfigBuilder> {

    KubernetesIntegrationTestConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesIntegrationTestConfigBuilder() {
        this(true);
    }

    public KubernetesIntegrationTestConfigBuilder(Boolean validationEnabled) {
        this(new KubernetesIntegrationTestConfig(), validationEnabled);
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfigFluent<?> fluent) {
        this(fluent, true);
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfigFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KubernetesIntegrationTestConfig(), validationEnabled);
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfigFluent<?> fluent,KubernetesIntegrationTestConfig instance) {
        this(fluent, instance, true);
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfigFluent<?> fluent,KubernetesIntegrationTestConfig instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployEnabled(instance.isDeployEnabled()); 
        fluent.withBuildEnabled(instance.isBuildEnabled()); 
        fluent.withReadinessTimeout(instance.getReadinessTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfig instance) {
        this(instance,true);
    }

    public KubernetesIntegrationTestConfigBuilder(KubernetesIntegrationTestConfig instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployEnabled(instance.isDeployEnabled()); 
        this.withBuildEnabled(instance.isBuildEnabled()); 
        this.withReadinessTimeout(instance.getReadinessTimeout()); 
        this.validationEnabled = validationEnabled; 
    }

    public EditableKubernetesIntegrationTestConfig build() {
        EditableKubernetesIntegrationTestConfig buildable = new EditableKubernetesIntegrationTestConfig(fluent.isDeployEnabled(),fluent.isBuildEnabled(),fluent.getReadinessTimeout());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubernetesIntegrationTestConfigBuilder that = (KubernetesIntegrationTestConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
