package io.dekorate.testing.config;

import java.lang.Object;
import java.lang.String;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class KubernetesIntegrationTestConfig{
  public KubernetesIntegrationTestConfig() {
  }
  public KubernetesIntegrationTestConfig(boolean deployEnabled,boolean buildEnabled,long readinessTimeout,String[] additionalModules) {
    this.deployEnabled = deployEnabled;
    this.buildEnabled = buildEnabled;
    this.readinessTimeout = readinessTimeout;
    this.additionalModules = additionalModules != null ? additionalModules : new java.lang.String[0];
  }
  private boolean deployEnabled;
  private boolean buildEnabled;
  private long readinessTimeout;
  private java.lang.String[] additionalModules = new java.lang.String[0];
  
  /**
   * Flag to define whether the extension should automatically apply resources.
   * @return True, if extension should automatically deploy dekorate generated resources.
   */
public boolean isDeployEnabled() {
    return this.deployEnabled;
  }
  
  /**
   * Flag to define whether the extension should automatically perform container builds.
   * @return True, if extensions should automatically perform container builds.
   */
public boolean isBuildEnabled() {
    return this.buildEnabled;
  }
  
  /**
   * The amount of time in milliseconds to wait for application to become ready.
   * @return The max amount in milliseconds.
   */
public long getReadinessTimeout() {
    return this.readinessTimeout;
  }
  
  /**
   * List of additional modules to be loaded by the test framework.
   * @return The list of additional modules to be loaded.
   */
public java.lang.String[] getAdditionalModules() {
    return this.additionalModules;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KubernetesIntegrationTestConfig that = (KubernetesIntegrationTestConfig) o;
    if (deployEnabled != that.deployEnabled) return false;
    if (buildEnabled != that.buildEnabled) return false;
    if (readinessTimeout != that.readinessTimeout) return false;
    if (additionalModules != null ? !additionalModules.equals(that.additionalModules) :that.additionalModules != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(deployEnabled,  buildEnabled,  readinessTimeout,  additionalModules,  super.hashCode());
  }
  
}