package io.dekorate.testing.config;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesIntegrationTestConfigFluentImpl<A extends KubernetesIntegrationTestConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KubernetesIntegrationTestConfigFluent<A> {

    private boolean deployEnabled = true;
    private boolean buildEnabled = true;
    private long readinessTimeout = 300000;

    public KubernetesIntegrationTestConfigFluentImpl() {
    }

    public KubernetesIntegrationTestConfigFluentImpl(KubernetesIntegrationTestConfig instance) {
        this.withDeployEnabled(instance.isDeployEnabled()); 
        this.withBuildEnabled(instance.isBuildEnabled()); 
        this.withReadinessTimeout(instance.getReadinessTimeout()); 
    }

    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    public A withDeployEnabled(boolean deployEnabled) {
        this.deployEnabled=deployEnabled; return (A) this;
    }

    public Boolean hasDeployEnabled() {
        return true;
    }

    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    public A withBuildEnabled(boolean buildEnabled) {
        this.buildEnabled=buildEnabled; return (A) this;
    }

    public Boolean hasBuildEnabled() {
        return true;
    }

    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    public A withReadinessTimeout(long readinessTimeout) {
        this.readinessTimeout=readinessTimeout; return (A) this;
    }

    public Boolean hasReadinessTimeout() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KubernetesIntegrationTestConfigFluentImpl that = (KubernetesIntegrationTestConfigFluentImpl) o;
        if (deployEnabled != that.deployEnabled) return false;
        if (buildEnabled != that.buildEnabled) return false;
        if (readinessTimeout != that.readinessTimeout) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployEnabled,  buildEnabled,  readinessTimeout,  super.hashCode());
    }

}
