package io.dekorate.testing.config;

import java.lang.Object;
import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.fabric8.kubernetes.api.builder") public class KubernetesIntegrationTestConfig {

    private boolean deployEnabled = true;
    private boolean buildEnabled = true;
    private long readinessTimeout = 300000;

    public KubernetesIntegrationTestConfig() {
    }

    public KubernetesIntegrationTestConfig(boolean deployEnabled,boolean buildEnabled,long readinessTimeout) {
        this.deployEnabled = deployEnabled;
        this.buildEnabled = buildEnabled;
        this.readinessTimeout = readinessTimeout;
    }

    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KubernetesIntegrationTestConfig that = (KubernetesIntegrationTestConfig) o;
        if (deployEnabled != that.deployEnabled) return false;
        if (buildEnabled != that.buildEnabled) return false;
        if (readinessTimeout != that.readinessTimeout) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployEnabled,  buildEnabled,  readinessTimeout,  super.hashCode());
    }

}
