package io.dekorate.testing.adapter;

import io.dekorate.testing.annotation.KubernetesIntegrationTest;
import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import io.dekorate.testing.config.KubernetesIntegrationTestConfigBuilder;
import java.util.Map;

public class KubernetesIntegrationTestConfigAdapter{



    public static KubernetesIntegrationTestConfig adapt(KubernetesIntegrationTest instance){
            return newBuilder(instance).build();
    }

    public static KubernetesIntegrationTestConfigBuilder newBuilder(KubernetesIntegrationTest instance){
            return new KubernetesIntegrationTestConfigBuilder(new io.dekorate.testing.config.KubernetesIntegrationTestConfig(instance.deployEnabled(),
            instance.buildEnabled(),
            instance.readinessTimeout()));
    }

    public static KubernetesIntegrationTestConfig adapt(Map map){
            return new io.dekorate.testing.config.KubernetesIntegrationTestConfig(
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("deployEnabled","true") : "true")),
               Boolean.parseBoolean(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("buildEnabled","true") : "true")),
               Long.parseLong(String.valueOf(map instanceof Map ? ((Map)map).getOrDefault("readinessTimeout","300000") : "300000")));
    }




}
