/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.kubernetes;

import io.dekorate.DekorateException;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.utils.Serialization;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public interface WithKubernetesConfig {
    public static final String KUBERNETES_CONFIG_PATH = "META-INF/dekorate/.config/kubernetes.yml";

    default public boolean hasKubernetesConfig() {
        return WithKubernetesConfig.class.getClassLoader().getResource(KUBERNETES_CONFIG_PATH) != null;
    }

    default public KubernetesConfig getKubernetesConfig() {
        return this.getKubernetesConfig(KUBERNETES_CONFIG_PATH);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public KubernetesConfig getKubernetesConfig(String path) {
        URL url = WithKubernetesConfig.class.getClassLoader().getResource(path);
        if (url == null) throw new IllegalStateException("Expected to find kubernetes config at: " + path + "!");
        try (InputStream is = url.openStream();){
            KubernetesConfig kubernetesConfig = (KubernetesConfig)Serialization.unmarshal((InputStream)is, KubernetesConfig.class);
            return kubernetesConfig;
        }
        catch (IOException e) {
            throw DekorateException.launderThrowable((Throwable)e);
        }
    }
}

