/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.kubernetes;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.BuildServiceFactory;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.PodList;
import io.dekorate.deps.kubernetes.api.model.ReplicationController;
import io.dekorate.deps.kubernetes.api.model.apps.Deployment;
import io.dekorate.deps.kubernetes.api.model.apps.ReplicaSet;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.dsl.Deletable;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.internal.readiness.Readiness;
import io.dekorate.deps.openshift.api.model.DeploymentConfig;
import io.dekorate.kubernetes.config.EditableImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.project.Project;
import io.dekorate.testing.Diagnostics;
import io.dekorate.testing.Pods;
import io.dekorate.testing.WithEvents;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.WithPod;
import io.dekorate.testing.WithProject;
import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesConfig;
import io.dekorate.testing.kubernetes.WithKubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesResources;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesExtension
implements ExecutionCondition,
BeforeAllCallback,
AfterAllCallback,
WithKubernetesIntegrationTestConfig,
WithPod,
WithKubernetesClient,
WithKubernetesResources,
WithEvents,
WithProject,
WithKubernetesConfig {
    private final Logger LOGGER = LoggerFactory.getLogger();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        try {
            VersionInfo version = this.getKubernetesClient(context).getVersion();
            String message = "Found version:" + version.getMajor() + "." + version.getMinor();
            this.LOGGER.info(message);
            return ConditionEvaluationResult.enabled((String)message);
        }
        catch (Throwable t) {
            String reason = "Could not communicate with KubernetesExtension API server.";
            this.LOGGER.error(reason);
            return ConditionEvaluationResult.disabled((String)reason);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        KubernetesIntegrationTestConfig config = this.getKubernetesIntegrationTestConfig(context);
        KubernetesClient client = this.getKubernetesClient(context);
        KubernetesList list = this.getKubernetesResources(context);
        if (this.hasKubernetesConfig()) {
            KubernetesConfig kubernetesConfig = this.getKubernetesConfig();
            EditableImageConfiguration imageConfiguration = ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withName(kubernetesConfig.getName())).withGroup(kubernetesConfig.getGroup())).withVersion(kubernetesConfig.getVersion())).withRegistry(kubernetesConfig.getRegistry())).build();
            BuildService buildService = null;
            try {
                BuildServiceFactory buildServiceFactory = (BuildServiceFactory)BuildServiceFactories.find((Project)this.getProject(), (ImageConfiguration)imageConfiguration).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                buildService = buildServiceFactory.create(this.getProject(), (ImageConfiguration)imageConfiguration, (Collection)list.getItems());
            }
            catch (Exception e) {
                throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
            }
            if (kubernetesConfig.isAutoPushEnabled()) {
                buildService.prepare();
                buildService.build();
                buildService.push();
            } else if (kubernetesConfig.isAutoBuildEnabled()) {
                buildService.prepare();
                buildService.build();
            } else if (config.isBuildEnabled()) {
                buildService.prepare();
                buildService.build();
            }
        }
        if (config.isDeployEnabled()) {
            list.getItems().stream().forEach(i -> {
                client.resourceList(new HasMetadata[]{i}).createOrReplace();
                this.LOGGER.info("Created: " + i.getKind() + " name:" + i.getMetadata().getName() + ".");
            });
            List waitables = list.getItems().stream().filter(i -> i instanceof Deployment || i instanceof DeploymentConfig || i instanceof Pod || i instanceof ReplicaSet || i instanceof ReplicationController).collect(Collectors.toList());
            long started = System.currentTimeMillis();
            this.LOGGER.info("Waiting until ready (" + config.getReadinessTimeout() + " ms)...");
            this.waitUntilCondition(context, waitables, i -> Readiness.isReady((HasMetadata)i), config.getReadinessTimeout(), TimeUnit.MILLISECONDS);
            long ended = System.currentTimeMillis();
            this.LOGGER.info("Waited: " + (ended - started) + " ms.");
            waitables.stream().map(r -> (HasMetadata)((Gettable)client.resource(r).fromServer()).get()).forEach(i -> {
                if (!Readiness.isReady((HasMetadata)i)) {
                    this.LOGGER.warning(i.getKind() + ":" + i.getMetadata().getName() + " not ready!");
                }
            });
        }
    }

    @Override
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> {
            this.injectKubernetesClient(context, testInstance, (Field)f);
            this.injectKubernetesResources(context, testInstance, (Field)f);
            this.injectPod(context, testInstance, (Field)f);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) {
        try {
            KubernetesClient client = this.getKubernetesClient(context);
            Diagnostics diagnostics = new Diagnostics(client);
            boolean failed = context.getExecutionException().isPresent();
            if (failed) {
                this.displayDiagnostics(context);
            }
            this.getKubernetesResources(context).getItems().stream().forEach(r -> this.LOGGER.info("Deleting: " + r.getKind() + " name:" + r.getMetadata().getName() + ". Deleted:" + ((Deletable)this.getKubernetesClient(context).resource(r).cascading(true)).delete()));
        }
        finally {
            this.closeKubernetesClient(context);
        }
    }

    public void displayDiagnostics(ExtensionContext context) {
        KubernetesClient client = this.getKubernetesClient(context);
        Pods pods = new Pods(client);
        PodList podList = pods.list((Object)pods);
        Diagnostics diagnostics = new Diagnostics(client, pods);
        if (podList == null || podList.getItems().isEmpty()) {
            diagnostics.displayAll();
        } else {
            this.getKubernetesResources(context).getItems().stream().forEach(r -> diagnostics.display(r));
        }
    }

    public String getName() {
        return this.getKubernetesConfig().getName();
    }
}

