/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.kubernetes;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.api.model.Pod;
import io.dekorate.deps.kubernetes.api.model.ReplicationController;
import io.dekorate.deps.kubernetes.api.model.apps.Deployment;
import io.dekorate.deps.kubernetes.api.model.apps.ReplicaSet;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.VersionInfo;
import io.dekorate.deps.kubernetes.client.dsl.Deletable;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.internal.readiness.Readiness;
import io.dekorate.deps.openshift.api.model.DeploymentConfig;
import io.dekorate.hook.OrderedHook;
import io.dekorate.hook.ProjectHook;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.hook.DockerBuildHook;
import io.dekorate.kubernetes.hook.DockerPushHook;
import io.dekorate.testing.WithEvents;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.WithPod;
import io.dekorate.testing.WithProject;
import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesConfig;
import io.dekorate.testing.kubernetes.WithKubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesResources;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubernetesExtension
implements ExecutionCondition,
BeforeAllCallback,
AfterAllCallback,
WithKubernetesIntegrationTestConfig,
WithPod,
WithKubernetesClient,
WithKubernetesResources,
WithEvents,
WithProject,
WithKubernetesConfig {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        try {
            VersionInfo version = this.getKubernetesClient(context).getVersion();
            return ConditionEvaluationResult.enabled((String)("Found version:" + version));
        }
        catch (Throwable t) {
            return ConditionEvaluationResult.disabled((String)"Could not communicate with KubernetesExtension API server.");
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        KubernetesIntegrationTestConfig config = this.getKubernetesIntegrationTestConfig(context);
        KubernetesClient client = this.getKubernetesClient(context);
        KubernetesList list = this.getKubernetesResources(context);
        if (this.hasKubernetesConfig()) {
            DockerBuildHook build;
            KubernetesConfig kubernetesConfig = this.getKubernetesConfig();
            if (kubernetesConfig.isAutoPushEnabled()) {
                DockerBuildHook buildHook = new DockerBuildHook(this.getProject(), kubernetesConfig);
                DockerPushHook pushHook = new DockerPushHook(this.getProject(), kubernetesConfig);
                OrderedHook hook = OrderedHook.create((ProjectHook[])new ProjectHook[]{buildHook, pushHook});
                hook.run();
            } else if (kubernetesConfig.isAutoBuildEnabled()) {
                build = new DockerBuildHook(this.getProject(), kubernetesConfig);
                build.run();
            } else if (config.isBuildEnabled()) {
                build = new DockerBuildHook(this.getProject(), kubernetesConfig);
                build.run();
            }
        }
        if (config.isDeployEnabled()) {
            list.getItems().stream().forEach(i -> {
                client.resourceList(new HasMetadata[]{i}).createOrReplace();
                System.out.println("Created: " + i.getKind() + " name:" + i.getMetadata().getName() + ".");
            });
            List waitables = list.getItems().stream().filter(i -> i instanceof Deployment || i instanceof DeploymentConfig || i instanceof Pod || i instanceof ReplicaSet || i instanceof ReplicationController).collect(Collectors.toList());
            long started = System.currentTimeMillis();
            System.out.println("Waiting until ready (" + config.getReadinessTimeout() + " ms)...");
            this.waitUntilCondition(context, waitables, i -> Readiness.isReady((HasMetadata)i), config.getReadinessTimeout(), TimeUnit.MILLISECONDS);
            long ended = System.currentTimeMillis();
            System.out.println("Waited: " + (ended - started) + " ms.");
            waitables.stream().map(r -> (HasMetadata)((Gettable)client.resource(r).fromServer()).get()).forEach(i -> {
                System.out.println(i.getKind() + ":" + i.getMetadata().getName() + " ready:" + Readiness.isReady((HasMetadata)i));
                if (!Readiness.isReady((HasMetadata)i)) {
                    this.getEvents(context, (HasMetadata)i).getItems().stream().forEach(e -> System.out.println(e.getMessage()));
                }
            });
        }
    }

    @Override
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> {
            this.injectKubernetesClient(context, testInstance, (Field)f);
            this.injectKubernetesResources(context, testInstance, (Field)f);
            this.injectPod(context, testInstance, (Field)f);
        });
    }

    public void afterAll(ExtensionContext context) {
        this.getKubernetesResources(context).getItems().stream().forEach(r -> System.out.println("Deleting: " + r.getKind() + " name:" + r.getMetadata().getName() + " status:" + ((Deletable)this.getKubernetesClient(context).resource(r).cascading(true)).delete()));
    }

    public String getName() {
        return this.getKubernetesConfig().getName();
    }
}

