package io.dekorate.testing.config;

import io.dekorate.deps.kubernetes.api.builder.Fluent;
import java.lang.Boolean;

public interface KubernetesIntegrationTestConfigFluent<A extends KubernetesIntegrationTestConfigFluent<A>> extends Fluent<A> {


    public boolean isDeployEnabled();
    public A withDeployEnabled(boolean deployEnabled);
    public Boolean hasDeployEnabled();
    public boolean isBuildEnabled();
    public A withBuildEnabled(boolean buildEnabled);
    public Boolean hasBuildEnabled();
    public long getReadinessTimeout();
    public A withReadinessTimeout(long readinessTimeout);
    public Boolean hasReadinessTimeout();
}
