package io.dekorate.testing.config;

import io.sundr.builder.annotations.Buildable;

@Buildable(builderPackage = "io.dekorate.deps.kubernetes.api.builder") public class KubernetesIntegrationTestConfig{

    private boolean deployEnabled = true;
    private boolean buildEnabled = true;
    private long readinessTimeout = 300000;

    public KubernetesIntegrationTestConfig(){
    }
    public KubernetesIntegrationTestConfig(boolean deployEnabled,boolean buildEnabled,long readinessTimeout){
            this.deployEnabled = deployEnabled;
            this.buildEnabled = buildEnabled;
            this.readinessTimeout = readinessTimeout;
    }

    public boolean isDeployEnabled(){
            return this.deployEnabled;
    }

    public boolean isBuildEnabled(){
            return this.buildEnabled;
    }

    public long getReadinessTimeout(){
            return this.readinessTimeout;
    }




}
