package io.dekorate.helm.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HelmExpressionFluent<A extends HelmExpressionFluent<A>> extends BaseFluent<A>{
  public HelmExpressionFluent() {
  }
  
  public HelmExpressionFluent(HelmExpression instance) {
    this.copyInstance(instance);
  }
  private String path;
  private String expression;
  
  protected void copyInstance(HelmExpression instance) {
    instance = (instance != null ? instance : new HelmExpression());
    if (instance != null) {
          this.withPath(instance.getPath());
          this.withExpression(instance.getExpression());
        }
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getExpression() {
    return this.expression;
  }
  
  public A withExpression(String expression) {
    this.expression = expression;
    return (A) this;
  }
  
  public boolean hasExpression() {
    return this.expression != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmExpressionFluent that = (HelmExpressionFluent) o;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(expression, that.expression)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(path,  expression,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (expression != null) { sb.append("expression:"); sb.append(expression); }
    sb.append("}");
    return sb.toString();
  }
  

}