package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ValuesSchemaFluent<A extends ValuesSchemaFluent<A>> extends BaseFluent<A>{
  public ValuesSchemaFluent() {
  }
  
  public ValuesSchemaFluent(ValuesSchema instance) {
    this.copyInstance(instance);
  }
  private String title;
  private ArrayList<ValuesSchemaPropertyBuilder> properties = new ArrayList<ValuesSchemaPropertyBuilder>();
  
  protected void copyInstance(ValuesSchema instance) {
    instance = (instance != null ? instance : new ValuesSchema());
    if (instance != null) {
          this.withTitle(instance.getTitle());
          this.withProperties(instance.getProperties());
        }
  }
  
  public String getTitle() {
    return this.title;
  }
  
  public A withTitle(String title) {
    this.title = title;
    return (A) this;
  }
  
  public boolean hasTitle() {
    return this.title != null;
  }
  
  public A withProperties(io.dekorate.helm.config.ValuesSchemaProperty... properties) {
    if (this.properties != null) {
        this.properties.clear();
        _visitables.remove("properties");
    }
    if (properties != null) {
      for (ValuesSchemaProperty item : properties) {
        this.addToProperties(item);
      }
    }
    return (A) this;
  }
  
  public ValuesSchemaProperty[] buildProperties() {
    int size = properties != null ? properties.size() : 0;;
    ValuesSchemaProperty[] result = new ValuesSchemaProperty[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<ValuesSchemaProperty,ValuesSchemaPropertyBuilder> item : properties) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public ValuesSchemaProperty buildProperty(int index) {
    return this.properties.get(index).build();
  }
  
  public ValuesSchemaProperty buildFirstProperty() {
    return this.properties.get(0).build();
  }
  
  public ValuesSchemaProperty buildLastProperty() {
    return this.properties.get(properties.size() - 1).build();
  }
  
  public ValuesSchemaProperty buildMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
      for (ValuesSchemaPropertyBuilder item : properties) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
      for (ValuesSchemaPropertyBuilder item : properties) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToProperties(int index,ValuesSchemaProperty item) {
    if (this.properties == null) {this.properties = new ArrayList<ValuesSchemaPropertyBuilder>();}
    ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
    if (index < 0 || index >= properties.size()) { _visitables.get("properties").add(builder); properties.add(builder); } else { _visitables.get("properties").add(index, builder); properties.add(index, builder);}
    return (A)this;
  }
  
  public A setToProperties(int index,ValuesSchemaProperty item) {
    if (this.properties == null) {this.properties = new ArrayList<ValuesSchemaPropertyBuilder>();}
    ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
    if (index < 0 || index >= properties.size()) { _visitables.get("properties").add(builder); properties.add(builder); } else { _visitables.get("properties").set(index, builder); properties.set(index, builder);}
    return (A)this;
  }
  
  public A addToProperties(io.dekorate.helm.config.ValuesSchemaProperty... items) {
    if (this.properties == null) {this.properties = new ArrayList<ValuesSchemaPropertyBuilder>();}
    for (ValuesSchemaProperty item : items) {ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);_visitables.get("properties").add(builder);this.properties.add(builder);} return (A)this;
  }
  
  public A addAllToProperties(Collection<ValuesSchemaProperty> items) {
    if (this.properties == null) {this.properties = new ArrayList<ValuesSchemaPropertyBuilder>();}
    for (ValuesSchemaProperty item : items) {ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);_visitables.get("properties").add(builder);this.properties.add(builder);} return (A)this;
  }
  
  public A removeFromProperties(io.dekorate.helm.config.ValuesSchemaProperty... items) {
    if (this.properties == null) return (A)this;
    for (ValuesSchemaProperty item : items) {ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);_visitables.get("properties").remove(builder); this.properties.remove(builder);} return (A)this;
  }
  
  public A removeAllFromProperties(Collection<ValuesSchemaProperty> items) {
    if (this.properties == null) return (A)this;
    for (ValuesSchemaProperty item : items) {ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);_visitables.get("properties").remove(builder); this.properties.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromProperties(Predicate<ValuesSchemaPropertyBuilder> predicate) {
    if (properties == null) return (A) this;
    final Iterator<ValuesSchemaPropertyBuilder> each = properties.iterator();
    final List visitables = _visitables.get("properties");
    while (each.hasNext()) {
      ValuesSchemaPropertyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasProperties() {
    return this.properties != null && !this.properties.isEmpty();
  }
  
  public PropertiesNested<A> addNewProperty() {
    return new PropertiesNested(-1, null);
  }
  
  public PropertiesNested<A> addNewPropertyLike(ValuesSchemaProperty item) {
    return new PropertiesNested(-1, item);
  }
  
  public PropertiesNested<A> setNewPropertyLike(int index,ValuesSchemaProperty item) {
    return new PropertiesNested(index, item);
  }
  
  public PropertiesNested<A> editProperty(int index) {
    if (properties.size() <= index) throw new RuntimeException("Can't edit properties. Index exceeds size.");
    return setNewPropertyLike(index, buildProperty(index));
  }
  
  public PropertiesNested<A> editFirstProperty() {
    if (properties.size() == 0) throw new RuntimeException("Can't edit first properties. The list is empty.");
    return setNewPropertyLike(0, buildProperty(0));
  }
  
  public PropertiesNested<A> editLastProperty() {
    int index = properties.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last properties. The list is empty.");
    return setNewPropertyLike(index, buildProperty(index));
  }
  
  public PropertiesNested<A> editMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<properties.size();i++) { 
    if (predicate.test(properties.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching properties. No match found.");
    return setNewPropertyLike(index, buildProperty(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValuesSchemaFluent that = (ValuesSchemaFluent) o;
    if (!java.util.Objects.equals(title, that.title)) return false;
    if (!java.util.Objects.equals(properties, that.properties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(title,  properties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (title != null) { sb.append("title:"); sb.append(title + ","); }
    if (properties != null && !properties.isEmpty()) { sb.append("properties:"); sb.append(properties); }
    sb.append("}");
    return sb.toString();
  }
  public class PropertiesNested<N> extends ValuesSchemaPropertyFluent<PropertiesNested<N>> implements Nested<N>{
    PropertiesNested(int index,ValuesSchemaProperty item) {
      this.index = index;
      this.builder = new ValuesSchemaPropertyBuilder(this, item);
    }
    ValuesSchemaPropertyBuilder builder;
    int index;
    
    public N and() {
      return (N) ValuesSchemaFluent.this.setToProperties(index,builder.build());
    }
    
    public N endProperty() {
      return and();
    }
    
  
  }

}