package io.dekorate.helm.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HelmDependencyFluent<A extends HelmDependencyFluent<A>> extends BaseFluent<A>{
  public HelmDependencyFluent() {
  }
  
  public HelmDependencyFluent(HelmDependency instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String version;
  private String repository;
  private String condition;
  private List<String> tags = new ArrayList<String>();
  private Boolean enabled;
  private String alias;
  
  protected void copyInstance(HelmDependency instance) {
    instance = (instance != null ? instance : new HelmDependency());
    if (instance != null) {
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withRepository(instance.getRepository());
          this.withCondition(instance.getCondition());
          this.withTags(instance.getTags());
          this.withEnabled(instance.getEnabled());
          this.withAlias(instance.getAlias());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public String getRepository() {
    return this.repository;
  }
  
  public A withRepository(String repository) {
    this.repository = repository;
    return (A) this;
  }
  
  public boolean hasRepository() {
    return this.repository != null;
  }
  
  public String getCondition() {
    return this.condition;
  }
  
  public A withCondition(String condition) {
    this.condition = condition;
    return (A) this;
  }
  
  public boolean hasCondition() {
    return this.condition != null;
  }
  
  public A withTags(java.lang.String... tags) {
    if (this.tags != null) {
        this.tags.clear();
        _visitables.remove("tags");
    }
    if (tags != null) {
      for (String item : tags) {
        this.addToTags(item);
      }
    }
    return (A) this;
  }
  
  public String[] getTags() {
    int size = tags != null ? tags.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : tags) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.add(index, item);
    return (A)this;
  }
  
  public A setToTags(int index,String item) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    this.tags.set(index, item); return (A)this;
  }
  
  public A addToTags(java.lang.String... items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  
  public A addAllToTags(Collection<String> items) {
    if (this.tags == null) {this.tags = new ArrayList<String>();}
    for (String item : items) {this.tags.add(item);} return (A)this;
  }
  
  public A removeFromTags(java.lang.String... items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  
  public A removeAllFromTags(Collection<String> items) {
    if (this.tags == null) return (A)this;
    for (String item : items) { this.tags.remove(item);} return (A)this;
  }
  
  public boolean hasTags() {
    return this.tags != null && !this.tags.isEmpty();
  }
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public A withEnabled(Boolean enabled) {
    this.enabled = enabled;
    return (A) this;
  }
  
  public boolean hasEnabled() {
    return this.enabled != null;
  }
  
  public String getAlias() {
    return this.alias;
  }
  
  public A withAlias(String alias) {
    this.alias = alias;
    return (A) this;
  }
  
  public boolean hasAlias() {
    return this.alias != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmDependencyFluent that = (HelmDependencyFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(repository, that.repository)) return false;
    if (!java.util.Objects.equals(condition, that.condition)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    if (!java.util.Objects.equals(alias, that.alias)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  version,  repository,  condition,  tags,  enabled,  alias,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (tags != null && !tags.isEmpty()) { sb.append("tags:"); sb.append(tags + ","); }
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (alias != null) { sb.append("alias:"); sb.append(alias); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEnabled() {
    return withEnabled(true);
  }
  

}