/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.AddIfStatement;
import io.dekorate.helm.config.AddIfStatementBuilder;
import io.dekorate.helm.config.AddIfStatementFluent;
import io.dekorate.helm.config.Annotation;
import io.dekorate.helm.config.AnnotationBuilder;
import io.dekorate.helm.config.AnnotationFluent;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.HelmDependencyBuilder;
import io.dekorate.helm.config.HelmDependencyFluent;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.HelmExpressionBuilder;
import io.dekorate.helm.config.HelmExpressionFluent;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.helm.config.MaintainerBuilder;
import io.dekorate.helm.config.MaintainerFluent;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.config.ValueReferenceBuilder;
import io.dekorate.helm.config.ValueReferenceFluent;
import io.dekorate.helm.config.ValuesSchema;
import io.dekorate.helm.config.ValuesSchemaBuilder;
import io.dekorate.helm.config.ValuesSchemaFluent;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HelmChartConfigFluent<A extends HelmChartConfigFluent<A>>
extends ConfigurationFluent<A> {
    private Boolean enabled;
    private String name;
    private String home;
    private List<String> sources = new ArrayList<String>();
    private String version;
    private String description;
    private List<String> keywords = new ArrayList<String>();
    private ArrayList<MaintainerBuilder> maintainers = new ArrayList();
    private String icon;
    private String apiVersion;
    private String condition;
    private String tags;
    private String appVersion;
    private Boolean deprecated;
    private ArrayList<AnnotationBuilder> annotations = new ArrayList();
    private String kubeVersion;
    private ArrayList<HelmDependencyBuilder> dependencies = new ArrayList();
    private String type;
    private String valuesRootAlias;
    private String valuesProfileSeparator;
    private Boolean createTarFile;
    private Boolean createValuesSchemaFile;
    private Boolean createReadmeFile;
    private String extension;
    private String tarFileClassifier;
    private String notes;
    private String inputFolder;
    private String outputFolder;
    private ArrayList<ValueReferenceBuilder> values = new ArrayList();
    private ValuesSchemaBuilder valuesSchema;
    private ArrayList<HelmExpressionBuilder> expressions = new ArrayList();
    private ArrayList<AddIfStatementBuilder> addIfStatements = new ArrayList();

    public HelmChartConfigFluent() {
    }

    public HelmChartConfigFluent(HelmChartConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HelmChartConfig instance) {
        HelmChartConfig helmChartConfig = instance = instance != null ? instance : new HelmChartConfig();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withEnabled(instance.getEnabled());
            this.withName(instance.getName());
            this.withHome(instance.getHome());
            this.withSources(instance.getSources());
            this.withVersion(instance.getVersion());
            this.withDescription(instance.getDescription());
            this.withKeywords(instance.getKeywords());
            this.withMaintainers(instance.getMaintainers());
            this.withIcon(instance.getIcon());
            this.withApiVersion(instance.getApiVersion());
            this.withCondition(instance.getCondition());
            this.withTags(instance.getTags());
            this.withAppVersion(instance.getAppVersion());
            this.withDeprecated(instance.getDeprecated());
            this.withAnnotations(instance.getAnnotations());
            this.withKubeVersion(instance.getKubeVersion());
            this.withDependencies(instance.getDependencies());
            this.withType(instance.getType());
            this.withValuesRootAlias(instance.getValuesRootAlias());
            this.withValuesProfileSeparator(instance.getValuesProfileSeparator());
            this.withCreateTarFile(instance.getCreateTarFile());
            this.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile());
            this.withCreateReadmeFile(instance.getCreateReadmeFile());
            this.withExtension(instance.getExtension());
            this.withTarFileClassifier(instance.getTarFileClassifier());
            this.withNotes(instance.getNotes());
            this.withInputFolder(instance.getInputFolder());
            this.withOutputFolder(instance.getOutputFolder());
            this.withValues(instance.getValues());
            this.withValuesSchema(instance.getValuesSchema());
            this.withExpressions(instance.getExpressions());
            this.withAddIfStatements(instance.getAddIfStatements());
        }
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getHome() {
        return this.home;
    }

    public A withHome(String home) {
        this.home = home;
        return (A)((Object)this);
    }

    public boolean hasHome() {
        return this.home != null;
    }

    public A withSources(String ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (String item : sources) {
                this.addToSources(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getSources() {
        int size = this.sources != null ? this.sources.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.sources) {
            result[index++] = item;
        }
        return result;
    }

    public A addToSources(int index, String item) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(index, item);
        return (A)((Object)this);
    }

    public A setToSources(int index, String item) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.set(index, item);
        return (A)((Object)this);
    }

    public A addToSources(String ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        for (String item : items) {
            this.sources.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToSources(Collection<String> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        for (String item : items) {
            this.sources.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromSources(String ... items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sources.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSources(Collection<String> items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.sources.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
            this._visitables.remove((Object)"keywords");
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getKeywords() {
        int size = this.keywords != null ? this.keywords.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.keywords) {
            result[index++] = item;
        }
        return result;
    }

    public A addToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)((Object)this);
    }

    public A setToKeywords(int index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)((Object)this);
    }

    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKeywords(String ... items) {
        if (this.keywords == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKeywords(Collection<String> items) {
        if (this.keywords == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.keywords.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    public A withMaintainers(Maintainer ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
            this._visitables.remove((Object)"maintainers");
        }
        if (maintainers != null) {
            for (Maintainer item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)((Object)this);
    }

    public Maintainer[] buildMaintainers() {
        int size = this.maintainers != null ? this.maintainers.size() : 0;
        Maintainer[] result = new Maintainer[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.maintainers) {
            result[index++] = (Maintainer)visitableBuilder.build();
        }
        return result;
    }

    public Maintainer buildMaintainer(int index) {
        return this.maintainers.get(index).build();
    }

    public Maintainer buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    public Maintainer buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToMaintainers(int index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get((Object)"maintainers").add(index, builder);
            this.maintainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMaintainers(int index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= this.maintainers.size()) {
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        } else {
            this._visitables.get((Object)"maintainers").set(index, builder);
            this.maintainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMaintainers(Maintainer ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMaintainers(Maintainer ... items) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").remove((Object)builder);
            this.maintainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").remove((Object)builder);
            this.maintainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
        if (this.maintainers == null) {
            return (A)((Object)this);
        }
        Iterator<MaintainerBuilder> each = this.maintainers.iterator();
        List visitables = this._visitables.get((Object)"maintainers");
        while (each.hasNext()) {
            MaintainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    public A addNewMaintainer(String name, String email, String url) {
        return this.addToMaintainers(new Maintainer(name, email, url));
    }

    public MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNested(-1, null);
    }

    public MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
        return new MaintainersNested(-1, item);
    }

    public MaintainersNested<A> setNewMaintainerLike(int index, Maintainer item) {
        return new MaintainersNested(index, item);
    }

    public MaintainersNested<A> editMaintainer(int index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    public MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.test(this.maintainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    public String getIcon() {
        return this.icon;
    }

    public A withIcon(String icon) {
        this.icon = icon;
        return (A)((Object)this);
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getCondition() {
        return this.condition;
    }

    public A withCondition(String condition) {
        this.condition = condition;
        return (A)((Object)this);
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public String getTags() {
        return this.tags;
    }

    public A withTags(String tags) {
        this.tags = tags;
        return (A)((Object)this);
    }

    public boolean hasTags() {
        return this.tags != null;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public A withAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return (A)((Object)this);
    }

    public boolean hasAppVersion() {
        return this.appVersion != null;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public A withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return (A)((Object)this);
    }

    public boolean hasDeprecated() {
        return this.deprecated != null;
    }

    public A withAnnotations(Annotation ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
            this._visitables.remove((Object)"annotations");
        }
        if (annotations != null) {
            for (Annotation item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)((Object)this);
    }

    public Annotation[] buildAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    public Annotation buildAnnotation(int index) {
        return this.annotations.get(index).build();
    }

    public Annotation buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    public Annotation buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAnnotations(int index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").add(index, builder);
            this.annotations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAnnotations(int index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this.annotations.size()) {
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
            this.annotations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove((Object)builder);
            this.annotations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        Iterator<AnnotationBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    public A addNewAnnotation(String key, String value) {
        return this.addToAnnotations(new Annotation(key, value));
    }

    public AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNested(-1, null);
    }

    public AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
        return new AnnotationsNested(-1, item);
    }

    public AnnotationsNested<A> setNewAnnotationLike(int index, Annotation item) {
        return new AnnotationsNested(index, item);
    }

    public AnnotationsNested<A> editAnnotation(int index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    public AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    public String getKubeVersion() {
        return this.kubeVersion;
    }

    public A withKubeVersion(String kubeVersion) {
        this.kubeVersion = kubeVersion;
        return (A)((Object)this);
    }

    public boolean hasKubeVersion() {
        return this.kubeVersion != null;
    }

    public A withDependencies(HelmDependency ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (HelmDependency item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public HelmDependency[] buildDependencies() {
        int size = this.dependencies != null ? this.dependencies.size() : 0;
        HelmDependency[] result = new HelmDependency[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.dependencies) {
            result[index++] = (HelmDependency)visitableBuilder.build();
        }
        return result;
    }

    public HelmDependency buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public HelmDependency buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public HelmDependency buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        for (HelmDependencyBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        for (HelmDependencyBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToDependencies(int index, HelmDependency item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDependencies(int index, HelmDependency item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDependencies(HelmDependency ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<HelmDependency> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(HelmDependency ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<HelmDependency> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        Iterator<HelmDependencyBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            HelmDependencyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public DependenciesNested<A> addNewDependency() {
        return new DependenciesNested(-1, null);
    }

    public DependenciesNested<A> addNewDependencyLike(HelmDependency item) {
        return new DependenciesNested(-1, item);
    }

    public DependenciesNested<A> setNewDependencyLike(int index, HelmDependency item) {
        return new DependenciesNested(index, item);
    }

    public DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    public DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getValuesRootAlias() {
        return this.valuesRootAlias;
    }

    public A withValuesRootAlias(String valuesRootAlias) {
        this.valuesRootAlias = valuesRootAlias;
        return (A)((Object)this);
    }

    public boolean hasValuesRootAlias() {
        return this.valuesRootAlias != null;
    }

    public String getValuesProfileSeparator() {
        return this.valuesProfileSeparator;
    }

    public A withValuesProfileSeparator(String valuesProfileSeparator) {
        this.valuesProfileSeparator = valuesProfileSeparator;
        return (A)((Object)this);
    }

    public boolean hasValuesProfileSeparator() {
        return this.valuesProfileSeparator != null;
    }

    public Boolean getCreateTarFile() {
        return this.createTarFile;
    }

    public A withCreateTarFile(Boolean createTarFile) {
        this.createTarFile = createTarFile;
        return (A)((Object)this);
    }

    public boolean hasCreateTarFile() {
        return this.createTarFile != null;
    }

    public Boolean getCreateValuesSchemaFile() {
        return this.createValuesSchemaFile;
    }

    public A withCreateValuesSchemaFile(Boolean createValuesSchemaFile) {
        this.createValuesSchemaFile = createValuesSchemaFile;
        return (A)((Object)this);
    }

    public boolean hasCreateValuesSchemaFile() {
        return this.createValuesSchemaFile != null;
    }

    public Boolean getCreateReadmeFile() {
        return this.createReadmeFile;
    }

    public A withCreateReadmeFile(Boolean createReadmeFile) {
        this.createReadmeFile = createReadmeFile;
        return (A)((Object)this);
    }

    public boolean hasCreateReadmeFile() {
        return this.createReadmeFile != null;
    }

    public String getExtension() {
        return this.extension;
    }

    public A withExtension(String extension) {
        this.extension = extension;
        return (A)((Object)this);
    }

    public boolean hasExtension() {
        return this.extension != null;
    }

    public String getTarFileClassifier() {
        return this.tarFileClassifier;
    }

    public A withTarFileClassifier(String tarFileClassifier) {
        this.tarFileClassifier = tarFileClassifier;
        return (A)((Object)this);
    }

    public boolean hasTarFileClassifier() {
        return this.tarFileClassifier != null;
    }

    public String getNotes() {
        return this.notes;
    }

    public A withNotes(String notes) {
        this.notes = notes;
        return (A)((Object)this);
    }

    public boolean hasNotes() {
        return this.notes != null;
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    public A withInputFolder(String inputFolder) {
        this.inputFolder = inputFolder;
        return (A)((Object)this);
    }

    public boolean hasInputFolder() {
        return this.inputFolder != null;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public A withOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
        return (A)((Object)this);
    }

    public boolean hasOutputFolder() {
        return this.outputFolder != null;
    }

    public A withValues(ValueReference ... values) {
        if (this.values != null) {
            this.values.clear();
            this._visitables.remove((Object)"values");
        }
        if (values != null) {
            for (ValueReference item : values) {
                this.addToValues(item);
            }
        }
        return (A)((Object)this);
    }

    public ValueReference[] buildValues() {
        int size = this.values != null ? this.values.size() : 0;
        ValueReference[] result = new ValueReference[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.values) {
            result[index++] = (ValueReference)visitableBuilder.build();
        }
        return result;
    }

    public ValueReference buildValue(int index) {
        return this.values.get(index).build();
    }

    public ValueReference buildFirstValue() {
        return this.values.get(0).build();
    }

    public ValueReference buildLastValue() {
        return this.values.get(this.values.size() - 1).build();
    }

    public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        for (ValueReferenceBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        for (ValueReferenceBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToValues(int index, ValueReference item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").add(index, builder);
            this.values.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToValues(int index, ValueReference item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
        if (index < 0 || index >= this.values.size()) {
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        } else {
            this._visitables.get((Object)"values").set(index, builder);
            this.values.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToValues(ValueReference ... items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToValues(Collection<ValueReference> items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromValues(ValueReference ... items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromValues(Collection<ValueReference> items) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").remove((Object)builder);
            this.values.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate) {
        if (this.values == null) {
            return (A)((Object)this);
        }
        Iterator<ValueReferenceBuilder> each = this.values.iterator();
        List visitables = this._visitables.get((Object)"values");
        while (each.hasNext()) {
            ValueReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    public ValuesNested<A> addNewValue() {
        return new ValuesNested(-1, null);
    }

    public ValuesNested<A> addNewValueLike(ValueReference item) {
        return new ValuesNested(-1, item);
    }

    public ValuesNested<A> setNewValueLike(int index, ValueReference item) {
        return new ValuesNested(index, item);
    }

    public ValuesNested<A> editValue(int index) {
        if (this.values.size() <= index) {
            throw new RuntimeException("Can't edit values. Index exceeds size.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editFirstValue() {
        if (this.values.size() == 0) {
            throw new RuntimeException("Can't edit first values. The list is empty.");
        }
        return this.setNewValueLike(0, this.buildValue(0));
    }

    public ValuesNested<A> editLastValue() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last values. The list is empty.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching values. No match found.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    public ValuesSchema buildValuesSchema() {
        return this.valuesSchema != null ? this.valuesSchema.build() : null;
    }

    public A withValuesSchema(ValuesSchema valuesSchema) {
        this._visitables.remove((Object)"valuesSchema");
        if (valuesSchema != null) {
            this.valuesSchema = new ValuesSchemaBuilder(valuesSchema);
            this._visitables.get((Object)"valuesSchema").add(this.valuesSchema);
        } else {
            this.valuesSchema = null;
            this._visitables.get((Object)"valuesSchema").remove((Object)this.valuesSchema);
        }
        return (A)((Object)this);
    }

    public boolean hasValuesSchema() {
        return this.valuesSchema != null;
    }

    public ValuesSchemaNested<A> withNewValuesSchema() {
        return new ValuesSchemaNested(null);
    }

    public ValuesSchemaNested<A> withNewValuesSchemaLike(ValuesSchema item) {
        return new ValuesSchemaNested(item);
    }

    public ValuesSchemaNested<A> editValuesSchema() {
        return this.withNewValuesSchemaLike(Optional.ofNullable(this.buildValuesSchema()).orElse(null));
    }

    public ValuesSchemaNested<A> editOrNewValuesSchema() {
        return this.withNewValuesSchemaLike(Optional.ofNullable(this.buildValuesSchema()).orElse(new ValuesSchemaBuilder().build()));
    }

    public ValuesSchemaNested<A> editOrNewValuesSchemaLike(ValuesSchema item) {
        return this.withNewValuesSchemaLike(Optional.ofNullable(this.buildValuesSchema()).orElse(item));
    }

    public A withExpressions(HelmExpression ... expressions) {
        if (this.expressions != null) {
            this.expressions.clear();
            this._visitables.remove((Object)"expressions");
        }
        if (expressions != null) {
            for (HelmExpression item : expressions) {
                this.addToExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public HelmExpression[] buildExpressions() {
        int size = this.expressions != null ? this.expressions.size() : 0;
        HelmExpression[] result = new HelmExpression[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.expressions) {
            result[index++] = (HelmExpression)visitableBuilder.build();
        }
        return result;
    }

    public HelmExpression buildExpression(int index) {
        return this.expressions.get(index).build();
    }

    public HelmExpression buildFirstExpression() {
        return this.expressions.get(0).build();
    }

    public HelmExpression buildLastExpression() {
        return this.expressions.get(this.expressions.size() - 1).build();
    }

    public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        for (HelmExpressionBuilder item : this.expressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        for (HelmExpressionBuilder item : this.expressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToExpressions(int index, HelmExpression item) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
        if (index < 0 || index >= this.expressions.size()) {
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        } else {
            this._visitables.get((Object)"expressions").add(index, builder);
            this.expressions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExpressions(int index, HelmExpression item) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
        if (index < 0 || index >= this.expressions.size()) {
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        } else {
            this._visitables.get((Object)"expressions").set(index, builder);
            this.expressions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExpressions(HelmExpression ... items) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToExpressions(Collection<HelmExpression> items) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExpressions(HelmExpression ... items) {
        if (this.expressions == null) {
            return (A)((Object)this);
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").remove((Object)builder);
            this.expressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromExpressions(Collection<HelmExpression> items) {
        if (this.expressions == null) {
            return (A)((Object)this);
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").remove((Object)builder);
            this.expressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate) {
        if (this.expressions == null) {
            return (A)((Object)this);
        }
        Iterator<HelmExpressionBuilder> each = this.expressions.iterator();
        List visitables = this._visitables.get((Object)"expressions");
        while (each.hasNext()) {
            HelmExpressionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasExpressions() {
        return this.expressions != null && !this.expressions.isEmpty();
    }

    public A addNewExpression(String path, String expression) {
        return this.addToExpressions(new HelmExpression(path, expression));
    }

    public ExpressionsNested<A> addNewExpression() {
        return new ExpressionsNested(-1, null);
    }

    public ExpressionsNested<A> addNewExpressionLike(HelmExpression item) {
        return new ExpressionsNested(-1, item);
    }

    public ExpressionsNested<A> setNewExpressionLike(int index, HelmExpression item) {
        return new ExpressionsNested(index, item);
    }

    public ExpressionsNested<A> editExpression(int index) {
        if (this.expressions.size() <= index) {
            throw new RuntimeException("Can't edit expressions. Index exceeds size.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    public ExpressionsNested<A> editFirstExpression() {
        if (this.expressions.size() == 0) {
            throw new RuntimeException("Can't edit first expressions. The list is empty.");
        }
        return this.setNewExpressionLike(0, this.buildExpression(0));
    }

    public ExpressionsNested<A> editLastExpression() {
        int index = this.expressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last expressions. The list is empty.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    public ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.expressions.size(); ++i) {
            if (!predicate.test(this.expressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching expressions. No match found.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    public A withAddIfStatements(AddIfStatement ... addIfStatements) {
        if (this.addIfStatements != null) {
            this.addIfStatements.clear();
            this._visitables.remove((Object)"addIfStatements");
        }
        if (addIfStatements != null) {
            for (AddIfStatement item : addIfStatements) {
                this.addToAddIfStatements(item);
            }
        }
        return (A)((Object)this);
    }

    public AddIfStatement[] buildAddIfStatements() {
        int size = this.addIfStatements != null ? this.addIfStatements.size() : 0;
        AddIfStatement[] result = new AddIfStatement[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.addIfStatements) {
            result[index++] = (AddIfStatement)visitableBuilder.build();
        }
        return result;
    }

    public AddIfStatement buildAddIfStatement(int index) {
        return this.addIfStatements.get(index).build();
    }

    public AddIfStatement buildFirstAddIfStatement() {
        return this.addIfStatements.get(0).build();
    }

    public AddIfStatement buildLastAddIfStatement() {
        return this.addIfStatements.get(this.addIfStatements.size() - 1).build();
    }

    public AddIfStatement buildMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        for (AddIfStatementBuilder item : this.addIfStatements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        for (AddIfStatementBuilder item : this.addIfStatements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAddIfStatements(int index, AddIfStatement item) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
        if (index < 0 || index >= this.addIfStatements.size()) {
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        } else {
            this._visitables.get((Object)"addIfStatements").add(index, builder);
            this.addIfStatements.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddIfStatements(int index, AddIfStatement item) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
        if (index < 0 || index >= this.addIfStatements.size()) {
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        } else {
            this._visitables.get((Object)"addIfStatements").set(index, builder);
            this.addIfStatements.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddIfStatements(AddIfStatement ... items) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddIfStatements(Collection<AddIfStatement> items) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddIfStatements(AddIfStatement ... items) {
        if (this.addIfStatements == null) {
            return (A)((Object)this);
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").remove((Object)builder);
            this.addIfStatements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddIfStatements(Collection<AddIfStatement> items) {
        if (this.addIfStatements == null) {
            return (A)((Object)this);
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").remove((Object)builder);
            this.addIfStatements.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddIfStatements(Predicate<AddIfStatementBuilder> predicate) {
        if (this.addIfStatements == null) {
            return (A)((Object)this);
        }
        Iterator<AddIfStatementBuilder> each = this.addIfStatements.iterator();
        List visitables = this._visitables.get((Object)"addIfStatements");
        while (each.hasNext()) {
            AddIfStatementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAddIfStatements() {
        return this.addIfStatements != null && !this.addIfStatements.isEmpty();
    }

    public A addNewAddIfStatement(String property, String onResourceKind, String onResourceName, Boolean withDefaultValue, String description) {
        return this.addToAddIfStatements(new AddIfStatement(property, onResourceKind, onResourceName, withDefaultValue, description));
    }

    public AddIfStatementsNested<A> addNewAddIfStatement() {
        return new AddIfStatementsNested(-1, null);
    }

    public AddIfStatementsNested<A> addNewAddIfStatementLike(AddIfStatement item) {
        return new AddIfStatementsNested(-1, item);
    }

    public AddIfStatementsNested<A> setNewAddIfStatementLike(int index, AddIfStatement item) {
        return new AddIfStatementsNested(index, item);
    }

    public AddIfStatementsNested<A> editAddIfStatement(int index) {
        if (this.addIfStatements.size() <= index) {
            throw new RuntimeException("Can't edit addIfStatements. Index exceeds size.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    public AddIfStatementsNested<A> editFirstAddIfStatement() {
        if (this.addIfStatements.size() == 0) {
            throw new RuntimeException("Can't edit first addIfStatements. The list is empty.");
        }
        return this.setNewAddIfStatementLike(0, this.buildAddIfStatement(0));
    }

    public AddIfStatementsNested<A> editLastAddIfStatement() {
        int index = this.addIfStatements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addIfStatements. The list is empty.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    public AddIfStatementsNested<A> editMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addIfStatements.size(); ++i) {
            if (!predicate.test(this.addIfStatements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addIfStatements. No match found.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmChartConfigFluent that = (HelmChartConfigFluent)((Object)o);
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.home, that.home)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.keywords, that.keywords)) {
            return false;
        }
        if (!Objects.equals(this.maintainers, that.maintainers)) {
            return false;
        }
        if (!Objects.equals(this.icon, that.icon)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.condition, that.condition)) {
            return false;
        }
        if (!Objects.equals(this.tags, that.tags)) {
            return false;
        }
        if (!Objects.equals(this.appVersion, that.appVersion)) {
            return false;
        }
        if (!Objects.equals(this.deprecated, that.deprecated)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.kubeVersion, that.kubeVersion)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.valuesRootAlias, that.valuesRootAlias)) {
            return false;
        }
        if (!Objects.equals(this.valuesProfileSeparator, that.valuesProfileSeparator)) {
            return false;
        }
        if (!Objects.equals(this.createTarFile, that.createTarFile)) {
            return false;
        }
        if (!Objects.equals(this.createValuesSchemaFile, that.createValuesSchemaFile)) {
            return false;
        }
        if (!Objects.equals(this.createReadmeFile, that.createReadmeFile)) {
            return false;
        }
        if (!Objects.equals(this.extension, that.extension)) {
            return false;
        }
        if (!Objects.equals(this.tarFileClassifier, that.tarFileClassifier)) {
            return false;
        }
        if (!Objects.equals(this.notes, that.notes)) {
            return false;
        }
        if (!Objects.equals(this.inputFolder, that.inputFolder)) {
            return false;
        }
        if (!Objects.equals(this.outputFolder, that.outputFolder)) {
            return false;
        }
        if (!Objects.equals(this.values, that.values)) {
            return false;
        }
        if (!Objects.equals((Object)this.valuesSchema, (Object)that.valuesSchema)) {
            return false;
        }
        if (!Objects.equals(this.expressions, that.expressions)) {
            return false;
        }
        return Objects.equals(this.addIfStatements, that.addIfStatements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.name, this.home, this.sources, this.version, this.description, this.keywords, this.maintainers, this.icon, this.apiVersion, this.condition, this.tags, this.appVersion, this.deprecated, this.annotations, this.kubeVersion, this.dependencies, this.type, this.valuesRootAlias, this.valuesProfileSeparator, this.createTarFile, this.createValuesSchemaFile, this.createReadmeFile, this.extension, this.tarFileClassifier, this.notes, this.inputFolder, this.outputFolder, this.values, this.valuesSchema, this.expressions, this.addIfStatements, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.home != null) {
            sb.append("home:");
            sb.append(this.home + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.keywords != null && !this.keywords.isEmpty()) {
            sb.append("keywords:");
            sb.append(this.keywords + ",");
        }
        if (this.maintainers != null && !this.maintainers.isEmpty()) {
            sb.append("maintainers:");
            sb.append(this.maintainers + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append(this.icon + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.condition != null) {
            sb.append("condition:");
            sb.append(this.condition + ",");
        }
        if (this.tags != null) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.appVersion != null) {
            sb.append("appVersion:");
            sb.append(this.appVersion + ",");
        }
        if (this.deprecated != null) {
            sb.append("deprecated:");
            sb.append(this.deprecated + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.kubeVersion != null) {
            sb.append("kubeVersion:");
            sb.append(this.kubeVersion + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.valuesRootAlias != null) {
            sb.append("valuesRootAlias:");
            sb.append(this.valuesRootAlias + ",");
        }
        if (this.valuesProfileSeparator != null) {
            sb.append("valuesProfileSeparator:");
            sb.append(this.valuesProfileSeparator + ",");
        }
        if (this.createTarFile != null) {
            sb.append("createTarFile:");
            sb.append(this.createTarFile + ",");
        }
        if (this.createValuesSchemaFile != null) {
            sb.append("createValuesSchemaFile:");
            sb.append(this.createValuesSchemaFile + ",");
        }
        if (this.createReadmeFile != null) {
            sb.append("createReadmeFile:");
            sb.append(this.createReadmeFile + ",");
        }
        if (this.extension != null) {
            sb.append("extension:");
            sb.append(this.extension + ",");
        }
        if (this.tarFileClassifier != null) {
            sb.append("tarFileClassifier:");
            sb.append(this.tarFileClassifier + ",");
        }
        if (this.notes != null) {
            sb.append("notes:");
            sb.append(this.notes + ",");
        }
        if (this.inputFolder != null) {
            sb.append("inputFolder:");
            sb.append(this.inputFolder + ",");
        }
        if (this.outputFolder != null) {
            sb.append("outputFolder:");
            sb.append(this.outputFolder + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values + ",");
        }
        if (this.valuesSchema != null) {
            sb.append("valuesSchema:");
            sb.append((Object)((Object)this.valuesSchema) + ",");
        }
        if (this.expressions != null && !this.expressions.isEmpty()) {
            sb.append("expressions:");
            sb.append(this.expressions + ",");
        }
        if (this.addIfStatements != null && !this.addIfStatements.isEmpty()) {
            sb.append("addIfStatements:");
            sb.append(this.addIfStatements);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withDeprecated() {
        return this.withDeprecated(true);
    }

    public A withCreateTarFile() {
        return this.withCreateTarFile(true);
    }

    public A withCreateValuesSchemaFile() {
        return this.withCreateValuesSchemaFile(true);
    }

    public A withCreateReadmeFile() {
        return this.withCreateReadmeFile(true);
    }

    public class AddIfStatementsNested<N>
    extends AddIfStatementFluent<AddIfStatementsNested<N>>
    implements Nested<N> {
        AddIfStatementBuilder builder;
        int index;

        AddIfStatementsNested(int index, AddIfStatement item) {
            this.index = index;
            this.builder = new AddIfStatementBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToAddIfStatements(this.index, this.builder.build());
        }

        public N endAddIfStatement() {
            return this.and();
        }
    }

    public class ExpressionsNested<N>
    extends HelmExpressionFluent<ExpressionsNested<N>>
    implements Nested<N> {
        HelmExpressionBuilder builder;
        int index;

        ExpressionsNested(int index, HelmExpression item) {
            this.index = index;
            this.builder = new HelmExpressionBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToExpressions(this.index, this.builder.build());
        }

        public N endExpression() {
            return this.and();
        }
    }

    public class ValuesSchemaNested<N>
    extends ValuesSchemaFluent<ValuesSchemaNested<N>>
    implements Nested<N> {
        ValuesSchemaBuilder builder;

        ValuesSchemaNested(ValuesSchema item) {
            this.builder = new ValuesSchemaBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.withValuesSchema(this.builder.build());
        }

        public N endValuesSchema() {
            return this.and();
        }
    }

    public class ValuesNested<N>
    extends ValueReferenceFluent<ValuesNested<N>>
    implements Nested<N> {
        ValueReferenceBuilder builder;
        int index;

        ValuesNested(int index, ValueReference item) {
            this.index = index;
            this.builder = new ValueReferenceBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToValues(this.index, this.builder.build());
        }

        public N endValue() {
            return this.and();
        }
    }

    public class DependenciesNested<N>
    extends HelmDependencyFluent<DependenciesNested<N>>
    implements Nested<N> {
        HelmDependencyBuilder builder;
        int index;

        DependenciesNested(int index, HelmDependency item) {
            this.index = index;
            this.builder = new HelmDependencyBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToDependencies(this.index, this.builder.build());
        }

        public N endDependency() {
            return this.and();
        }
    }

    public class AnnotationsNested<N>
    extends AnnotationFluent<AnnotationsNested<N>>
    implements Nested<N> {
        AnnotationBuilder builder;
        int index;

        AnnotationsNested(int index, Annotation item) {
            this.index = index;
            this.builder = new AnnotationBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToAnnotations(this.index, this.builder.build());
        }

        public N endAnnotation() {
            return this.and();
        }
    }

    public class MaintainersNested<N>
    extends MaintainerFluent<MaintainersNested<N>>
    implements Nested<N> {
        MaintainerBuilder builder;
        int index;

        MaintainersNested(int index, Maintainer item) {
            this.index = index;
            this.builder = new MaintainerBuilder(this, item);
        }

        public N and() {
            return (N)HelmChartConfigFluent.this.setToMaintainers(this.index, this.builder.build());
        }

        public N endMaintainer() {
            return this.and();
        }
    }
}

