package io.dekorate.helm.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ValueReferenceFluent<A extends ValueReferenceFluent<A>> extends BaseFluent<A>{
  public ValueReferenceFluent() {
  }
  
  public ValueReferenceFluent(ValueReference instance) {
    this.copyInstance(instance);
  }
  private String property;
  private List<String> paths = new ArrayList<String>();
  private String profile;
  private String value;
  private String expression;
  private String description;
  private Integer minimum;
  private Integer maximum;
  private String pattern;
  private Boolean required;
  
  protected void copyInstance(ValueReference instance) {
    instance = (instance != null ? instance : new ValueReference());
    if (instance != null) {
          this.withProperty(instance.getProperty());
          this.withPaths(instance.getPaths());
          this.withProfile(instance.getProfile());
          this.withValue(instance.getValue());
          this.withExpression(instance.getExpression());
          this.withDescription(instance.getDescription());
          this.withMinimum(instance.getMinimum());
          this.withMaximum(instance.getMaximum());
          this.withPattern(instance.getPattern());
          this.withRequired(instance.getRequired());
        }
  }
  
  public String getProperty() {
    return this.property;
  }
  
  public A withProperty(String property) {
    this.property = property;
    return (A) this;
  }
  
  public boolean hasProperty() {
    return this.property != null;
  }
  
  public A withPaths(java.lang.String... paths) {
    if (this.paths != null) {
        this.paths.clear();
        _visitables.remove("paths");
    }
    if (paths != null) {
      for (String item : paths) {
        this.addToPaths(item);
      }
    }
    return (A) this;
  }
  
  public String[] getPaths() {
    int size = paths != null ? paths.size() : 0;;
    String[] result = new String[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (String item : paths) {
      result[index++] = item;
    }
    return result;
  }
  
  public A addToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.add(index, item);
    return (A)this;
  }
  
  public A setToPaths(int index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.set(index, item); return (A)this;
  }
  
  public A addToPaths(java.lang.String... items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  
  public A addAllToPaths(Collection<String> items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  
  public A removeFromPaths(java.lang.String... items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  
  public A removeAllFromPaths(Collection<String> items) {
    if (this.paths == null) return (A)this;
    for (String item : items) { this.paths.remove(item);} return (A)this;
  }
  
  public boolean hasPaths() {
    return this.paths != null && !this.paths.isEmpty();
  }
  
  public String getProfile() {
    return this.profile;
  }
  
  public A withProfile(String profile) {
    this.profile = profile;
    return (A) this;
  }
  
  public boolean hasProfile() {
    return this.profile != null;
  }
  
  public String getValue() {
    return this.value;
  }
  
  public A withValue(String value) {
    this.value = value;
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public String getExpression() {
    return this.expression;
  }
  
  public A withExpression(String expression) {
    this.expression = expression;
    return (A) this;
  }
  
  public boolean hasExpression() {
    return this.expression != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public Integer getMinimum() {
    return this.minimum;
  }
  
  public A withMinimum(Integer minimum) {
    this.minimum = minimum;
    return (A) this;
  }
  
  public boolean hasMinimum() {
    return this.minimum != null;
  }
  
  public Integer getMaximum() {
    return this.maximum;
  }
  
  public A withMaximum(Integer maximum) {
    this.maximum = maximum;
    return (A) this;
  }
  
  public boolean hasMaximum() {
    return this.maximum != null;
  }
  
  public String getPattern() {
    return this.pattern;
  }
  
  public A withPattern(String pattern) {
    this.pattern = pattern;
    return (A) this;
  }
  
  public boolean hasPattern() {
    return this.pattern != null;
  }
  
  public Boolean getRequired() {
    return this.required;
  }
  
  public A withRequired(Boolean required) {
    this.required = required;
    return (A) this;
  }
  
  public boolean hasRequired() {
    return this.required != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValueReferenceFluent that = (ValueReferenceFluent) o;
    if (!java.util.Objects.equals(property, that.property)) return false;
    if (!java.util.Objects.equals(paths, that.paths)) return false;
    if (!java.util.Objects.equals(profile, that.profile)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(expression, that.expression)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(minimum, that.minimum)) return false;
    if (!java.util.Objects.equals(maximum, that.maximum)) return false;
    if (!java.util.Objects.equals(pattern, that.pattern)) return false;
    if (!java.util.Objects.equals(required, that.required)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(property,  paths,  profile,  value,  expression,  description,  minimum,  maximum,  pattern,  required,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (property != null) { sb.append("property:"); sb.append(property + ","); }
    if (paths != null && !paths.isEmpty()) { sb.append("paths:"); sb.append(paths + ","); }
    if (profile != null) { sb.append("profile:"); sb.append(profile + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (expression != null) { sb.append("expression:"); sb.append(expression + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (minimum != null) { sb.append("minimum:"); sb.append(minimum + ","); }
    if (maximum != null) { sb.append("maximum:"); sb.append(maximum + ","); }
    if (pattern != null) { sb.append("pattern:"); sb.append(pattern + ","); }
    if (required != null) { sb.append("required:"); sb.append(required); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withRequired() {
    return withRequired(true);
  }
  

}