package io.dekorate.helm.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class ValueReference{
  public ValueReference() {
  }
  
  public ValueReference(String property,String[] paths,String profile,String value,String expression,String description,Integer minimum,Integer maximum,String pattern,Boolean required) {
    this.property = property;
    this.paths = paths != null ? paths : new String[0];
    this.profile = profile;
    this.value = value;
    this.expression = expression;
    this.description = description;
    this.minimum = minimum;
    this.maximum = maximum;
    this.pattern = pattern;
    this.required = required;
  }
  private String property;
  private String[] paths;
  private String profile;
  private String value;
  private String expression;
  private String description;
  private Integer minimum;
  private Integer maximum;
  private String pattern;
  private Boolean required;
  
  public String getProperty() {
    return this.property;
  }
  
  
  /**
   * The path expressions where to map the property.
   */
  public String[] getPaths() {
    return this.paths;
  }
  
  public String getProfile() {
    return this.profile;
  }
  
  public String getValue() {
    return this.value;
  }
  
  
  /**
   * If not provided, it will use `{{ .Values.<root alias>.<property> }}`.
   * @return The complete Helm expression to be replaced with.
   */
  public String getExpression() {
    return this.expression;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public Integer getMinimum() {
    return this.minimum;
  }
  
  public Integer getMaximum() {
    return this.maximum;
  }
  
  public String getPattern() {
    return this.pattern;
  }
  
  public Boolean getRequired() {
    return this.required;
  }
  
  public boolean isRequired() {
    return this.required != null &&  this.required;
  }
  
  public static ValueReferenceBuilder newBuilder() {
    return new ValueReferenceBuilder();
  }
  
  public static ValueReferenceBuilder newBuilderFromDefaults() {
    return new ValueReferenceBuilder().withMinimum(-2147483648).withMaximum(2147483647).withRequired(false);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValueReference that = (ValueReference) o;
    if (!java.util.Objects.equals(property, that.property)) return false;
    if (!java.util.Objects.equals(paths, that.paths)) return false;
    if (!java.util.Objects.equals(profile, that.profile)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(expression, that.expression)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(minimum, that.minimum)) return false;
    if (!java.util.Objects.equals(maximum, that.maximum)) return false;
    if (!java.util.Objects.equals(pattern, that.pattern)) return false;
    if (!java.util.Objects.equals(required, that.required)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(property,  paths,  profile,  value,  expression,  description,  minimum,  maximum,  pattern,  required,  super.hashCode());
  }
  

}