package io.dekorate.helm.config;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MaintainerFluent<A extends MaintainerFluent<A>> extends BaseFluent<A>{
  public MaintainerFluent() {
  }
  
  public MaintainerFluent(Maintainer instance) {
    this.copyInstance(instance);
  }
  private String name;
  private String email;
  private String url;
  
  protected void copyInstance(Maintainer instance) {
    instance = (instance != null ? instance : new Maintainer());
    if (instance != null) {
          this.withName(instance.getName());
          this.withEmail(instance.getEmail());
          this.withUrl(instance.getUrl());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getEmail() {
    return this.email;
  }
  
  public A withEmail(String email) {
    this.email = email;
    return (A) this;
  }
  
  public boolean hasEmail() {
    return this.email != null;
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MaintainerFluent that = (MaintainerFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(email, that.email)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  email,  url,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (email != null) { sb.append("email:"); sb.append(email + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  

}