package io.dekorate.helm.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import java.lang.String;
import io.dekorate.project.Project;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class HelmChartConfig extends Configuration{
  public HelmChartConfig() {
  }
  
  public HelmChartConfig(Project project,Map<ConfigKey,Object> attributes,Boolean enabled,String name,String home,String[] sources,String version,String description,String[] keywords,Maintainer[] maintainers,String icon,String apiVersion,String condition,String tags,String appVersion,Boolean deprecated,Annotation[] annotations,String kubeVersion,HelmDependency[] dependencies,String type,String valuesRootAlias,String valuesProfileSeparator,Boolean createTarFile,Boolean createValuesSchemaFile,Boolean createReadmeFile,String extension,String tarFileClassifier,String notes,String inputFolder,String outputFolder,ValueReference[] values,ValuesSchema valuesSchema,HelmExpression[] expressions,AddIfStatement[] addIfStatements) {
    super(project, attributes);
    this.enabled = enabled;
    this.name = name;
    this.home = home;
    this.sources = sources != null ? sources : new String[0];
    this.version = version;
    this.description = description;
    this.keywords = keywords != null ? keywords : new String[0];
    this.maintainers = maintainers != null ? maintainers : new Maintainer[0];
    this.icon = icon;
    this.apiVersion = apiVersion;
    this.condition = condition;
    this.tags = tags;
    this.appVersion = appVersion;
    this.deprecated = deprecated;
    this.annotations = annotations != null ? annotations : new Annotation[0];
    this.kubeVersion = kubeVersion;
    this.dependencies = dependencies != null ? dependencies : new HelmDependency[0];
    this.type = type;
    this.valuesRootAlias = valuesRootAlias;
    this.valuesProfileSeparator = valuesProfileSeparator;
    this.createTarFile = createTarFile;
    this.createValuesSchemaFile = createValuesSchemaFile;
    this.createReadmeFile = createReadmeFile;
    this.extension = extension;
    this.tarFileClassifier = tarFileClassifier;
    this.notes = notes;
    this.inputFolder = inputFolder;
    this.outputFolder = outputFolder;
    this.values = values != null ? values : new ValueReference[0];
    this.valuesSchema = valuesSchema;
    this.expressions = expressions != null ? expressions : new HelmExpression[0];
    this.addIfStatements = addIfStatements != null ? addIfStatements : new AddIfStatement[0];
  }
  private Boolean enabled;
  private String name;
  private String home;
  private String[] sources = new String[0];
  private String version;
  private String description;
  private String[] keywords = new String[0];
  private Maintainer[] maintainers = new Maintainer[0];
  private String icon;
  private String apiVersion;
  private String condition;
  private String tags;
  private String appVersion;
  private Boolean deprecated;
  private Annotation[] annotations = new Annotation[0];
  private String kubeVersion;
  private HelmDependency[] dependencies = new HelmDependency[0];
  private String type;
  private String valuesRootAlias;
  private String valuesProfileSeparator;
  private Boolean createTarFile;
  private Boolean createValuesSchemaFile;
  private Boolean createReadmeFile;
  private String extension;
  private String tarFileClassifier;
  private String notes;
  private String inputFolder;
  private String outputFolder;
  private ValueReference[] values = new ValueReference[0];
  private ValuesSchema valuesSchema;
  private HelmExpression[] expressions = new HelmExpression[0];
  private AddIfStatement[] addIfStatements = new AddIfStatement[0];
  
  public Boolean getEnabled() {
    return this.enabled;
  }
  
  public boolean isEnabled() {
    return this.enabled != null &&  this.enabled;
  }
  
  public String getName() {
    return this.name;
  }
  
  public String getHome() {
    return this.home;
  }
  
  public String[] getSources() {
    return this.sources;
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public String[] getKeywords() {
    return this.keywords;
  }
  
  public Maintainer[] getMaintainers() {
    return this.maintainers;
  }
  
  public String getIcon() {
    return this.icon;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public String getCondition() {
    return this.condition;
  }
  
  public String getTags() {
    return this.tags;
  }
  
  public String getAppVersion() {
    return this.appVersion;
  }
  
  public Boolean getDeprecated() {
    return this.deprecated;
  }
  
  public boolean isDeprecated() {
    return this.deprecated != null &&  this.deprecated;
  }
  
  public Annotation[] getAnnotations() {
    return this.annotations;
  }
  
  public String getKubeVersion() {
    return this.kubeVersion;
  }
  
  public HelmDependency[] getDependencies() {
    return this.dependencies;
  }
  
  public String getType() {
    return this.type;
  }
  
  public String getValuesRootAlias() {
    return this.valuesRootAlias;
  }
  
  public String getValuesProfileSeparator() {
    return this.valuesProfileSeparator;
  }
  
  public Boolean getCreateTarFile() {
    return this.createTarFile;
  }
  
  public boolean isCreateTarFile() {
    return this.createTarFile != null &&  this.createTarFile;
  }
  
  public Boolean getCreateValuesSchemaFile() {
    return this.createValuesSchemaFile;
  }
  
  public boolean isCreateValuesSchemaFile() {
    return this.createValuesSchemaFile != null &&  this.createValuesSchemaFile;
  }
  
  public Boolean getCreateReadmeFile() {
    return this.createReadmeFile;
  }
  
  public boolean isCreateReadmeFile() {
    return this.createReadmeFile != null &&  this.createReadmeFile;
  }
  
  public String getExtension() {
    return this.extension;
  }
  
  public String getTarFileClassifier() {
    return this.tarFileClassifier;
  }
  
  public String getNotes() {
    return this.notes;
  }
  
  public String getInputFolder() {
    return this.inputFolder;
  }
  
  public String getOutputFolder() {
    return this.outputFolder;
  }
  
  public ValueReference[] getValues() {
    return this.values;
  }
  
  public ValuesSchema getValuesSchema() {
    return this.valuesSchema;
  }
  
  public HelmExpression[] getExpressions() {
    return this.expressions;
  }
  
  public AddIfStatement[] getAddIfStatements() {
    return this.addIfStatements;
  }
  
  public static HelmChartConfigBuilder newHelmChartConfigBuilder() {
    return new HelmChartConfigBuilder();
  }
  
  public static HelmChartConfigBuilder newHelmChartConfigBuilderFromDefaults() {
    return new HelmChartConfigBuilder().withEnabled(true).withApiVersion("v2").withDeprecated(false).withValuesRootAlias("app").withValuesProfileSeparator(".").withCreateTarFile(false).withCreateValuesSchemaFile(true).withCreateReadmeFile(true).withExtension("tar.gz").withNotes("/NOTES.template.txt").withInputFolder("helm").withOutputFolder("helm");
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfig that = (HelmChartConfig) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(home, that.home)) return false;
    if (!java.util.Objects.equals(sources, that.sources)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(keywords, that.keywords)) return false;
    if (!java.util.Objects.equals(maintainers, that.maintainers)) return false;
    if (!java.util.Objects.equals(icon, that.icon)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(condition, that.condition)) return false;
    if (!java.util.Objects.equals(tags, that.tags)) return false;
    if (!java.util.Objects.equals(appVersion, that.appVersion)) return false;
    if (!java.util.Objects.equals(deprecated, that.deprecated)) return false;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;
    if (!java.util.Objects.equals(kubeVersion, that.kubeVersion)) return false;
    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(valuesRootAlias, that.valuesRootAlias)) return false;
    if (!java.util.Objects.equals(valuesProfileSeparator, that.valuesProfileSeparator)) return false;
    if (!java.util.Objects.equals(createTarFile, that.createTarFile)) return false;
    if (!java.util.Objects.equals(createValuesSchemaFile, that.createValuesSchemaFile)) return false;
    if (!java.util.Objects.equals(createReadmeFile, that.createReadmeFile)) return false;
    if (!java.util.Objects.equals(extension, that.extension)) return false;
    if (!java.util.Objects.equals(tarFileClassifier, that.tarFileClassifier)) return false;
    if (!java.util.Objects.equals(notes, that.notes)) return false;
    if (!java.util.Objects.equals(inputFolder, that.inputFolder)) return false;
    if (!java.util.Objects.equals(outputFolder, that.outputFolder)) return false;
    if (!java.util.Objects.equals(values, that.values)) return false;
    if (!java.util.Objects.equals(valuesSchema, that.valuesSchema)) return false;
    if (!java.util.Objects.equals(expressions, that.expressions)) return false;
    if (!java.util.Objects.equals(addIfStatements, that.addIfStatements)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  home,  sources,  version,  description,  keywords,  maintainers,  icon,  apiVersion,  condition,  tags,  appVersion,  deprecated,  annotations,  kubeVersion,  dependencies,  type,  valuesRootAlias,  valuesProfileSeparator,  createTarFile,  createValuesSchemaFile,  createReadmeFile,  extension,  tarFileClassifier,  notes,  inputFolder,  outputFolder,  values,  valuesSchema,  expressions,  addIfStatements,  super.hashCode());
  }
  

}