/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.util;

import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.utils.Strings;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class HelmConfigUtils {
    private static final String ROOTLESS_PROPERTY = "@.";

    private HelmConfigUtils() {
    }

    public static String deductProperty(HelmChartConfig helmConfig, String property) {
        String prefix;
        if (property.startsWith(ROOTLESS_PROPERTY)) {
            return property.replaceFirst(Pattern.quote(ROOTLESS_PROPERTY), "");
        }
        if (!HelmConfigUtils.startWithDependencyPrefix(property, helmConfig.getDependencies()) && !property.startsWith(prefix = helmConfig.getValuesRootAlias() + ".")) {
            property = prefix + property;
        }
        return property;
    }

    private static boolean startWithDependencyPrefix(String property, HelmDependency[] dependencies) {
        if (dependencies == null || dependencies.length == 0) {
            return false;
        }
        String[] parts = property.split(Pattern.quote("."));
        if (parts.length <= 1) {
            return false;
        }
        String name = parts[0];
        return Stream.of(dependencies).map(d -> Strings.defaultIfEmpty((String)d.getAlias(), (String)d.getName())).anyMatch(d -> Strings.equals((String)d, (String)name));
    }
}

