/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.ValuesSchema;
import io.dekorate.helm.config.ValuesSchemaProperty;
import io.dekorate.helm.config.ValuesSchemaPropertyBuilder;
import io.dekorate.helm.config.ValuesSchemaPropertyFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ValuesSchemaFluent<A extends ValuesSchemaFluent<A>>
extends BaseFluent<A> {
    private String title;
    private ArrayList<ValuesSchemaPropertyBuilder> properties = new ArrayList();

    public ValuesSchemaFluent() {
    }

    public ValuesSchemaFluent(ValuesSchema instance) {
        ValuesSchema valuesSchema = instance = instance != null ? instance : new ValuesSchema();
        if (instance != null) {
            this.withTitle(instance.getTitle());
            this.withProperties(instance.getProperties());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public A withTitle(String title) {
        this.title = title;
        return (A)((Object)this);
    }

    public boolean hasTitle() {
        return this.title != null;
    }

    public A withProperties(ValuesSchemaProperty ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (ValuesSchemaProperty item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public ValuesSchemaProperty[] buildProperties() {
        int size = this.properties != null ? this.properties.size() : 0;
        ValuesSchemaProperty[] result = new ValuesSchemaProperty[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.properties) {
            result[index++] = (ValuesSchemaProperty)visitableBuilder.build();
        }
        return result;
    }

    public ValuesSchemaProperty buildProperty(int index) {
        return this.properties.get(index).build();
    }

    public ValuesSchemaProperty buildFirstProperty() {
        return this.properties.get(0).build();
    }

    public ValuesSchemaProperty buildLastProperty() {
        return this.properties.get(this.properties.size() - 1).build();
    }

    public ValuesSchemaProperty buildMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
        for (ValuesSchemaPropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
        for (ValuesSchemaPropertyBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToProperties(int index, ValuesSchemaProperty item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").add(index, builder);
            this.properties.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProperties(int index, ValuesSchemaProperty item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").set(index, builder);
            this.properties.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProperties(ValuesSchemaProperty ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (ValuesSchemaProperty item : items) {
            ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<ValuesSchemaProperty> items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (ValuesSchemaProperty item : items) {
            ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(ValuesSchemaProperty ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (ValuesSchemaProperty item : items) {
            ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<ValuesSchemaProperty> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (ValuesSchemaProperty item : items) {
            ValuesSchemaPropertyBuilder builder = new ValuesSchemaPropertyBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProperties(Predicate<ValuesSchemaPropertyBuilder> predicate) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        Iterator<ValuesSchemaPropertyBuilder> each = this.properties.iterator();
        List visitables = this._visitables.get((Object)"properties");
        while (each.hasNext()) {
            ValuesSchemaPropertyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public PropertiesNested<A> addNewProperty() {
        return new PropertiesNested(-1, null);
    }

    public PropertiesNested<A> addNewPropertyLike(ValuesSchemaProperty item) {
        return new PropertiesNested(-1, item);
    }

    public PropertiesNested<A> setNewPropertyLike(int index, ValuesSchemaProperty item) {
        return new PropertiesNested(index, item);
    }

    public PropertiesNested<A> editProperty(int index) {
        if (this.properties.size() <= index) {
            throw new RuntimeException("Can't edit properties. Index exceeds size.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editFirstProperty() {
        if (this.properties.size() == 0) {
            throw new RuntimeException("Can't edit first properties. The list is empty.");
        }
        return this.setNewPropertyLike(0, this.buildProperty(0));
    }

    public PropertiesNested<A> editLastProperty() {
        int index = this.properties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last properties. The list is empty.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editMatchingProperty(Predicate<ValuesSchemaPropertyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!predicate.test(this.properties.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching properties. No match found.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValuesSchemaFluent that = (ValuesSchemaFluent)((Object)o);
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.properties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.properties != null) {
            sb.append("properties:");
            sb.append(this.properties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PropertiesNested<N>
    extends ValuesSchemaPropertyFluent<PropertiesNested<N>>
    implements Nested<N> {
        ValuesSchemaPropertyBuilder builder;
        int index;

        PropertiesNested(int index, ValuesSchemaProperty item) {
            this.index = index;
            this.builder = new ValuesSchemaPropertyBuilder(this, item);
        }

        public N and() {
            return (N)ValuesSchemaFluent.this.setToProperties(this.index, this.builder.build());
        }

        public N endProperty() {
            return this.and();
        }
    }
}

