package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class MaintainerBuilder extends MaintainerFluent<MaintainerBuilder> implements VisitableBuilder<Maintainer,MaintainerBuilder>{
  public MaintainerBuilder() {
    this(false);
  }
  public MaintainerBuilder(Boolean validationEnabled) {
    this(new Maintainer(), validationEnabled);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent) {
    this(fluent, false);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Maintainer(), validationEnabled);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance) {
    this(fluent, instance, false);
  }
  public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Maintainer());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withEmail(instance.getEmail());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MaintainerBuilder(Maintainer instance) {
    this(instance,false);
  }
  public MaintainerBuilder(Maintainer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Maintainer());

    if (instance != null) {
      this.withName(instance.getName());
      this.withEmail(instance.getEmail());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  MaintainerFluent<?> fluent;
  Boolean validationEnabled;
  public EditableMaintainer build() {
    EditableMaintainer buildable = new EditableMaintainer(fluent.getName(),fluent.getEmail(),fluent.getUrl());
    return buildable;
  }
  
}