package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import java.util.Iterator;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmChartConfigFluent<A extends HelmChartConfigFluent<A>> extends ConfigurationFluent<A>{
  public HelmChartConfigFluent() {
  }
  public HelmChartConfigFluent(HelmChartConfig instance) {
    instance = (instance != null ? instance : new HelmChartConfig());

    if (instance != null) {
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
      this.withEnabled(instance.getEnabled());
      this.withName(instance.getName());
      this.withHome(instance.getHome());
      this.withSources(instance.getSources());
      this.withVersion(instance.getVersion());
      this.withDescription(instance.getDescription());
      this.withKeywords(instance.getKeywords());
      this.withMaintainers(instance.getMaintainers());
      this.withIcon(instance.getIcon());
      this.withApiVersion(instance.getApiVersion());
      this.withCondition(instance.getCondition());
      this.withTags(instance.getTags());
      this.withAppVersion(instance.getAppVersion());
      this.withDeprecated(instance.getDeprecated());
      this.withAnnotations(instance.getAnnotations());
      this.withKubeVersion(instance.getKubeVersion());
      this.withDependencies(instance.getDependencies());
      this.withType(instance.getType());
      this.withValuesRootAlias(instance.getValuesRootAlias());
      this.withValuesProfileSeparator(instance.getValuesProfileSeparator());
      this.withCreateTarFile(instance.getCreateTarFile());
      this.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile());
      this.withCreateReadmeFile(instance.getCreateReadmeFile());
      this.withExtension(instance.getExtension());
      this.withTarFileClassifier(instance.getTarFileClassifier());
      this.withNotes(instance.getNotes());
      this.withInputFolder(instance.getInputFolder());
      this.withOutputFolder(instance.getOutputFolder());
      this.withValues(instance.getValues());
      this.withValuesSchema(instance.getValuesSchema());
      this.withExpressions(instance.getExpressions());
      this.withAddIfStatements(instance.getAddIfStatements());
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
    }
  }
  private Boolean enabled;
  private String name;
  private String home;
  private List<String> sources = new ArrayList<String>();
  private String version;
  private String description;
  private List<String> keywords = new ArrayList<String>();
  private ArrayList<MaintainerBuilder> maintainers = new ArrayList<MaintainerBuilder>();
  private String icon;
  private String apiVersion;
  private String condition;
  private String tags;
  private String appVersion;
  private Boolean deprecated;
  private ArrayList<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();
  private String kubeVersion;
  private ArrayList<HelmDependencyBuilder> dependencies = new ArrayList<HelmDependencyBuilder>();
  private String type;
  private String valuesRootAlias;
  private String valuesProfileSeparator;
  private Boolean createTarFile;
  private Boolean createValuesSchemaFile;
  private Boolean createReadmeFile;
  private String extension;
  private String tarFileClassifier;
  private String notes;
  private String inputFolder;
  private String outputFolder;
  private ArrayList<ValueReferenceBuilder> values = new ArrayList<ValueReferenceBuilder>();
  private ValuesSchemaBuilder valuesSchema;
  private ArrayList<HelmExpressionBuilder> expressions = new ArrayList<HelmExpressionBuilder>();
  private ArrayList<AddIfStatementBuilder> addIfStatements = new ArrayList<AddIfStatementBuilder>();
  public Boolean getEnabled() {
    return this.enabled;
  }
  public A withEnabled(Boolean enabled) {
    this.enabled=enabled; return (A) this;
  }
  public boolean hasEnabled() {
    return this.enabled != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public String getHome() {
    return this.home;
  }
  public A withHome(String home) {
    this.home=home; return (A) this;
  }
  public boolean hasHome() {
    return this.home != null;
  }
  public A withSources(java.lang.String... sources) {
    if (this.sources != null) {this.sources.clear(); _visitables.remove("sources"); }
    if (sources != null) {for (String item :sources){ this.addToSources(item);}} return (A) this;
  }
  public String[] getSources() {
    //This needs to work with primitives, so we use arrays.
int size = sources != null ? sources.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : sources) {
    result[index++]=item;
}
return result;

  }
  public A addToSources(int index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.add(index, item);
    return (A)this;
  }
  public A setToSources(int index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.set(index, item); return (A)this;
  }
  public A addToSources(java.lang.String... items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A addAllToSources(Collection<String> items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A removeFromSources(java.lang.String... items) {
    if (this.sources == null) return (A)this;
    for (String item : items) { this.sources.remove(item);} return (A)this;
  }
  public A removeAllFromSources(Collection<String> items) {
    if (this.sources == null) return (A)this;
    for (String item : items) { this.sources.remove(item);} return (A)this;
  }
  public boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public boolean hasVersion() {
    return this.version != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public boolean hasDescription() {
    return this.description != null;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear(); _visitables.remove("keywords"); }
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public String[] getKeywords() {
    //This needs to work with primitives, so we use arrays.
int size = keywords != null ? keywords.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : keywords) {
    result[index++]=item;
}
return result;

  }
  public A addToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    if (this.keywords == null) return (A)this;
    for (String item : items) { this.keywords.remove(item);} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    if (this.keywords == null) return (A)this;
    for (String item : items) { this.keywords.remove(item);} return (A)this;
  }
  public boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A withMaintainers(io.dekorate.helm.config.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear(); _visitables.remove("maintainers"); }
    if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  public Maintainer[] buildMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
Maintainer[] result = new Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<Maintainer,MaintainerBuilder> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Maintainer buildMaintainer(int index) {
    return this.maintainers.get(index).build();
  }
  public Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").add(index, builder); maintainers.add(index, builder);}
    return (A)this;
  }
  public A setToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").set(index, builder); maintainers.set(index, builder);}
    return (A)this;
  }
  public A addToMaintainers(io.dekorate.helm.config.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.dekorate.helm.config.Maintainer... items) {
    if (this.maintainers == null) return (A)this;
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder); this.maintainers.remove(builder);} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) return (A)this;
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder); this.maintainers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String name,String email,String url) {
    return (A)addToMaintainers(new Maintainer(name, email, url));
  }
  public MaintainersNested<A> addNewMaintainer() {
    return new MaintainersNested(-1, null);
  }
  public MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
    return new MaintainersNested(-1, item);
  }
  public MaintainersNested<A> setNewMaintainerLike(int index,Maintainer item) {
    return new MaintainersNested(index, item);
  }
  public MaintainersNested<A> editMaintainer(int index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public String getIcon() {
    return this.icon;
  }
  public A withIcon(String icon) {
    this.icon=icon; return (A) this;
  }
  public boolean hasIcon() {
    return this.icon != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getCondition() {
    return this.condition;
  }
  public A withCondition(String condition) {
    this.condition=condition; return (A) this;
  }
  public boolean hasCondition() {
    return this.condition != null;
  }
  public String getTags() {
    return this.tags;
  }
  public A withTags(String tags) {
    this.tags=tags; return (A) this;
  }
  public boolean hasTags() {
    return this.tags != null;
  }
  public String getAppVersion() {
    return this.appVersion;
  }
  public A withAppVersion(String appVersion) {
    this.appVersion=appVersion; return (A) this;
  }
  public boolean hasAppVersion() {
    return this.appVersion != null;
  }
  public Boolean getDeprecated() {
    return this.deprecated;
  }
  public A withDeprecated(Boolean deprecated) {
    this.deprecated=deprecated; return (A) this;
  }
  public boolean hasDeprecated() {
    return this.deprecated != null;
  }
  public A withAnnotations(io.dekorate.helm.config.Annotation... annotations) {
    if (this.annotations != null) {this.annotations.clear(); _visitables.remove("annotations"); }
    if (annotations != null) {for (Annotation item :annotations){ this.addToAnnotations(item);}} return (A) this;
  }
  public Annotation[] buildAnnotations() {
    int size = annotations != null ? annotations.size() : 0;
Annotation[] result = new Annotation[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<Annotation,AnnotationBuilder> builder : annotations) {
    result[index++]=builder.build();
}
return result;

  }
  public Annotation buildAnnotation(int index) {
    return this.annotations.get(index).build();
  }
  public Annotation buildFirstAnnotation() {
    return this.annotations.get(0).build();
  }
  public Annotation buildLastAnnotation() {
    return this.annotations.get(annotations.size() - 1).build();
  }
  public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    for (AnnotationBuilder item: annotations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    for (AnnotationBuilder item: annotations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToAnnotations(int index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);
    if (index < 0 || index >= annotations.size()) { _visitables.get("annotations").add(builder); annotations.add(builder); } else { _visitables.get("annotations").add(index, builder); annotations.add(index, builder);}
    return (A)this;
  }
  public A setToAnnotations(int index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);
    if (index < 0 || index >= annotations.size()) { _visitables.get("annotations").add(builder); annotations.add(builder); } else { _visitables.get("annotations").set(index, builder); annotations.set(index, builder);}
    return (A)this;
  }
  public A addToAnnotations(io.dekorate.helm.config.Annotation... items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  public A addAllToAnnotations(Collection<Annotation> items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  public A removeFromAnnotations(io.dekorate.helm.config.Annotation... items) {
    if (this.annotations == null) return (A)this;
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder); this.annotations.remove(builder);} return (A)this;
  }
  public A removeAllFromAnnotations(Collection<Annotation> items) {
    if (this.annotations == null) return (A)this;
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder); this.annotations.remove(builder);} return (A)this;
  }
  public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
    if (annotations == null) return (A) this;
    final Iterator<AnnotationBuilder> each = annotations.iterator();
    final List visitables = _visitables.get("annotations");
    while (each.hasNext()) {
      AnnotationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasAnnotations() {
    return annotations != null && !annotations.isEmpty();
  }
  public A addNewAnnotation(String key,String value) {
    return (A)addToAnnotations(new Annotation(key, value));
  }
  public AnnotationsNested<A> addNewAnnotation() {
    return new AnnotationsNested(-1, null);
  }
  public AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
    return new AnnotationsNested(-1, item);
  }
  public AnnotationsNested<A> setNewAnnotationLike(int index,Annotation item) {
    return new AnnotationsNested(index, item);
  }
  public AnnotationsNested<A> editAnnotation(int index) {
    if (annotations.size() <= index) throw new RuntimeException("Can't edit annotations. Index exceeds size.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public AnnotationsNested<A> editFirstAnnotation() {
    if (annotations.size() == 0) throw new RuntimeException("Can't edit first annotations. The list is empty.");
    return setNewAnnotationLike(0, buildAnnotation(0));
  }
  public AnnotationsNested<A> editLastAnnotation() {
    int index = annotations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last annotations. The list is empty.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<annotations.size();i++) { 
    if (predicate.test(annotations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching annotations. No match found.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public String getKubeVersion() {
    return this.kubeVersion;
  }
  public A withKubeVersion(String kubeVersion) {
    this.kubeVersion=kubeVersion; return (A) this;
  }
  public boolean hasKubeVersion() {
    return this.kubeVersion != null;
  }
  public A withDependencies(io.dekorate.helm.config.HelmDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear(); _visitables.remove("dependencies"); }
    if (dependencies != null) {for (HelmDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  public HelmDependency[] buildDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
HelmDependency[] result = new HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<HelmDependency,HelmDependencyBuilder> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmDependency buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  public HelmDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public HelmDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToDependencies(int index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  public A setToDependencies(int index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  public A addToDependencies(io.dekorate.helm.config.HelmDependency... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<HelmDependency> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.dekorate.helm.config.HelmDependency... items) {
    if (this.dependencies == null) return (A)this;
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  public A removeAllFromDependencies(Collection<HelmDependency> items) {
    if (this.dependencies == null) return (A)this;
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<HelmDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      HelmDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public DependenciesNested<A> addNewDependency() {
    return new DependenciesNested(-1, null);
  }
  public DependenciesNested<A> addNewDependencyLike(HelmDependency item) {
    return new DependenciesNested(-1, item);
  }
  public DependenciesNested<A> setNewDependencyLike(int index,HelmDependency item) {
    return new DependenciesNested(index, item);
  }
  public DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public String getValuesRootAlias() {
    return this.valuesRootAlias;
  }
  public A withValuesRootAlias(String valuesRootAlias) {
    this.valuesRootAlias=valuesRootAlias; return (A) this;
  }
  public boolean hasValuesRootAlias() {
    return this.valuesRootAlias != null;
  }
  public String getValuesProfileSeparator() {
    return this.valuesProfileSeparator;
  }
  public A withValuesProfileSeparator(String valuesProfileSeparator) {
    this.valuesProfileSeparator=valuesProfileSeparator; return (A) this;
  }
  public boolean hasValuesProfileSeparator() {
    return this.valuesProfileSeparator != null;
  }
  public Boolean getCreateTarFile() {
    return this.createTarFile;
  }
  public A withCreateTarFile(Boolean createTarFile) {
    this.createTarFile=createTarFile; return (A) this;
  }
  public boolean hasCreateTarFile() {
    return this.createTarFile != null;
  }
  public Boolean getCreateValuesSchemaFile() {
    return this.createValuesSchemaFile;
  }
  public A withCreateValuesSchemaFile(Boolean createValuesSchemaFile) {
    this.createValuesSchemaFile=createValuesSchemaFile; return (A) this;
  }
  public boolean hasCreateValuesSchemaFile() {
    return this.createValuesSchemaFile != null;
  }
  public Boolean getCreateReadmeFile() {
    return this.createReadmeFile;
  }
  public A withCreateReadmeFile(Boolean createReadmeFile) {
    this.createReadmeFile=createReadmeFile; return (A) this;
  }
  public boolean hasCreateReadmeFile() {
    return this.createReadmeFile != null;
  }
  public String getExtension() {
    return this.extension;
  }
  public A withExtension(String extension) {
    this.extension=extension; return (A) this;
  }
  public boolean hasExtension() {
    return this.extension != null;
  }
  public String getTarFileClassifier() {
    return this.tarFileClassifier;
  }
  public A withTarFileClassifier(String tarFileClassifier) {
    this.tarFileClassifier=tarFileClassifier; return (A) this;
  }
  public boolean hasTarFileClassifier() {
    return this.tarFileClassifier != null;
  }
  public String getNotes() {
    return this.notes;
  }
  public A withNotes(String notes) {
    this.notes=notes; return (A) this;
  }
  public boolean hasNotes() {
    return this.notes != null;
  }
  public String getInputFolder() {
    return this.inputFolder;
  }
  public A withInputFolder(String inputFolder) {
    this.inputFolder=inputFolder; return (A) this;
  }
  public boolean hasInputFolder() {
    return this.inputFolder != null;
  }
  public String getOutputFolder() {
    return this.outputFolder;
  }
  public A withOutputFolder(String outputFolder) {
    this.outputFolder=outputFolder; return (A) this;
  }
  public boolean hasOutputFolder() {
    return this.outputFolder != null;
  }
  public A withValues(io.dekorate.helm.config.ValueReference... values) {
    if (this.values != null) {this.values.clear(); _visitables.remove("values"); }
    if (values != null) {for (ValueReference item :values){ this.addToValues(item);}} return (A) this;
  }
  public ValueReference[] buildValues() {
    int size = values != null ? values.size() : 0;
ValueReference[] result = new ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<ValueReference,ValueReferenceBuilder> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public ValueReference buildValue(int index) {
    return this.values.get(index).build();
  }
  public ValueReference buildFirstValue() {
    return this.values.get(0).build();
  }
  public ValueReference buildLastValue() {
    return this.values.get(values.size() - 1).build();
  }
  public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToValues(int index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
    if (index < 0 || index >= values.size()) { _visitables.get("values").add(builder); values.add(builder); } else { _visitables.get("values").add(index, builder); values.add(index, builder);}
    return (A)this;
  }
  public A setToValues(int index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
    if (index < 0 || index >= values.size()) { _visitables.get("values").add(builder); values.add(builder); } else { _visitables.get("values").set(index, builder); values.set(index, builder);}
    return (A)this;
  }
  public A addToValues(io.dekorate.helm.config.ValueReference... items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A addAllToValues(Collection<ValueReference> items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A removeFromValues(io.dekorate.helm.config.ValueReference... items) {
    if (this.values == null) return (A)this;
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder); this.values.remove(builder);} return (A)this;
  }
  public A removeAllFromValues(Collection<ValueReference> items) {
    if (this.values == null) return (A)this;
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder); this.values.remove(builder);} return (A)this;
  }
  public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate) {
    if (values == null) return (A) this;
    final Iterator<ValueReferenceBuilder> each = values.iterator();
    final List visitables = _visitables.get("values");
    while (each.hasNext()) {
      ValueReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public ValuesNested<A> addNewValue() {
    return new ValuesNested(-1, null);
  }
  public ValuesNested<A> addNewValueLike(ValueReference item) {
    return new ValuesNested(-1, item);
  }
  public ValuesNested<A> setNewValueLike(int index,ValueReference item) {
    return new ValuesNested(index, item);
  }
  public ValuesNested<A> editValue(int index) {
    if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
    return setNewValueLike(index, buildValue(index));
  }
  public ValuesNested<A> editFirstValue() {
    if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
    return setNewValueLike(0, buildValue(0));
  }
  public ValuesNested<A> editLastValue() {
    int index = values.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
    return setNewValueLike(index, buildValue(index));
  }
  public ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<values.size();i++) { 
    if (predicate.test(values.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
    return setNewValueLike(index, buildValue(index));
  }
  public ValuesSchema buildValuesSchema() {
    return this.valuesSchema!=null ?this.valuesSchema.build():null;
  }
  public A withValuesSchema(ValuesSchema valuesSchema) {
    _visitables.get("valuesSchema").remove(this.valuesSchema);
    if (valuesSchema!=null){ this.valuesSchema= new ValuesSchemaBuilder(valuesSchema); _visitables.get("valuesSchema").add(this.valuesSchema);} else { this.valuesSchema = null; _visitables.get("valuesSchema").remove(this.valuesSchema); } return (A) this;
  }
  public boolean hasValuesSchema() {
    return this.valuesSchema != null;
  }
  public ValuesSchemaNested<A> withNewValuesSchema() {
    return new ValuesSchemaNested(null);
  }
  public ValuesSchemaNested<A> withNewValuesSchemaLike(ValuesSchema item) {
    return new ValuesSchemaNested(item);
  }
  public ValuesSchemaNested<A> editValuesSchema() {
    return withNewValuesSchemaLike(java.util.Optional.ofNullable(buildValuesSchema()).orElse(null));
  }
  public ValuesSchemaNested<A> editOrNewValuesSchema() {
    return withNewValuesSchemaLike(java.util.Optional.ofNullable(buildValuesSchema()).orElse(new ValuesSchemaBuilder().build()));
  }
  public ValuesSchemaNested<A> editOrNewValuesSchemaLike(ValuesSchema item) {
    return withNewValuesSchemaLike(java.util.Optional.ofNullable(buildValuesSchema()).orElse(item));
  }
  public A withExpressions(io.dekorate.helm.config.HelmExpression... expressions) {
    if (this.expressions != null) {this.expressions.clear(); _visitables.remove("expressions"); }
    if (expressions != null) {for (HelmExpression item :expressions){ this.addToExpressions(item);}} return (A) this;
  }
  public HelmExpression[] buildExpressions() {
    int size = expressions != null ? expressions.size() : 0;
HelmExpression[] result = new HelmExpression[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<HelmExpression,HelmExpressionBuilder> builder : expressions) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmExpression buildExpression(int index) {
    return this.expressions.get(index).build();
  }
  public HelmExpression buildFirstExpression() {
    return this.expressions.get(0).build();
  }
  public HelmExpression buildLastExpression() {
    return this.expressions.get(expressions.size() - 1).build();
  }
  public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToExpressions(int index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
    if (index < 0 || index >= expressions.size()) { _visitables.get("expressions").add(builder); expressions.add(builder); } else { _visitables.get("expressions").add(index, builder); expressions.add(index, builder);}
    return (A)this;
  }
  public A setToExpressions(int index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
    if (index < 0 || index >= expressions.size()) { _visitables.get("expressions").add(builder); expressions.add(builder); } else { _visitables.get("expressions").set(index, builder); expressions.set(index, builder);}
    return (A)this;
  }
  public A addToExpressions(io.dekorate.helm.config.HelmExpression... items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A addAllToExpressions(Collection<HelmExpression> items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A removeFromExpressions(io.dekorate.helm.config.HelmExpression... items) {
    if (this.expressions == null) return (A)this;
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder); this.expressions.remove(builder);} return (A)this;
  }
  public A removeAllFromExpressions(Collection<HelmExpression> items) {
    if (this.expressions == null) return (A)this;
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder); this.expressions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate) {
    if (expressions == null) return (A) this;
    final Iterator<HelmExpressionBuilder> each = expressions.iterator();
    final List visitables = _visitables.get("expressions");
    while (each.hasNext()) {
      HelmExpressionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasExpressions() {
    return expressions != null && !expressions.isEmpty();
  }
  public A addNewExpression(String path,String expression) {
    return (A)addToExpressions(new HelmExpression(path, expression));
  }
  public ExpressionsNested<A> addNewExpression() {
    return new ExpressionsNested(-1, null);
  }
  public ExpressionsNested<A> addNewExpressionLike(HelmExpression item) {
    return new ExpressionsNested(-1, item);
  }
  public ExpressionsNested<A> setNewExpressionLike(int index,HelmExpression item) {
    return new ExpressionsNested(index, item);
  }
  public ExpressionsNested<A> editExpression(int index) {
    if (expressions.size() <= index) throw new RuntimeException("Can't edit expressions. Index exceeds size.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public ExpressionsNested<A> editFirstExpression() {
    if (expressions.size() == 0) throw new RuntimeException("Can't edit first expressions. The list is empty.");
    return setNewExpressionLike(0, buildExpression(0));
  }
  public ExpressionsNested<A> editLastExpression() {
    int index = expressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last expressions. The list is empty.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<expressions.size();i++) { 
    if (predicate.test(expressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching expressions. No match found.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public A withAddIfStatements(io.dekorate.helm.config.AddIfStatement... addIfStatements) {
    if (this.addIfStatements != null) {this.addIfStatements.clear(); _visitables.remove("addIfStatements"); }
    if (addIfStatements != null) {for (AddIfStatement item :addIfStatements){ this.addToAddIfStatements(item);}} return (A) this;
  }
  public AddIfStatement[] buildAddIfStatements() {
    int size = addIfStatements != null ? addIfStatements.size() : 0;
AddIfStatement[] result = new AddIfStatement[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<AddIfStatement,AddIfStatementBuilder> builder : addIfStatements) {
    result[index++]=builder.build();
}
return result;

  }
  public AddIfStatement buildAddIfStatement(int index) {
    return this.addIfStatements.get(index).build();
  }
  public AddIfStatement buildFirstAddIfStatement() {
    return this.addIfStatements.get(0).build();
  }
  public AddIfStatement buildLastAddIfStatement() {
    return this.addIfStatements.get(addIfStatements.size() - 1).build();
  }
  public AddIfStatement buildMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    for (AddIfStatementBuilder item: addIfStatements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    for (AddIfStatementBuilder item: addIfStatements) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToAddIfStatements(int index,AddIfStatement item) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
    if (index < 0 || index >= addIfStatements.size()) { _visitables.get("addIfStatements").add(builder); addIfStatements.add(builder); } else { _visitables.get("addIfStatements").add(index, builder); addIfStatements.add(index, builder);}
    return (A)this;
  }
  public A setToAddIfStatements(int index,AddIfStatement item) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
    if (index < 0 || index >= addIfStatements.size()) { _visitables.get("addIfStatements").add(builder); addIfStatements.add(builder); } else { _visitables.get("addIfStatements").set(index, builder); addIfStatements.set(index, builder);}
    return (A)this;
  }
  public A addToAddIfStatements(io.dekorate.helm.config.AddIfStatement... items) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").add(builder);this.addIfStatements.add(builder);} return (A)this;
  }
  public A addAllToAddIfStatements(Collection<AddIfStatement> items) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").add(builder);this.addIfStatements.add(builder);} return (A)this;
  }
  public A removeFromAddIfStatements(io.dekorate.helm.config.AddIfStatement... items) {
    if (this.addIfStatements == null) return (A)this;
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").remove(builder); this.addIfStatements.remove(builder);} return (A)this;
  }
  public A removeAllFromAddIfStatements(Collection<AddIfStatement> items) {
    if (this.addIfStatements == null) return (A)this;
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").remove(builder); this.addIfStatements.remove(builder);} return (A)this;
  }
  public A removeMatchingFromAddIfStatements(Predicate<AddIfStatementBuilder> predicate) {
    if (addIfStatements == null) return (A) this;
    final Iterator<AddIfStatementBuilder> each = addIfStatements.iterator();
    final List visitables = _visitables.get("addIfStatements");
    while (each.hasNext()) {
      AddIfStatementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasAddIfStatements() {
    return addIfStatements != null && !addIfStatements.isEmpty();
  }
  public A addNewAddIfStatement(String property,String onResourceKind,String onResourceName,Boolean withDefaultValue,String description) {
    return (A)addToAddIfStatements(new AddIfStatement(property, onResourceKind, onResourceName, withDefaultValue, description));
  }
  public AddIfStatementsNested<A> addNewAddIfStatement() {
    return new AddIfStatementsNested(-1, null);
  }
  public AddIfStatementsNested<A> addNewAddIfStatementLike(AddIfStatement item) {
    return new AddIfStatementsNested(-1, item);
  }
  public AddIfStatementsNested<A> setNewAddIfStatementLike(int index,AddIfStatement item) {
    return new AddIfStatementsNested(index, item);
  }
  public AddIfStatementsNested<A> editAddIfStatement(int index) {
    if (addIfStatements.size() <= index) throw new RuntimeException("Can't edit addIfStatements. Index exceeds size.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public AddIfStatementsNested<A> editFirstAddIfStatement() {
    if (addIfStatements.size() == 0) throw new RuntimeException("Can't edit first addIfStatements. The list is empty.");
    return setNewAddIfStatementLike(0, buildAddIfStatement(0));
  }
  public AddIfStatementsNested<A> editLastAddIfStatement() {
    int index = addIfStatements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addIfStatements. The list is empty.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public AddIfStatementsNested<A> editMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addIfStatements.size();i++) { 
    if (predicate.test(addIfStatements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addIfStatements. No match found.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfigFluent that = (HelmChartConfigFluent) o;
    if (!java.util.Objects.equals(enabled, that.enabled)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(home, that.home)) return false;

    if (!java.util.Objects.equals(sources, that.sources)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(keywords, that.keywords)) return false;

    if (!java.util.Objects.equals(maintainers, that.maintainers)) return false;

    if (!java.util.Objects.equals(icon, that.icon)) return false;

    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(condition, that.condition)) return false;

    if (!java.util.Objects.equals(tags, that.tags)) return false;

    if (!java.util.Objects.equals(appVersion, that.appVersion)) return false;

    if (!java.util.Objects.equals(deprecated, that.deprecated)) return false;

    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(kubeVersion, that.kubeVersion)) return false;

    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(valuesRootAlias, that.valuesRootAlias)) return false;

    if (!java.util.Objects.equals(valuesProfileSeparator, that.valuesProfileSeparator)) return false;

    if (!java.util.Objects.equals(createTarFile, that.createTarFile)) return false;

    if (!java.util.Objects.equals(createValuesSchemaFile, that.createValuesSchemaFile)) return false;

    if (!java.util.Objects.equals(createReadmeFile, that.createReadmeFile)) return false;

    if (!java.util.Objects.equals(extension, that.extension)) return false;

    if (!java.util.Objects.equals(tarFileClassifier, that.tarFileClassifier)) return false;

    if (!java.util.Objects.equals(notes, that.notes)) return false;

    if (!java.util.Objects.equals(inputFolder, that.inputFolder)) return false;

    if (!java.util.Objects.equals(outputFolder, that.outputFolder)) return false;

    if (!java.util.Objects.equals(values, that.values)) return false;

    if (!java.util.Objects.equals(valuesSchema, that.valuesSchema)) return false;

    if (!java.util.Objects.equals(expressions, that.expressions)) return false;

    if (!java.util.Objects.equals(addIfStatements, that.addIfStatements)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  home,  sources,  version,  description,  keywords,  maintainers,  icon,  apiVersion,  condition,  tags,  appVersion,  deprecated,  annotations,  kubeVersion,  dependencies,  type,  valuesRootAlias,  valuesProfileSeparator,  createTarFile,  createValuesSchemaFile,  createReadmeFile,  extension,  tarFileClassifier,  notes,  inputFolder,  outputFolder,  values,  valuesSchema,  expressions,  addIfStatements,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (home != null) { sb.append("home:"); sb.append(home + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (maintainers != null) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (tags != null) { sb.append("tags:"); sb.append(tags + ","); }
    if (appVersion != null) { sb.append("appVersion:"); sb.append(appVersion + ","); }
    if (deprecated != null) { sb.append("deprecated:"); sb.append(deprecated + ","); }
    if (annotations != null) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (kubeVersion != null) { sb.append("kubeVersion:"); sb.append(kubeVersion + ","); }
    if (dependencies != null) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (valuesRootAlias != null) { sb.append("valuesRootAlias:"); sb.append(valuesRootAlias + ","); }
    if (valuesProfileSeparator != null) { sb.append("valuesProfileSeparator:"); sb.append(valuesProfileSeparator + ","); }
    if (createTarFile != null) { sb.append("createTarFile:"); sb.append(createTarFile + ","); }
    if (createValuesSchemaFile != null) { sb.append("createValuesSchemaFile:"); sb.append(createValuesSchemaFile + ","); }
    if (createReadmeFile != null) { sb.append("createReadmeFile:"); sb.append(createReadmeFile + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (tarFileClassifier != null) { sb.append("tarFileClassifier:"); sb.append(tarFileClassifier + ","); }
    if (notes != null) { sb.append("notes:"); sb.append(notes + ","); }
    if (inputFolder != null) { sb.append("inputFolder:"); sb.append(inputFolder + ","); }
    if (outputFolder != null) { sb.append("outputFolder:"); sb.append(outputFolder + ","); }
    if (values != null) { sb.append("values:"); sb.append(values + ","); }
    if (valuesSchema != null) { sb.append("valuesSchema:"); sb.append(valuesSchema + ","); }
    if (expressions != null) { sb.append("expressions:"); sb.append(expressions + ","); }
    if (addIfStatements != null) { sb.append("addIfStatements:"); sb.append(addIfStatements); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnabled() {
    return withEnabled(true);
  }
  public A withDeprecated() {
    return withDeprecated(true);
  }
  public A withCreateTarFile() {
    return withCreateTarFile(true);
  }
  public A withCreateValuesSchemaFile() {
    return withCreateValuesSchemaFile(true);
  }
  public A withCreateReadmeFile() {
    return withCreateReadmeFile(true);
  }
  public class MaintainersNested<N> extends MaintainerFluent<MaintainersNested<N>> implements Nested<N>{
    MaintainersNested(int index,Maintainer item) {
      this.index = index;
      this.builder = new MaintainerBuilder(this, item);
    }
    MaintainerBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  public class AnnotationsNested<N> extends AnnotationFluent<AnnotationsNested<N>> implements Nested<N>{
    AnnotationsNested(int index,Annotation item) {
      this.index = index;
      this.builder = new AnnotationBuilder(this, item);
    }
    AnnotationBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToAnnotations(index,builder.build());
    }
    public N endAnnotation() {
      return and();
    }
    
  }
  public class DependenciesNested<N> extends HelmDependencyFluent<DependenciesNested<N>> implements Nested<N>{
    DependenciesNested(int index,HelmDependency item) {
      this.index = index;
      this.builder = new HelmDependencyBuilder(this, item);
    }
    HelmDependencyBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  public class ValuesNested<N> extends ValueReferenceFluent<ValuesNested<N>> implements Nested<N>{
    ValuesNested(int index,ValueReference item) {
      this.index = index;
      this.builder = new ValueReferenceBuilder(this, item);
    }
    ValueReferenceBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToValues(index,builder.build());
    }
    public N endValue() {
      return and();
    }
    
  }
  public class ValuesSchemaNested<N> extends ValuesSchemaFluent<ValuesSchemaNested<N>> implements Nested<N>{
    ValuesSchemaNested(ValuesSchema item) {
      this.builder = new ValuesSchemaBuilder(this, item);
    }
    ValuesSchemaBuilder builder;
    public N and() {
      return (N) HelmChartConfigFluent.this.withValuesSchema(builder.build());
    }
    public N endValuesSchema() {
      return and();
    }
    
  }
  public class ExpressionsNested<N> extends HelmExpressionFluent<ExpressionsNested<N>> implements Nested<N>{
    ExpressionsNested(int index,HelmExpression item) {
      this.index = index;
      this.builder = new HelmExpressionBuilder(this, item);
    }
    HelmExpressionBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToExpressions(index,builder.build());
    }
    public N endExpression() {
      return and();
    }
    
  }
  public class AddIfStatementsNested<N> extends AddIfStatementFluent<AddIfStatementsNested<N>> implements Nested<N>{
    AddIfStatementsNested(int index,AddIfStatement item) {
      this.index = index;
      this.builder = new AddIfStatementBuilder(this, item);
    }
    AddIfStatementBuilder builder;
    int index;
    public N and() {
      return (N) HelmChartConfigFluent.this.setToAddIfStatements(index,builder.build());
    }
    public N endAddIfStatement() {
      return and();
    }
    
  }
  
}