package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HelmChartConfigFluentImpl<A extends HelmChartConfigFluent<A>> extends ConfigurationFluentImpl<A> implements HelmChartConfigFluent<A>{
  public HelmChartConfigFluentImpl() {
  }
  public HelmChartConfigFluentImpl(HelmChartConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withEnabled(instance.getEnabled()); 
    this.withName(instance.getName()); 
    this.withHome(instance.getHome()); 
    this.withSources(instance.getSources()); 
    this.withVersion(instance.getVersion()); 
    this.withDescription(instance.getDescription()); 
    this.withKeywords(instance.getKeywords()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withIcon(instance.getIcon()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCondition(instance.getCondition()); 
    this.withTags(instance.getTags()); 
    this.withAppVersion(instance.getAppVersion()); 
    this.withDeprecated(instance.getDeprecated()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withKubeVersion(instance.getKubeVersion()); 
    this.withDependencies(instance.getDependencies()); 
    this.withType(instance.getType()); 
    this.withValuesRootAlias(instance.getValuesRootAlias()); 
    this.withValuesProfileSeparator(instance.getValuesProfileSeparator()); 
    this.withCreateTarFile(instance.getCreateTarFile()); 
    this.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile()); 
    this.withCreateReadmeFile(instance.getCreateReadmeFile()); 
    this.withExtension(instance.getExtension()); 
    this.withTarFileClassifier(instance.getTarFileClassifier()); 
    this.withNotes(instance.getNotes()); 
    this.withInputFolder(instance.getInputFolder()); 
    this.withOutputFolder(instance.getOutputFolder()); 
    this.withValues(instance.getValues()); 
    this.withValuesSchema(instance.getValuesSchema()); 
    this.withExpressions(instance.getExpressions()); 
    this.withAddIfStatements(instance.getAddIfStatements()); 
  }
  private Boolean enabled;
  private String name;
  private String home;
  private List<String> sources = new ArrayList<String>();
  private String version;
  private String description;
  private List<String> keywords = new ArrayList<String>();
  private ArrayList<MaintainerBuilder> maintainers = new ArrayList<MaintainerBuilder>();
  private String icon;
  private String apiVersion;
  private String condition;
  private String tags;
  private String appVersion;
  private Boolean deprecated;
  private ArrayList<AnnotationBuilder> annotations = new ArrayList<AnnotationBuilder>();
  private String kubeVersion;
  private ArrayList<HelmDependencyBuilder> dependencies = new ArrayList<HelmDependencyBuilder>();
  private String type;
  private String valuesRootAlias;
  private String valuesProfileSeparator;
  private Boolean createTarFile;
  private Boolean createValuesSchemaFile;
  private Boolean createReadmeFile;
  private String extension;
  private String tarFileClassifier;
  private String notes;
  private String inputFolder;
  private String outputFolder;
  private ArrayList<ValueReferenceBuilder> values = new ArrayList<ValueReferenceBuilder>();
  private ValuesSchemaBuilder valuesSchema;
  private ArrayList<HelmExpressionBuilder> expressions = new ArrayList<HelmExpressionBuilder>();
  private ArrayList<AddIfStatementBuilder> addIfStatements = new ArrayList<AddIfStatementBuilder>();
  public Boolean getEnabled() {
    return this.enabled;
  }
  public A withEnabled(Boolean enabled) {
    this.enabled=enabled; return (A) this;
  }
  public Boolean hasEnabled() {
    return this.enabled != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getHome() {
    return this.home;
  }
  public A withHome(String home) {
    this.home=home; return (A) this;
  }
  public Boolean hasHome() {
    return this.home != null;
  }
  public A withSources(java.lang.String... sources) {
    if (this.sources != null) {this.sources.clear();}
    if (sources != null) {for (String item :sources){ this.addToSources(item);}} return (A) this;
  }
  public String[] getSources() {
    //This needs to work with primitives, so we use arrays.
int size = sources != null ? sources.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : sources) {
    result[index++]=item;
}
return result;

  }
  public A addToSources(Integer index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.add(index, item);
    return (A)this;
  }
  public A setToSources(Integer index,String item) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    this.sources.set(index, item); return (A)this;
  }
  public A addToSources(java.lang.String... items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A addAllToSources(Collection<String> items) {
    if (this.sources == null) {this.sources = new ArrayList<String>();}
    for (String item : items) {this.sources.add(item);} return (A)this;
  }
  public A removeFromSources(java.lang.String... items) {
    for (String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public A removeAllFromSources(Collection<String> items) {
    for (String item : items) {if (this.sources!= null){ this.sources.remove(item);}} return (A)this;
  }
  public Boolean hasSources() {
    return sources != null && !sources.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear();}
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public String[] getKeywords() {
    //This needs to work with primitives, so we use arrays.
int size = keywords != null ? keywords.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : keywords) {
    result[index++]=item;
}
return result;

  }
  public A addToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(Integer index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public Boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A withMaintainers(io.dekorate.helm.config.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear();}
    if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   */
  @Deprecated
  public Maintainer[] getMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
Maintainer[] result = new Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Maintainer[] buildMaintainers() {
    int size = maintainers != null ? maintainers.size() : 0;
Maintainer[] result = new Maintainer[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Maintainer,?> builder : maintainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Maintainer buildMaintainer(Integer index) {
    return this.maintainers.get(index).build();
  }
  public Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToMaintainers(Integer index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(index >= 0 ? index : _visitables.get("maintainers").size(), builder);this.maintainers.add(index >= 0 ? index : maintainers.size(), builder); return (A)this;
  }
  public A setToMaintainers(Integer index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= _visitables.get("maintainers").size()) { _visitables.get("maintainers").add(builder); } else { _visitables.get("maintainers").set(index, builder);}
    if (index < 0 || index >= maintainers.size()) { maintainers.add(builder); } else { maintainers.set(index, builder);}
     return (A)this;
  }
  public A addToMaintainers(io.dekorate.helm.config.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.dekorate.helm.config.Maintainer... items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<Maintainer> items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String name,String email,String url) {
    return (A)addToMaintainers(new Maintainer(name, email, url));
  }
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainer() {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl();
  }
  public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.MaintainersNested<A> setNewMaintainerLike(Integer index,Maintainer item) {
    return new HelmChartConfigFluentImpl.MaintainersNestedImpl(index, item);
  }
  public HelmChartConfigFluent.MaintainersNested<A> editMaintainer(Integer index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public HelmChartConfigFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public String getIcon() {
    return this.icon;
  }
  public A withIcon(String icon) {
    this.icon=icon; return (A) this;
  }
  public Boolean hasIcon() {
    return this.icon != null;
  }
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getCondition() {
    return this.condition;
  }
  public A withCondition(String condition) {
    this.condition=condition; return (A) this;
  }
  public Boolean hasCondition() {
    return this.condition != null;
  }
  public String getTags() {
    return this.tags;
  }
  public A withTags(String tags) {
    this.tags=tags; return (A) this;
  }
  public Boolean hasTags() {
    return this.tags != null;
  }
  public String getAppVersion() {
    return this.appVersion;
  }
  public A withAppVersion(String appVersion) {
    this.appVersion=appVersion; return (A) this;
  }
  public Boolean hasAppVersion() {
    return this.appVersion != null;
  }
  public Boolean getDeprecated() {
    return this.deprecated;
  }
  public A withDeprecated(Boolean deprecated) {
    this.deprecated=deprecated; return (A) this;
  }
  public Boolean hasDeprecated() {
    return this.deprecated != null;
  }
  public A withAnnotations(io.dekorate.helm.config.Annotation... annotations) {
    if (this.annotations != null) {this.annotations.clear();}
    if (annotations != null) {for (Annotation item :annotations){ this.addToAnnotations(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildAnnotations instead.
   */
  @Deprecated
  public Annotation[] getAnnotations() {
    int size = annotations != null ? annotations.size() : 0;
Annotation[] result = new Annotation[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Annotation,?> builder : annotations) {
    result[index++]=builder.build();
}
return result;

  }
  public Annotation[] buildAnnotations() {
    int size = annotations != null ? annotations.size() : 0;
Annotation[] result = new Annotation[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Annotation,?> builder : annotations) {
    result[index++]=builder.build();
}
return result;

  }
  public Annotation buildAnnotation(Integer index) {
    return this.annotations.get(index).build();
  }
  public Annotation buildFirstAnnotation() {
    return this.annotations.get(0).build();
  }
  public Annotation buildLastAnnotation() {
    return this.annotations.get(annotations.size() - 1).build();
  }
  public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    for (AnnotationBuilder item: annotations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    for (AnnotationBuilder item: annotations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToAnnotations(Integer index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(index >= 0 ? index : _visitables.get("annotations").size(), builder);this.annotations.add(index >= 0 ? index : annotations.size(), builder); return (A)this;
  }
  public A setToAnnotations(Integer index,Annotation item) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    AnnotationBuilder builder = new AnnotationBuilder(item);
    if (index < 0 || index >= _visitables.get("annotations").size()) { _visitables.get("annotations").add(builder); } else { _visitables.get("annotations").set(index, builder);}
    if (index < 0 || index >= annotations.size()) { annotations.add(builder); } else { annotations.set(index, builder);}
     return (A)this;
  }
  public A addToAnnotations(io.dekorate.helm.config.Annotation... items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  public A addAllToAnnotations(Collection<Annotation> items) {
    if (this.annotations == null) {this.annotations = new ArrayList<AnnotationBuilder>();}
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").add(builder);this.annotations.add(builder);} return (A)this;
  }
  public A removeFromAnnotations(io.dekorate.helm.config.Annotation... items) {
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder);if (this.annotations != null) {this.annotations.remove(builder);}} return (A)this;
  }
  public A removeAllFromAnnotations(Collection<Annotation> items) {
    for (Annotation item : items) {AnnotationBuilder builder = new AnnotationBuilder(item);_visitables.get("annotations").remove(builder);if (this.annotations != null) {this.annotations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
    if (annotations == null) return (A) this;
    final Iterator<AnnotationBuilder> each = annotations.iterator();
    final List visitables = _visitables.get("annotations");
    while (each.hasNext()) {
      AnnotationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasAnnotations() {
    return annotations != null && !annotations.isEmpty();
  }
  public A addNewAnnotation(String key,String value) {
    return (A)addToAnnotations(new Annotation(key, value));
  }
  public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotation() {
    return new HelmChartConfigFluentImpl.AnnotationsNestedImpl();
  }
  public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
    return new HelmChartConfigFluentImpl.AnnotationsNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index,Annotation item) {
    return new HelmChartConfigFluentImpl.AnnotationsNestedImpl(index, item);
  }
  public HelmChartConfigFluent.AnnotationsNested<A> editAnnotation(Integer index) {
    if (annotations.size() <= index) throw new RuntimeException("Can't edit annotations. Index exceeds size.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public HelmChartConfigFluent.AnnotationsNested<A> editFirstAnnotation() {
    if (annotations.size() == 0) throw new RuntimeException("Can't edit first annotations. The list is empty.");
    return setNewAnnotationLike(0, buildAnnotation(0));
  }
  public HelmChartConfigFluent.AnnotationsNested<A> editLastAnnotation() {
    int index = annotations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last annotations. The list is empty.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public HelmChartConfigFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<annotations.size();i++) { 
    if (predicate.test(annotations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching annotations. No match found.");
    return setNewAnnotationLike(index, buildAnnotation(index));
  }
  public String getKubeVersion() {
    return this.kubeVersion;
  }
  public A withKubeVersion(String kubeVersion) {
    this.kubeVersion=kubeVersion; return (A) this;
  }
  public Boolean hasKubeVersion() {
    return this.kubeVersion != null;
  }
  public A withDependencies(io.dekorate.helm.config.HelmDependency... dependencies) {
    if (this.dependencies != null) {this.dependencies.clear();}
    if (dependencies != null) {for (HelmDependency item :dependencies){ this.addToDependencies(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildDependencies instead.
   */
  @Deprecated
  public HelmDependency[] getDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
HelmDependency[] result = new HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmDependency[] buildDependencies() {
    int size = dependencies != null ? dependencies.size() : 0;
HelmDependency[] result = new HelmDependency[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmDependency,?> builder : dependencies) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmDependency buildDependency(Integer index) {
    return this.dependencies.get(index).build();
  }
  public HelmDependency buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  public HelmDependency buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    for (HelmDependencyBuilder item: dependencies) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToDependencies(Integer index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(index >= 0 ? index : _visitables.get("dependencies").size(), builder);this.dependencies.add(index >= 0 ? index : dependencies.size(), builder); return (A)this;
  }
  public A setToDependencies(Integer index,HelmDependency item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
    if (index < 0 || index >= _visitables.get("dependencies").size()) { _visitables.get("dependencies").add(builder); } else { _visitables.get("dependencies").set(index, builder);}
    if (index < 0 || index >= dependencies.size()) { dependencies.add(builder); } else { dependencies.set(index, builder);}
     return (A)this;
  }
  public A addToDependencies(io.dekorate.helm.config.HelmDependency... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A addAllToDependencies(Collection<HelmDependency> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<HelmDependencyBuilder>();}
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  public A removeFromDependencies(io.dekorate.helm.config.HelmDependency... items) {
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeAllFromDependencies(Collection<HelmDependency> items) {
    for (HelmDependency item : items) {HelmDependencyBuilder builder = new HelmDependencyBuilder(item);_visitables.get("dependencies").remove(builder);if (this.dependencies != null) {this.dependencies.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<HelmDependencyBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      HelmDependencyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasDependencies() {
    return dependencies != null && !dependencies.isEmpty();
  }
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependency() {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl();
  }
  public HelmChartConfigFluent.DependenciesNested<A> addNewDependencyLike(HelmDependency item) {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.DependenciesNested<A> setNewDependencyLike(Integer index,HelmDependency item) {
    return new HelmChartConfigFluentImpl.DependenciesNestedImpl(index, item);
  }
  public HelmChartConfigFluent.DependenciesNested<A> editDependency(Integer index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public HelmChartConfigFluent.DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public String getValuesRootAlias() {
    return this.valuesRootAlias;
  }
  public A withValuesRootAlias(String valuesRootAlias) {
    this.valuesRootAlias=valuesRootAlias; return (A) this;
  }
  public Boolean hasValuesRootAlias() {
    return this.valuesRootAlias != null;
  }
  public String getValuesProfileSeparator() {
    return this.valuesProfileSeparator;
  }
  public A withValuesProfileSeparator(String valuesProfileSeparator) {
    this.valuesProfileSeparator=valuesProfileSeparator; return (A) this;
  }
  public Boolean hasValuesProfileSeparator() {
    return this.valuesProfileSeparator != null;
  }
  public Boolean getCreateTarFile() {
    return this.createTarFile;
  }
  public A withCreateTarFile(Boolean createTarFile) {
    this.createTarFile=createTarFile; return (A) this;
  }
  public Boolean hasCreateTarFile() {
    return this.createTarFile != null;
  }
  public Boolean getCreateValuesSchemaFile() {
    return this.createValuesSchemaFile;
  }
  public A withCreateValuesSchemaFile(Boolean createValuesSchemaFile) {
    this.createValuesSchemaFile=createValuesSchemaFile; return (A) this;
  }
  public Boolean hasCreateValuesSchemaFile() {
    return this.createValuesSchemaFile != null;
  }
  public Boolean getCreateReadmeFile() {
    return this.createReadmeFile;
  }
  public A withCreateReadmeFile(Boolean createReadmeFile) {
    this.createReadmeFile=createReadmeFile; return (A) this;
  }
  public Boolean hasCreateReadmeFile() {
    return this.createReadmeFile != null;
  }
  public String getExtension() {
    return this.extension;
  }
  public A withExtension(String extension) {
    this.extension=extension; return (A) this;
  }
  public Boolean hasExtension() {
    return this.extension != null;
  }
  public String getTarFileClassifier() {
    return this.tarFileClassifier;
  }
  public A withTarFileClassifier(String tarFileClassifier) {
    this.tarFileClassifier=tarFileClassifier; return (A) this;
  }
  public Boolean hasTarFileClassifier() {
    return this.tarFileClassifier != null;
  }
  public String getNotes() {
    return this.notes;
  }
  public A withNotes(String notes) {
    this.notes=notes; return (A) this;
  }
  public Boolean hasNotes() {
    return this.notes != null;
  }
  public String getInputFolder() {
    return this.inputFolder;
  }
  public A withInputFolder(String inputFolder) {
    this.inputFolder=inputFolder; return (A) this;
  }
  public Boolean hasInputFolder() {
    return this.inputFolder != null;
  }
  public String getOutputFolder() {
    return this.outputFolder;
  }
  public A withOutputFolder(String outputFolder) {
    this.outputFolder=outputFolder; return (A) this;
  }
  public Boolean hasOutputFolder() {
    return this.outputFolder != null;
  }
  public A withValues(io.dekorate.helm.config.ValueReference... values) {
    if (this.values != null) {this.values.clear();}
    if (values != null) {for (ValueReference item :values){ this.addToValues(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildValues instead.
   */
  @Deprecated
  public ValueReference[] getValues() {
    int size = values != null ? values.size() : 0;
ValueReference[] result = new ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public ValueReference[] buildValues() {
    int size = values != null ? values.size() : 0;
ValueReference[] result = new ValueReference[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends ValueReference,?> builder : values) {
    result[index++]=builder.build();
}
return result;

  }
  public ValueReference buildValue(Integer index) {
    return this.values.get(index).build();
  }
  public ValueReference buildFirstValue() {
    return this.values.get(0).build();
  }
  public ValueReference buildLastValue() {
    return this.values.get(values.size() - 1).build();
  }
  public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    for (ValueReferenceBuilder item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToValues(Integer index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(index >= 0 ? index : _visitables.get("values").size(), builder);this.values.add(index >= 0 ? index : values.size(), builder); return (A)this;
  }
  public A setToValues(Integer index,ValueReference item) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("values").size()) { _visitables.get("values").add(builder); } else { _visitables.get("values").set(index, builder);}
    if (index < 0 || index >= values.size()) { values.add(builder); } else { values.set(index, builder);}
     return (A)this;
  }
  public A addToValues(io.dekorate.helm.config.ValueReference... items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A addAllToValues(Collection<ValueReference> items) {
    if (this.values == null) {this.values = new ArrayList<ValueReferenceBuilder>();}
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  public A removeFromValues(io.dekorate.helm.config.ValueReference... items) {
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeAllFromValues(Collection<ValueReference> items) {
    for (ValueReference item : items) {ValueReferenceBuilder builder = new ValueReferenceBuilder(item);_visitables.get("values").remove(builder);if (this.values != null) {this.values.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate) {
    if (values == null) return (A) this;
    final Iterator<ValueReferenceBuilder> each = values.iterator();
    final List visitables = _visitables.get("values");
    while (each.hasNext()) {
      ValueReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  public HelmChartConfigFluent.ValuesNested<A> addNewValue() {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl();
  }
  public HelmChartConfigFluent.ValuesNested<A> addNewValueLike(ValueReference item) {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.ValuesNested<A> setNewValueLike(Integer index,ValueReference item) {
    return new HelmChartConfigFluentImpl.ValuesNestedImpl(index, item);
  }
  public HelmChartConfigFluent.ValuesNested<A> editValue(Integer index) {
    if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
    return setNewValueLike(index, buildValue(index));
  }
  public HelmChartConfigFluent.ValuesNested<A> editFirstValue() {
    if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
    return setNewValueLike(0, buildValue(0));
  }
  public HelmChartConfigFluent.ValuesNested<A> editLastValue() {
    int index = values.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
    return setNewValueLike(index, buildValue(index));
  }
  public HelmChartConfigFluent.ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<values.size();i++) { 
    if (predicate.test(values.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
    return setNewValueLike(index, buildValue(index));
  }
  
  /**
   * This method has been deprecated, please use method buildValuesSchema instead.
   * @return The buildable object.
   */
  @Deprecated
  public ValuesSchema getValuesSchema() {
    return this.valuesSchema!=null ?this.valuesSchema.build():null;
  }
  public ValuesSchema buildValuesSchema() {
    return this.valuesSchema!=null ?this.valuesSchema.build():null;
  }
  public A withValuesSchema(ValuesSchema valuesSchema) {
    _visitables.get("valuesSchema").remove(this.valuesSchema);
    if (valuesSchema!=null){ this.valuesSchema= new ValuesSchemaBuilder(valuesSchema); _visitables.get("valuesSchema").add(this.valuesSchema);} else { this.valuesSchema = null; _visitables.get("valuesSchema").remove(this.valuesSchema); } return (A) this;
  }
  public Boolean hasValuesSchema() {
    return this.valuesSchema != null;
  }
  public HelmChartConfigFluent.ValuesSchemaNested<A> withNewValuesSchema() {
    return new HelmChartConfigFluentImpl.ValuesSchemaNestedImpl();
  }
  public HelmChartConfigFluent.ValuesSchemaNested<A> withNewValuesSchemaLike(ValuesSchema item) {
    return new HelmChartConfigFluentImpl.ValuesSchemaNestedImpl(item);
  }
  public HelmChartConfigFluent.ValuesSchemaNested<A> editValuesSchema() {
    return withNewValuesSchemaLike(getValuesSchema());
  }
  public HelmChartConfigFluent.ValuesSchemaNested<A> editOrNewValuesSchema() {
    return withNewValuesSchemaLike(getValuesSchema() != null ? getValuesSchema(): new ValuesSchemaBuilder().build());
  }
  public HelmChartConfigFluent.ValuesSchemaNested<A> editOrNewValuesSchemaLike(ValuesSchema item) {
    return withNewValuesSchemaLike(getValuesSchema() != null ? getValuesSchema(): item);
  }
  public A withExpressions(io.dekorate.helm.config.HelmExpression... expressions) {
    if (this.expressions != null) {this.expressions.clear();}
    if (expressions != null) {for (HelmExpression item :expressions){ this.addToExpressions(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildExpressions instead.
   */
  @Deprecated
  public HelmExpression[] getExpressions() {
    int size = expressions != null ? expressions.size() : 0;
HelmExpression[] result = new HelmExpression[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmExpression,?> builder : expressions) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmExpression[] buildExpressions() {
    int size = expressions != null ? expressions.size() : 0;
HelmExpression[] result = new HelmExpression[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends HelmExpression,?> builder : expressions) {
    result[index++]=builder.build();
}
return result;

  }
  public HelmExpression buildExpression(Integer index) {
    return this.expressions.get(index).build();
  }
  public HelmExpression buildFirstExpression() {
    return this.expressions.get(0).build();
  }
  public HelmExpression buildLastExpression() {
    return this.expressions.get(expressions.size() - 1).build();
  }
  public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    for (HelmExpressionBuilder item: expressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToExpressions(Integer index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(index >= 0 ? index : _visitables.get("expressions").size(), builder);this.expressions.add(index >= 0 ? index : expressions.size(), builder); return (A)this;
  }
  public A setToExpressions(Integer index,HelmExpression item) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
    if (index < 0 || index >= _visitables.get("expressions").size()) { _visitables.get("expressions").add(builder); } else { _visitables.get("expressions").set(index, builder);}
    if (index < 0 || index >= expressions.size()) { expressions.add(builder); } else { expressions.set(index, builder);}
     return (A)this;
  }
  public A addToExpressions(io.dekorate.helm.config.HelmExpression... items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A addAllToExpressions(Collection<HelmExpression> items) {
    if (this.expressions == null) {this.expressions = new ArrayList<HelmExpressionBuilder>();}
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").add(builder);this.expressions.add(builder);} return (A)this;
  }
  public A removeFromExpressions(io.dekorate.helm.config.HelmExpression... items) {
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder);if (this.expressions != null) {this.expressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromExpressions(Collection<HelmExpression> items) {
    for (HelmExpression item : items) {HelmExpressionBuilder builder = new HelmExpressionBuilder(item);_visitables.get("expressions").remove(builder);if (this.expressions != null) {this.expressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate) {
    if (expressions == null) return (A) this;
    final Iterator<HelmExpressionBuilder> each = expressions.iterator();
    final List visitables = _visitables.get("expressions");
    while (each.hasNext()) {
      HelmExpressionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasExpressions() {
    return expressions != null && !expressions.isEmpty();
  }
  public A addNewExpression(String path,String expression) {
    return (A)addToExpressions(new HelmExpression(path, expression));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpression() {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl();
  }
  public HelmChartConfigFluent.ExpressionsNested<A> addNewExpressionLike(HelmExpression item) {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.ExpressionsNested<A> setNewExpressionLike(Integer index,HelmExpression item) {
    return new HelmChartConfigFluentImpl.ExpressionsNestedImpl(index, item);
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editExpression(Integer index) {
    if (expressions.size() <= index) throw new RuntimeException("Can't edit expressions. Index exceeds size.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editFirstExpression() {
    if (expressions.size() == 0) throw new RuntimeException("Can't edit first expressions. The list is empty.");
    return setNewExpressionLike(0, buildExpression(0));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editLastExpression() {
    int index = expressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last expressions. The list is empty.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public HelmChartConfigFluent.ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<expressions.size();i++) { 
    if (predicate.test(expressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching expressions. No match found.");
    return setNewExpressionLike(index, buildExpression(index));
  }
  public A withAddIfStatements(io.dekorate.helm.config.AddIfStatement... addIfStatements) {
    if (this.addIfStatements != null) {this.addIfStatements.clear();}
    if (addIfStatements != null) {for (AddIfStatement item :addIfStatements){ this.addToAddIfStatements(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddIfStatements instead.
   */
  @Deprecated
  public AddIfStatement[] getAddIfStatements() {
    int size = addIfStatements != null ? addIfStatements.size() : 0;
AddIfStatement[] result = new AddIfStatement[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends AddIfStatement,?> builder : addIfStatements) {
    result[index++]=builder.build();
}
return result;

  }
  public AddIfStatement[] buildAddIfStatements() {
    int size = addIfStatements != null ? addIfStatements.size() : 0;
AddIfStatement[] result = new AddIfStatement[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends AddIfStatement,?> builder : addIfStatements) {
    result[index++]=builder.build();
}
return result;

  }
  public AddIfStatement buildAddIfStatement(Integer index) {
    return this.addIfStatements.get(index).build();
  }
  public AddIfStatement buildFirstAddIfStatement() {
    return this.addIfStatements.get(0).build();
  }
  public AddIfStatement buildLastAddIfStatement() {
    return this.addIfStatements.get(addIfStatements.size() - 1).build();
  }
  public AddIfStatement buildMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    for (AddIfStatementBuilder item: addIfStatements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    for (AddIfStatementBuilder item: addIfStatements) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToAddIfStatements(Integer index,AddIfStatement item) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").add(index >= 0 ? index : _visitables.get("addIfStatements").size(), builder);this.addIfStatements.add(index >= 0 ? index : addIfStatements.size(), builder); return (A)this;
  }
  public A setToAddIfStatements(Integer index,AddIfStatement item) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
    if (index < 0 || index >= _visitables.get("addIfStatements").size()) { _visitables.get("addIfStatements").add(builder); } else { _visitables.get("addIfStatements").set(index, builder);}
    if (index < 0 || index >= addIfStatements.size()) { addIfStatements.add(builder); } else { addIfStatements.set(index, builder);}
     return (A)this;
  }
  public A addToAddIfStatements(io.dekorate.helm.config.AddIfStatement... items) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").add(builder);this.addIfStatements.add(builder);} return (A)this;
  }
  public A addAllToAddIfStatements(Collection<AddIfStatement> items) {
    if (this.addIfStatements == null) {this.addIfStatements = new ArrayList<AddIfStatementBuilder>();}
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").add(builder);this.addIfStatements.add(builder);} return (A)this;
  }
  public A removeFromAddIfStatements(io.dekorate.helm.config.AddIfStatement... items) {
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").remove(builder);if (this.addIfStatements != null) {this.addIfStatements.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddIfStatements(Collection<AddIfStatement> items) {
    for (AddIfStatement item : items) {AddIfStatementBuilder builder = new AddIfStatementBuilder(item);_visitables.get("addIfStatements").remove(builder);if (this.addIfStatements != null) {this.addIfStatements.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddIfStatements(Predicate<AddIfStatementBuilder> predicate) {
    if (addIfStatements == null) return (A) this;
    final Iterator<AddIfStatementBuilder> each = addIfStatements.iterator();
    final List visitables = _visitables.get("addIfStatements");
    while (each.hasNext()) {
      AddIfStatementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasAddIfStatements() {
    return addIfStatements != null && !addIfStatements.isEmpty();
  }
  public A addNewAddIfStatement(String property,String onResourceKind,String onResourceName,Boolean withDefaultValue,String description) {
    return (A)addToAddIfStatements(new AddIfStatement(property, onResourceKind, onResourceName, withDefaultValue, description));
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatement() {
    return new HelmChartConfigFluentImpl.AddIfStatementsNestedImpl();
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatementLike(AddIfStatement item) {
    return new HelmChartConfigFluentImpl.AddIfStatementsNestedImpl(-1, item);
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> setNewAddIfStatementLike(Integer index,AddIfStatement item) {
    return new HelmChartConfigFluentImpl.AddIfStatementsNestedImpl(index, item);
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> editAddIfStatement(Integer index) {
    if (addIfStatements.size() <= index) throw new RuntimeException("Can't edit addIfStatements. Index exceeds size.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> editFirstAddIfStatement() {
    if (addIfStatements.size() == 0) throw new RuntimeException("Can't edit first addIfStatements. The list is empty.");
    return setNewAddIfStatementLike(0, buildAddIfStatement(0));
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> editLastAddIfStatement() {
    int index = addIfStatements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addIfStatements. The list is empty.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public HelmChartConfigFluent.AddIfStatementsNested<A> editMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addIfStatements.size();i++) { 
    if (predicate.test(addIfStatements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addIfStatements. No match found.");
    return setNewAddIfStatementLike(index, buildAddIfStatement(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HelmChartConfigFluentImpl that = (HelmChartConfigFluentImpl) o;
    if (enabled != null ? !enabled.equals(that.enabled) :that.enabled != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (home != null ? !home.equals(that.home) :that.home != null) return false;
    if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (keywords != null ? !keywords.equals(that.keywords) :that.keywords != null) return false;
    if (maintainers != null ? !maintainers.equals(that.maintainers) :that.maintainers != null) return false;
    if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (condition != null ? !condition.equals(that.condition) :that.condition != null) return false;
    if (tags != null ? !tags.equals(that.tags) :that.tags != null) return false;
    if (appVersion != null ? !appVersion.equals(that.appVersion) :that.appVersion != null) return false;
    if (deprecated != null ? !deprecated.equals(that.deprecated) :that.deprecated != null) return false;
    if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
    if (kubeVersion != null ? !kubeVersion.equals(that.kubeVersion) :that.kubeVersion != null) return false;
    if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (valuesRootAlias != null ? !valuesRootAlias.equals(that.valuesRootAlias) :that.valuesRootAlias != null) return false;
    if (valuesProfileSeparator != null ? !valuesProfileSeparator.equals(that.valuesProfileSeparator) :that.valuesProfileSeparator != null) return false;
    if (createTarFile != null ? !createTarFile.equals(that.createTarFile) :that.createTarFile != null) return false;
    if (createValuesSchemaFile != null ? !createValuesSchemaFile.equals(that.createValuesSchemaFile) :that.createValuesSchemaFile != null) return false;
    if (createReadmeFile != null ? !createReadmeFile.equals(that.createReadmeFile) :that.createReadmeFile != null) return false;
    if (extension != null ? !extension.equals(that.extension) :that.extension != null) return false;
    if (tarFileClassifier != null ? !tarFileClassifier.equals(that.tarFileClassifier) :that.tarFileClassifier != null) return false;
    if (notes != null ? !notes.equals(that.notes) :that.notes != null) return false;
    if (inputFolder != null ? !inputFolder.equals(that.inputFolder) :that.inputFolder != null) return false;
    if (outputFolder != null ? !outputFolder.equals(that.outputFolder) :that.outputFolder != null) return false;
    if (values != null ? !values.equals(that.values) :that.values != null) return false;
    if (valuesSchema != null ? !valuesSchema.equals(that.valuesSchema) :that.valuesSchema != null) return false;
    if (expressions != null ? !expressions.equals(that.expressions) :that.expressions != null) return false;
    if (addIfStatements != null ? !addIfStatements.equals(that.addIfStatements) :that.addIfStatements != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(enabled,  name,  home,  sources,  version,  description,  keywords,  maintainers,  icon,  apiVersion,  condition,  tags,  appVersion,  deprecated,  annotations,  kubeVersion,  dependencies,  type,  valuesRootAlias,  valuesProfileSeparator,  createTarFile,  createValuesSchemaFile,  createReadmeFile,  extension,  tarFileClassifier,  notes,  inputFolder,  outputFolder,  values,  valuesSchema,  expressions,  addIfStatements,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (enabled != null) { sb.append("enabled:"); sb.append(enabled + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (home != null) { sb.append("home:"); sb.append(home + ","); }
    if (sources != null && !sources.isEmpty()) { sb.append("sources:"); sb.append(sources + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (maintainers != null && !maintainers.isEmpty()) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (condition != null) { sb.append("condition:"); sb.append(condition + ","); }
    if (tags != null) { sb.append("tags:"); sb.append(tags + ","); }
    if (appVersion != null) { sb.append("appVersion:"); sb.append(appVersion + ","); }
    if (deprecated != null) { sb.append("deprecated:"); sb.append(deprecated + ","); }
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (kubeVersion != null) { sb.append("kubeVersion:"); sb.append(kubeVersion + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (valuesRootAlias != null) { sb.append("valuesRootAlias:"); sb.append(valuesRootAlias + ","); }
    if (valuesProfileSeparator != null) { sb.append("valuesProfileSeparator:"); sb.append(valuesProfileSeparator + ","); }
    if (createTarFile != null) { sb.append("createTarFile:"); sb.append(createTarFile + ","); }
    if (createValuesSchemaFile != null) { sb.append("createValuesSchemaFile:"); sb.append(createValuesSchemaFile + ","); }
    if (createReadmeFile != null) { sb.append("createReadmeFile:"); sb.append(createReadmeFile + ","); }
    if (extension != null) { sb.append("extension:"); sb.append(extension + ","); }
    if (tarFileClassifier != null) { sb.append("tarFileClassifier:"); sb.append(tarFileClassifier + ","); }
    if (notes != null) { sb.append("notes:"); sb.append(notes + ","); }
    if (inputFolder != null) { sb.append("inputFolder:"); sb.append(inputFolder + ","); }
    if (outputFolder != null) { sb.append("outputFolder:"); sb.append(outputFolder + ","); }
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values + ","); }
    if (valuesSchema != null) { sb.append("valuesSchema:"); sb.append(valuesSchema + ","); }
    if (expressions != null && !expressions.isEmpty()) { sb.append("expressions:"); sb.append(expressions + ","); }
    if (addIfStatements != null && !addIfStatements.isEmpty()) { sb.append("addIfStatements:"); sb.append(addIfStatements); }
    sb.append("}");
    return sb.toString();
  }
  public A withEnabled() {
    return withEnabled(true);
  }
  public A withDeprecated() {
    return withDeprecated(true);
  }
  public A withCreateTarFile() {
    return withCreateTarFile(true);
  }
  public A withCreateValuesSchemaFile() {
    return withCreateValuesSchemaFile(true);
  }
  public A withCreateReadmeFile() {
    return withCreateReadmeFile(true);
  }
  class MaintainersNestedImpl<N> extends MaintainerFluentImpl<HelmChartConfigFluent.MaintainersNested<N>> implements HelmChartConfigFluent.MaintainersNested<N>,Nested<N>{
    MaintainersNestedImpl(Integer index,Maintainer item) {
      this.index = index;
      this.builder = new MaintainerBuilder(this, item);
    }
    MaintainersNestedImpl() {
      this.index = -1;
      this.builder = new MaintainerBuilder(this);
    }
    MaintainerBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  class AnnotationsNestedImpl<N> extends AnnotationFluentImpl<HelmChartConfigFluent.AnnotationsNested<N>> implements HelmChartConfigFluent.AnnotationsNested<N>,Nested<N>{
    AnnotationsNestedImpl(Integer index,Annotation item) {
      this.index = index;
      this.builder = new AnnotationBuilder(this, item);
    }
    AnnotationsNestedImpl() {
      this.index = -1;
      this.builder = new AnnotationBuilder(this);
    }
    AnnotationBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToAnnotations(index,builder.build());
    }
    public N endAnnotation() {
      return and();
    }
    
  }
  class DependenciesNestedImpl<N> extends HelmDependencyFluentImpl<HelmChartConfigFluent.DependenciesNested<N>> implements HelmChartConfigFluent.DependenciesNested<N>,Nested<N>{
    DependenciesNestedImpl(Integer index,HelmDependency item) {
      this.index = index;
      this.builder = new HelmDependencyBuilder(this, item);
    }
    DependenciesNestedImpl() {
      this.index = -1;
      this.builder = new HelmDependencyBuilder(this);
    }
    HelmDependencyBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToDependencies(index,builder.build());
    }
    public N endDependency() {
      return and();
    }
    
  }
  class ValuesNestedImpl<N> extends ValueReferenceFluentImpl<HelmChartConfigFluent.ValuesNested<N>> implements HelmChartConfigFluent.ValuesNested<N>,Nested<N>{
    ValuesNestedImpl(Integer index,ValueReference item) {
      this.index = index;
      this.builder = new ValueReferenceBuilder(this, item);
    }
    ValuesNestedImpl() {
      this.index = -1;
      this.builder = new ValueReferenceBuilder(this);
    }
    ValueReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToValues(index,builder.build());
    }
    public N endValue() {
      return and();
    }
    
  }
  class ValuesSchemaNestedImpl<N> extends ValuesSchemaFluentImpl<HelmChartConfigFluent.ValuesSchemaNested<N>> implements HelmChartConfigFluent.ValuesSchemaNested<N>,Nested<N>{
    ValuesSchemaNestedImpl(ValuesSchema item) {
      this.builder = new ValuesSchemaBuilder(this, item);
    }
    ValuesSchemaNestedImpl() {
      this.builder = new ValuesSchemaBuilder(this);
    }
    ValuesSchemaBuilder builder;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.withValuesSchema(builder.build());
    }
    public N endValuesSchema() {
      return and();
    }
    
  }
  class ExpressionsNestedImpl<N> extends HelmExpressionFluentImpl<HelmChartConfigFluent.ExpressionsNested<N>> implements HelmChartConfigFluent.ExpressionsNested<N>,Nested<N>{
    ExpressionsNestedImpl(Integer index,HelmExpression item) {
      this.index = index;
      this.builder = new HelmExpressionBuilder(this, item);
    }
    ExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new HelmExpressionBuilder(this);
    }
    HelmExpressionBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToExpressions(index,builder.build());
    }
    public N endExpression() {
      return and();
    }
    
  }
  class AddIfStatementsNestedImpl<N> extends AddIfStatementFluentImpl<HelmChartConfigFluent.AddIfStatementsNested<N>> implements HelmChartConfigFluent.AddIfStatementsNested<N>,Nested<N>{
    AddIfStatementsNestedImpl(Integer index,AddIfStatement item) {
      this.index = index;
      this.builder = new AddIfStatementBuilder(this, item);
    }
    AddIfStatementsNestedImpl() {
      this.index = -1;
      this.builder = new AddIfStatementBuilder(this);
    }
    AddIfStatementBuilder builder;
    Integer index;
    public N and() {
      return (N) HelmChartConfigFluentImpl.this.setToAddIfStatements(index,builder.build());
    }
    public N endAddIfStatement() {
      return and();
    }
    
  }
  
}