package io.dekorate.helm.adapter;

import java.util.stream.Collectors;
import io.dekorate.helm.config.ValuesSchema;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.HelmChartConfigBuilder;
import java.lang.String;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.Annotation;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.project.Project;
import io.dekorate.helm.config.ValuesSchemaProperty;
import io.dekorate.helm.config.AddIfStatement;
import io.dekorate.project.BuildInfo;
import io.dekorate.helm.annotation.HelmChart;
import java.lang.Object;
import java.util.List;
import io.dekorate.project.ScmInfo;
import java.lang.Boolean;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.ValueReference;

 /**
  * Generated
  */
public class HelmChartConfigAdapter{
  public static HelmChartConfig adapt(HelmChart instance) {
    return newBuilder(instance).build();
  }
  public static HelmChartConfigBuilder newBuilder(HelmChart instance) {
    return new HelmChartConfigBuilder(new HelmChartConfig(null,
            null,
            instance.enabled(),
            instance.name(),
            instance.home(),
            instance.sources(),
            instance.version(),
            instance.description(),
            instance.keywords(),
            Arrays.asList(instance.maintainers()).stream().map(i ->new Maintainer(i.name(),
            i.email(),
            i.url())).collect(Collectors.toList()).toArray(new Maintainer[0]),
            instance.icon(),
            instance.apiVersion(),
            instance.condition(),
            instance.tags(),
            instance.appVersion(),
            instance.deprecated(),
            Arrays.asList(instance.annotations()).stream().map(i ->new Annotation(i.key(),
            i.value())).collect(Collectors.toList()).toArray(new Annotation[0]),
            instance.kubeVersion(),
            Arrays.asList(instance.dependencies()).stream().map(i ->new HelmDependency(i.name(),
            i.version(),
            i.repository(),
            i.condition(),
            i.tags(),
            i.enabled(),
            i.alias())).collect(Collectors.toList()).toArray(new HelmDependency[0]),
            instance.type(),
            instance.valuesRootAlias(),
            instance.valuesProfileSeparator(),
            instance.createTarFile(),
            instance.createValuesSchemaFile(),
            instance.createReadmeFile(),
            instance.extension(),
            instance.tarFileClassifier(),
            instance.notes(),
            instance.inputFolder(),
            instance.outputFolder(),
            Arrays.asList(instance.values()).stream().map(i ->new ValueReference(i.property(),
            i.paths(),
            i.profile(),
            i.value(),
            i.expression(),
            i.description(),
            i.minimum(),
            i.maximum(),
            i.pattern(),
            i.required())).collect(Collectors.toList()).toArray(new ValueReference[0]),
            new ValuesSchema(instance.valuesSchema().title(),
            Arrays.asList(instance.valuesSchema().properties()).stream().map(i ->new ValuesSchemaProperty(i.name(),
            i.description(),
            i.type(),
            i.minimum(),
            i.maximum(),
            i.pattern(),
            i.required())).collect(Collectors.toList()).toArray(new ValuesSchemaProperty[0])),
            Arrays.asList(instance.expressions()).stream().map(i ->new HelmExpression(i.path(),
            i.expression())).collect(Collectors.toList()).toArray(new HelmExpression[0]),
            Arrays.asList(instance.addIfStatements()).stream().map(i ->new AddIfStatement(i.property(),
            i.onResourceKind(),
            i.onResourceName(),
            i.withDefaultValue(),
            i.description())).collect(Collectors.toList()).toArray(new AddIfStatement[0])));
  }
  public static HelmChartConfig adapt(Map map) {
    return new HelmChartConfig(
null,
null,
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new Maintainer(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new Maintainer[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("apiVersion", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("condition", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("tags", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("appVersion", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("deprecated", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new Annotation(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new Annotation[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("kubeVersion", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new HelmDependency(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("condition", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("tags")) : toStringArray(i),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("enabled", true) : true),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""))).toArray(size-> new HelmDependency[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("type", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesProfileSeparator", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createValuesSchemaFile", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createReadmeFile", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("tarFileClassifier", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("inputFolder", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("outputFolder", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new ValueReference(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", "") : ""),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("minimum", -2147483648) : -2147483648),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("maximum", 2147483647) : 2147483647),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("pattern", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("required", false) : false))).toArray(size-> new ValueReference[size]),
new ValuesSchema(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null))).getOrDefault("title", "Values") : "Values"),
                   Arrays.stream((Map[])(((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null))).getOrDefault("properties" , new Map[0]) : new Map[0])).map(i ->new ValuesSchemaProperty(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("type", "string") : "string"),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("minimum", -2147483648) : -2147483648),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("maximum", 2147483647) : 2147483647),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("pattern", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("required", false) : false))).toArray(size-> new ValuesSchemaProperty[size])),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("expressions" , new Map[0]) : new Map[0])).map(i ->new HelmExpression(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", null) : null))).toArray(size-> new HelmExpression[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("addIfStatements" , new Map[0]) : new Map[0])).map(i ->new AddIfStatement(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("onResourceKind", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("onResourceName", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("withDefaultValue", true) : true),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", "") : ""))).toArray(size-> new AddIfStatement[size]));
  }
  public static HelmChartConfigBuilder newBuilder(Map map) {
    return new HelmChartConfigBuilder(new HelmChartConfig(
null,
null,
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("enabled", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("home", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("sources")) : toStringArray(map),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("description", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("keywords")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("maintainers" , new Map[0]) : new Map[0])).map(i ->new Maintainer(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("email", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("url", null) : null))).toArray(size-> new Maintainer[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("icon", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("apiVersion", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("condition", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("tags", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("appVersion", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("deprecated", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new Annotation(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null))).toArray(size-> new Annotation[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("kubeVersion", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("dependencies" , new Map[0]) : new Map[0])).map(i ->new HelmDependency(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("version", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("condition", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("tags")) : toStringArray(i),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("enabled", true) : true),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("alias", "") : ""))).toArray(size-> new HelmDependency[size]),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("type", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesRootAlias", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("valuesProfileSeparator", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createTarFile", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createValuesSchemaFile", null) : null),
               (Boolean)(map instanceof Map ? ((Map)map).getOrDefault("createReadmeFile", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("extension", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("tarFileClassifier", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("notes", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("inputFolder", null) : null),
               (String)(map instanceof Map ? ((Map)map).getOrDefault("outputFolder", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("values" , new Map[0]) : new Map[0])).map(i ->new ValueReference(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("paths")) : toStringArray(i),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("profile", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", "") : ""),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("minimum", -2147483648) : -2147483648),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("maximum", 2147483647) : 2147483647),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("pattern", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("required", false) : false))).toArray(size-> new ValueReference[size]),
new ValuesSchema(
                   (String)(((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null))).getOrDefault("title", "Values") : "Values"),
                   Arrays.stream((Map[])(((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("valuesSchema") : null))).getOrDefault("properties" , new Map[0]) : new Map[0])).map(i ->new ValuesSchemaProperty(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("type", "string") : "string"),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("minimum", -2147483648) : -2147483648),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("maximum", 2147483647) : 2147483647),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("pattern", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("required", false) : false))).toArray(size-> new ValuesSchemaProperty[size])),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("expressions" , new Map[0]) : new Map[0])).map(i ->new HelmExpression(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("expression", null) : null))).toArray(size-> new HelmExpression[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("addIfStatements" , new Map[0]) : new Map[0])).map(i ->new AddIfStatement(
               (String)(i instanceof Map ? ((Map)i).getOrDefault("property", null) : null),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("onResourceKind", "") : ""),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("onResourceName", "") : ""),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("withDefaultValue", true) : true),
               (String)(i instanceof Map ? ((Map)i).getOrDefault("description", "") : ""))).toArray(size-> new AddIfStatement[size])));
  }
  public static String[] toStringArray(Object o) {
            if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

  }
  
}