package io.dekorate.helm.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class ValueReference{
  public ValueReference() {
  }
  public ValueReference(String property,String[] paths,String profile,String value,String expression,String description,Integer minimum,Integer maximum,String pattern,Boolean required) {
    this.property = property;
    this.paths = paths != null ? paths : new String[0];
    this.profile = profile;
    this.value = value;
    this.expression = expression;
    this.description = description;
    this.minimum = minimum;
    this.maximum = maximum;
    this.pattern = pattern;
    this.required = required;
  }
  private String property;
  private String[] paths;
  private String profile;
  private String value;
  private String expression;
  private String description;
  private Integer minimum;
  private Integer maximum;
  private String pattern;
  private Boolean required;
  public String getProperty() {
    return this.property;
  }
  
  /**
   * The path expressions where to map the property.
   */
public String[] getPaths() {
    return this.paths;
  }
  public String getProfile() {
    return this.profile;
  }
  public String getValue() {
    return this.value;
  }
  
  /**
   * If not provided, it will use `{{ .Values.<root alias>.<property> }}`.
   * @return The complete Helm expression to be replaced with.
   */
public String getExpression() {
    return this.expression;
  }
  public String getDescription() {
    return this.description;
  }
  public Integer getMinimum() {
    return this.minimum;
  }
  public Integer getMaximum() {
    return this.maximum;
  }
  public String getPattern() {
    return this.pattern;
  }
  public Boolean getRequired() {
    return this.required;
  }
  public boolean isRequired() {
    return this.required != null &&  this.required;
  }
  public static ValueReferenceBuilder newBuilder() {
    return new ValueReferenceBuilder();
  }
  public static ValueReferenceBuilder newBuilderFromDefaults() {
    return new ValueReferenceBuilder().withMinimum(-2147483648).withMaximum(2147483647).withRequired(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ValueReference that = (ValueReference) o;
    if (property != null ? !property.equals(that.property) :that.property != null) return false;
    if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
    if (profile != null ? !profile.equals(that.profile) :that.profile != null) return false;
    if (value != null ? !value.equals(that.value) :that.value != null) return false;
    if (expression != null ? !expression.equals(that.expression) :that.expression != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (minimum != null ? !minimum.equals(that.minimum) :that.minimum != null) return false;
    if (maximum != null ? !maximum.equals(that.maximum) :that.maximum != null) return false;
    if (pattern != null ? !pattern.equals(that.pattern) :that.pattern != null) return false;
    if (required != null ? !required.equals(that.required) :that.required != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(property,  paths,  profile,  value,  expression,  description,  minimum,  maximum,  pattern,  required,  super.hashCode());
  }
  
}