package io.dekorate.helm.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class HelmChartConfigBuilder extends HelmChartConfigFluentImpl<HelmChartConfigBuilder> implements VisitableBuilder<HelmChartConfig,HelmChartConfigBuilder>{
  public HelmChartConfigBuilder() {
    this(false);
  }
  public HelmChartConfigBuilder(Boolean validationEnabled) {
    this(new HelmChartConfig(), validationEnabled);
  }
  public HelmChartConfigBuilder(HelmChartConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartConfigBuilder(HelmChartConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmChartConfig(), validationEnabled);
  }
  public HelmChartConfigBuilder(HelmChartConfigFluent<?> fluent,HelmChartConfig instance) {
    this(fluent, instance, false);
  }
  public HelmChartConfigBuilder(HelmChartConfigFluent<?> fluent,HelmChartConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withProject(instance.getProject()); 
    fluent.withAttributes(instance.getAttributes()); 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withName(instance.getName()); 
    fluent.withHome(instance.getHome()); 
    fluent.withSources(instance.getSources()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withKeywords(instance.getKeywords()); 
    fluent.withMaintainers(instance.getMaintainers()); 
    fluent.withIcon(instance.getIcon()); 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withCondition(instance.getCondition()); 
    fluent.withTags(instance.getTags()); 
    fluent.withAppVersion(instance.getAppVersion()); 
    fluent.withDeprecated(instance.getDeprecated()); 
    fluent.withAnnotations(instance.getAnnotations()); 
    fluent.withKubeVersion(instance.getKubeVersion()); 
    fluent.withDependencies(instance.getDependencies()); 
    fluent.withType(instance.getType()); 
    fluent.withValuesRootAlias(instance.getValuesRootAlias()); 
    fluent.withCreateTarFile(instance.getCreateTarFile()); 
    fluent.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile()); 
    fluent.withCreateReadmeFile(instance.getCreateReadmeFile()); 
    fluent.withExtension(instance.getExtension()); 
    fluent.withTarFileClassifier(instance.getTarFileClassifier()); 
    fluent.withNotes(instance.getNotes()); 
    fluent.withInputFolder(instance.getInputFolder()); 
    fluent.withOutputFolder(instance.getOutputFolder()); 
    fluent.withValues(instance.getValues()); 
    fluent.withValuesSchema(instance.getValuesSchema()); 
    fluent.withExpressions(instance.getExpressions()); 
    fluent.withAddIfStatements(instance.getAddIfStatements()); 
    this.validationEnabled = validationEnabled; 
  }
  public HelmChartConfigBuilder(HelmChartConfig instance) {
    this(instance,false);
  }
  public HelmChartConfigBuilder(HelmChartConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withEnabled(instance.getEnabled()); 
    this.withName(instance.getName()); 
    this.withHome(instance.getHome()); 
    this.withSources(instance.getSources()); 
    this.withVersion(instance.getVersion()); 
    this.withDescription(instance.getDescription()); 
    this.withKeywords(instance.getKeywords()); 
    this.withMaintainers(instance.getMaintainers()); 
    this.withIcon(instance.getIcon()); 
    this.withApiVersion(instance.getApiVersion()); 
    this.withCondition(instance.getCondition()); 
    this.withTags(instance.getTags()); 
    this.withAppVersion(instance.getAppVersion()); 
    this.withDeprecated(instance.getDeprecated()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withKubeVersion(instance.getKubeVersion()); 
    this.withDependencies(instance.getDependencies()); 
    this.withType(instance.getType()); 
    this.withValuesRootAlias(instance.getValuesRootAlias()); 
    this.withCreateTarFile(instance.getCreateTarFile()); 
    this.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile()); 
    this.withCreateReadmeFile(instance.getCreateReadmeFile()); 
    this.withExtension(instance.getExtension()); 
    this.withTarFileClassifier(instance.getTarFileClassifier()); 
    this.withNotes(instance.getNotes()); 
    this.withInputFolder(instance.getInputFolder()); 
    this.withOutputFolder(instance.getOutputFolder()); 
    this.withValues(instance.getValues()); 
    this.withValuesSchema(instance.getValuesSchema()); 
    this.withExpressions(instance.getExpressions()); 
    this.withAddIfStatements(instance.getAddIfStatements()); 
    this.validationEnabled = validationEnabled; 
  }
  HelmChartConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EditableHelmChartConfig build() {
    EditableHelmChartConfig buildable = new EditableHelmChartConfig(fluent.getProject(),fluent.getAttributes(),fluent.getEnabled(),fluent.getName(),fluent.getHome(),fluent.getSources(),fluent.getVersion(),fluent.getDescription(),fluent.getKeywords(),fluent.getMaintainers(),fluent.getIcon(),fluent.getApiVersion(),fluent.getCondition(),fluent.getTags(),fluent.getAppVersion(),fluent.getDeprecated(),fluent.getAnnotations(),fluent.getKubeVersion(),fluent.getDependencies(),fluent.getType(),fluent.getValuesRootAlias(),fluent.getCreateTarFile(),fluent.getCreateValuesSchemaFile(),fluent.getCreateReadmeFile(),fluent.getExtension(),fluent.getTarFileClassifier(),fluent.getNotes(),fluent.getInputFolder(),fluent.getOutputFolder(),fluent.getValues(),fluent.getValuesSchema(),fluent.getExpressions(),fluent.getAddIfStatements());
    return buildable;
  }
  
}