/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.HelmDependencyFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class HelmDependencyFluentImpl<A extends HelmDependencyFluent<A>>
extends BaseFluent<A>
implements HelmDependencyFluent<A> {
    private String name;
    private String version;
    private String repository;
    private String condition;
    private List<String> tags = new ArrayList<String>();
    private Boolean enabled;
    private String alias;

    public HelmDependencyFluentImpl() {
    }

    public HelmDependencyFluentImpl(HelmDependency instance) {
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withRepository(instance.getRepository());
        this.withCondition(instance.getCondition());
        this.withTags(instance.getTags());
        this.withEnabled(instance.getEnabled());
        this.withAlias(instance.getAlias());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getRepository() {
        return this.repository;
    }

    @Override
    public A withRepository(String repository) {
        this.repository = repository;
        return (A)this;
    }

    @Override
    public Boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public A withCondition(String condition) {
        this.condition = condition;
        return (A)this;
    }

    @Override
    public Boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getTags() {
        int size = this.tags != null ? this.tags.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.tags) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToTags(Integer index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTags(Integer index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String ... items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<String> items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)this;
    }

    @Override
    public Boolean hasEnabled() {
        return this.enabled != null;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public A withAlias(String alias) {
        this.alias = alias;
        return (A)this;
    }

    @Override
    public Boolean hasAlias() {
        return this.alias != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelmDependencyFluentImpl that = (HelmDependencyFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        return !(this.alias != null ? !this.alias.equals(that.alias) : that.alias != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.repository, this.condition, this.tags, this.enabled, this.alias, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append(this.repository + ",");
        }
        if (this.condition != null) {
            sb.append("condition:");
            sb.append(this.condition + ",");
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.alias != null) {
            sb.append("alias:");
            sb.append(this.alias);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withEnabled() {
        return this.withEnabled(true);
    }
}

