/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.config;

import io.dekorate.helm.config.AddIfStatement;
import io.dekorate.helm.config.AddIfStatementBuilder;
import io.dekorate.helm.config.AddIfStatementFluentImpl;
import io.dekorate.helm.config.Annotation;
import io.dekorate.helm.config.AnnotationBuilder;
import io.dekorate.helm.config.AnnotationFluentImpl;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmChartConfigFluent;
import io.dekorate.helm.config.HelmDependency;
import io.dekorate.helm.config.HelmDependencyBuilder;
import io.dekorate.helm.config.HelmDependencyFluentImpl;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.HelmExpressionBuilder;
import io.dekorate.helm.config.HelmExpressionFluentImpl;
import io.dekorate.helm.config.Maintainer;
import io.dekorate.helm.config.MaintainerBuilder;
import io.dekorate.helm.config.MaintainerFluentImpl;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.config.ValueReferenceBuilder;
import io.dekorate.helm.config.ValueReferenceFluentImpl;
import io.dekorate.helm.config.ValuesSchema;
import io.dekorate.helm.config.ValuesSchemaBuilder;
import io.dekorate.helm.config.ValuesSchemaFluentImpl;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HelmChartConfigFluentImpl<A extends HelmChartConfigFluent<A>>
extends ConfigurationFluentImpl<A>
implements HelmChartConfigFluent<A> {
    private Boolean enabled;
    private String name;
    private String home;
    private List<String> sources = new ArrayList<String>();
    private String version;
    private String description;
    private List<String> keywords = new ArrayList<String>();
    private ArrayList<MaintainerBuilder> maintainers = new ArrayList();
    private String icon;
    private String apiVersion;
    private String condition;
    private String tags;
    private String appVersion;
    private Boolean deprecated;
    private ArrayList<AnnotationBuilder> annotations = new ArrayList();
    private String kubeVersion;
    private ArrayList<HelmDependencyBuilder> dependencies = new ArrayList();
    private String type;
    private String valuesRootAlias;
    private Boolean createTarFile;
    private Boolean createValuesSchemaFile;
    private Boolean createReadmeFile;
    private String extension;
    private String tarFileClassifier;
    private String notes;
    private String inputFolder;
    private String outputFolder;
    private ArrayList<ValueReferenceBuilder> values = new ArrayList();
    private ValuesSchemaBuilder valuesSchema;
    private ArrayList<HelmExpressionBuilder> expressions = new ArrayList();
    private ArrayList<AddIfStatementBuilder> addIfStatements = new ArrayList();

    public HelmChartConfigFluentImpl() {
    }

    public HelmChartConfigFluentImpl(HelmChartConfig instance) {
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withEnabled(instance.getEnabled());
        this.withName(instance.getName());
        this.withHome(instance.getHome());
        this.withSources(instance.getSources());
        this.withVersion(instance.getVersion());
        this.withDescription(instance.getDescription());
        this.withKeywords(instance.getKeywords());
        this.withMaintainers(instance.getMaintainers());
        this.withIcon(instance.getIcon());
        this.withApiVersion(instance.getApiVersion());
        this.withCondition(instance.getCondition());
        this.withTags(instance.getTags());
        this.withAppVersion(instance.getAppVersion());
        this.withDeprecated(instance.getDeprecated());
        this.withAnnotations(instance.getAnnotations());
        this.withKubeVersion(instance.getKubeVersion());
        this.withDependencies(instance.getDependencies());
        this.withType(instance.getType());
        this.withValuesRootAlias(instance.getValuesRootAlias());
        this.withCreateTarFile(instance.getCreateTarFile());
        this.withCreateValuesSchemaFile(instance.getCreateValuesSchemaFile());
        this.withCreateReadmeFile(instance.getCreateReadmeFile());
        this.withExtension(instance.getExtension());
        this.withTarFileClassifier(instance.getTarFileClassifier());
        this.withNotes(instance.getNotes());
        this.withInputFolder(instance.getInputFolder());
        this.withOutputFolder(instance.getOutputFolder());
        this.withValues(instance.getValues());
        this.withValuesSchema(instance.getValuesSchema());
        this.withExpressions(instance.getExpressions());
        this.withAddIfStatements(instance.getAddIfStatements());
    }

    @Override
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)this;
    }

    @Override
    public Boolean hasEnabled() {
        return this.enabled != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getHome() {
        return this.home;
    }

    @Override
    public A withHome(String home) {
        this.home = home;
        return (A)this;
    }

    @Override
    public Boolean hasHome() {
        return this.home != null;
    }

    @Override
    public A withSources(String ... sources) {
        if (this.sources != null) {
            this.sources.clear();
        }
        if (sources != null) {
            for (String item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getSources() {
        int size = this.sources != null ? this.sources.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.sources) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToSources(Integer index, String item) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSources(Integer index, String item) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSources(String ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        for (String item : items) {
            this.sources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSources(Collection<String> items) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        for (String item : items) {
            this.sources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSources(String ... items) {
        for (String item : items) {
            if (this.sources == null) continue;
            this.sources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSources(Collection<String> items) {
        for (String item : items) {
            if (this.sources == null) continue;
            this.sources.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    public A withKeywords(String ... keywords) {
        if (this.keywords != null) {
            this.keywords.clear();
        }
        if (keywords != null) {
            for (String item : keywords) {
                this.addToKeywords(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getKeywords() {
        int size = this.keywords != null ? this.keywords.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.keywords) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToKeywords(Integer index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(index, item);
        return (A)this;
    }

    @Override
    public A setToKeywords(Integer index, String item) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.set(index, item);
        return (A)this;
    }

    @Override
    public A addToKeywords(String ... items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToKeywords(Collection<String> items) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        for (String item : items) {
            this.keywords.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromKeywords(String ... items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromKeywords(Collection<String> items) {
        for (String item : items) {
            if (this.keywords == null) continue;
            this.keywords.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKeywords() {
        return this.keywords != null && !this.keywords.isEmpty();
    }

    @Override
    public A withMaintainers(Maintainer ... maintainers) {
        if (this.maintainers != null) {
            this.maintainers.clear();
        }
        if (maintainers != null) {
            for (Maintainer item : maintainers) {
                this.addToMaintainers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Maintainer[] getMaintainers() {
        int size = this.maintainers != null ? this.maintainers.size() : 0;
        Maintainer[] result = new Maintainer[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.maintainers) {
            result[index++] = (Maintainer)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Maintainer[] buildMaintainers() {
        int size = this.maintainers != null ? this.maintainers.size() : 0;
        Maintainer[] result = new Maintainer[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.maintainers) {
            result[index++] = (Maintainer)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Maintainer buildMaintainer(Integer index) {
        return this.maintainers.get(index).build();
    }

    @Override
    public Maintainer buildFirstMaintainer() {
        return this.maintainers.get(0).build();
    }

    @Override
    public Maintainer buildLastMaintainer() {
        return this.maintainers.get(this.maintainers.size() - 1).build();
    }

    @Override
    public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        for (MaintainerBuilder item : this.maintainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToMaintainers(Integer index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        this._visitables.get((Object)"maintainers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"maintainers").size(), builder);
        this.maintainers.add(index >= 0 ? index.intValue() : this.maintainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMaintainers(Integer index, Maintainer item) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        MaintainerBuilder builder = new MaintainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"maintainers").size()) {
            this._visitables.get((Object)"maintainers").add(builder);
        } else {
            this._visitables.get((Object)"maintainers").set(index, builder);
        }
        if (index < 0 || index >= this.maintainers.size()) {
            this.maintainers.add(builder);
        } else {
            this.maintainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMaintainers(Maintainer ... items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMaintainers(Collection<Maintainer> items) {
        if (this.maintainers == null) {
            this.maintainers = new ArrayList();
        }
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").add(builder);
            this.maintainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMaintainers(Maintainer ... items) {
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMaintainers(Collection<Maintainer> items) {
        for (Maintainer item : items) {
            MaintainerBuilder builder = new MaintainerBuilder(item);
            this._visitables.get((Object)"maintainers").remove(builder);
            if (this.maintainers == null) continue;
            this.maintainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
        if (this.maintainers == null) {
            return (A)this;
        }
        Iterator<MaintainerBuilder> each = this.maintainers.iterator();
        List visitables = this._visitables.get((Object)"maintainers");
        while (each.hasNext()) {
            MaintainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasMaintainers() {
        return this.maintainers != null && !this.maintainers.isEmpty();
    }

    @Override
    public A addNewMaintainer(String name, String email, String url) {
        return this.addToMaintainers(new Maintainer(name, email, url));
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainer() {
        return new MaintainersNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
        return new MaintainersNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> setNewMaintainerLike(Integer index, Maintainer item) {
        return new MaintainersNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> editMaintainer(Integer index) {
        if (this.maintainers.size() <= index) {
            throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> editFirstMaintainer() {
        if (this.maintainers.size() == 0) {
            throw new RuntimeException("Can't edit first maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(0, this.buildMaintainer(0));
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> editLastMaintainer() {
        int index = this.maintainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last maintainers. The list is empty.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public HelmChartConfigFluent.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.maintainers.size(); ++i) {
            if (!predicate.test(this.maintainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching maintainers. No match found.");
        }
        return this.setNewMaintainerLike(index, this.buildMaintainer(index));
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public A withIcon(String icon) {
        this.icon = icon;
        return (A)this;
    }

    @Override
    public Boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public A withCondition(String condition) {
        this.condition = condition;
        return (A)this;
    }

    @Override
    public Boolean hasCondition() {
        return this.condition != null;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    @Override
    public A withTags(String tags) {
        this.tags = tags;
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null;
    }

    @Override
    public String getAppVersion() {
        return this.appVersion;
    }

    @Override
    public A withAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return (A)this;
    }

    @Override
    public Boolean hasAppVersion() {
        return this.appVersion != null;
    }

    @Override
    public Boolean getDeprecated() {
        return this.deprecated;
    }

    @Override
    public A withDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return (A)this;
    }

    @Override
    public Boolean hasDeprecated() {
        return this.deprecated != null;
    }

    @Override
    public A withAnnotations(Annotation ... annotations) {
        if (this.annotations != null) {
            this.annotations.clear();
        }
        if (annotations != null) {
            for (Annotation item : annotations) {
                this.addToAnnotations(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Annotation[] getAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation[] buildAnnotations() {
        int size = this.annotations != null ? this.annotations.size() : 0;
        Annotation[] result = new Annotation[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.annotations) {
            result[index++] = (Annotation)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Annotation buildAnnotation(Integer index) {
        return this.annotations.get(index).build();
    }

    @Override
    public Annotation buildFirstAnnotation() {
        return this.annotations.get(0).build();
    }

    @Override
    public Annotation buildLastAnnotation() {
        return this.annotations.get(this.annotations.size() - 1).build();
    }

    @Override
    public Annotation buildMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        for (AnnotationBuilder item : this.annotations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        this._visitables.get((Object)"annotations").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"annotations").size(), builder);
        this.annotations.add(index >= 0 ? index.intValue() : this.annotations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAnnotations(Integer index, Annotation item) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        AnnotationBuilder builder = new AnnotationBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"annotations").size()) {
            this._visitables.get((Object)"annotations").add(builder);
        } else {
            this._visitables.get((Object)"annotations").set(index, builder);
        }
        if (index < 0 || index >= this.annotations.size()) {
            this.annotations.add(builder);
        } else {
            this.annotations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Annotation ... items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAnnotations(Collection<Annotation> items) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").add(builder);
            this.annotations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Annotation ... items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAnnotations(Collection<Annotation> items) {
        for (Annotation item : items) {
            AnnotationBuilder builder = new AnnotationBuilder(item);
            this._visitables.get((Object)"annotations").remove(builder);
            if (this.annotations == null) continue;
            this.annotations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAnnotations(Predicate<AnnotationBuilder> predicate) {
        if (this.annotations == null) {
            return (A)this;
        }
        Iterator<AnnotationBuilder> each = this.annotations.iterator();
        List visitables = this._visitables.get((Object)"annotations");
        while (each.hasNext()) {
            AnnotationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null && !this.annotations.isEmpty();
    }

    @Override
    public A addNewAnnotation(String key, String value) {
        return this.addToAnnotations(new Annotation(key, value));
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotation() {
        return new AnnotationsNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> addNewAnnotationLike(Annotation item) {
        return new AnnotationsNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> setNewAnnotationLike(Integer index, Annotation item) {
        return new AnnotationsNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> editAnnotation(Integer index) {
        if (this.annotations.size() <= index) {
            throw new RuntimeException("Can't edit annotations. Index exceeds size.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> editFirstAnnotation() {
        if (this.annotations.size() == 0) {
            throw new RuntimeException("Can't edit first annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(0, this.buildAnnotation(0));
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> editLastAnnotation() {
        int index = this.annotations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last annotations. The list is empty.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public HelmChartConfigFluent.AnnotationsNested<A> editMatchingAnnotation(Predicate<AnnotationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.annotations.size(); ++i) {
            if (!predicate.test(this.annotations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching annotations. No match found.");
        }
        return this.setNewAnnotationLike(index, this.buildAnnotation(index));
    }

    @Override
    public String getKubeVersion() {
        return this.kubeVersion;
    }

    @Override
    public A withKubeVersion(String kubeVersion) {
        this.kubeVersion = kubeVersion;
        return (A)this;
    }

    @Override
    public Boolean hasKubeVersion() {
        return this.kubeVersion != null;
    }

    @Override
    public A withDependencies(HelmDependency ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
        }
        if (dependencies != null) {
            for (HelmDependency item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public HelmDependency[] getDependencies() {
        int size = this.dependencies != null ? this.dependencies.size() : 0;
        HelmDependency[] result = new HelmDependency[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.dependencies) {
            result[index++] = (HelmDependency)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HelmDependency[] buildDependencies() {
        int size = this.dependencies != null ? this.dependencies.size() : 0;
        HelmDependency[] result = new HelmDependency[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.dependencies) {
            result[index++] = (HelmDependency)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HelmDependency buildDependency(Integer index) {
        return this.dependencies.get(index).build();
    }

    @Override
    public HelmDependency buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    @Override
    public HelmDependency buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    @Override
    public HelmDependency buildMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        for (HelmDependencyBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        for (HelmDependencyBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToDependencies(Integer index, HelmDependency item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
        this._visitables.get((Object)"dependencies").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"dependencies").size(), builder);
        this.dependencies.add(index >= 0 ? index.intValue() : this.dependencies.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDependencies(Integer index, HelmDependency item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"dependencies").size()) {
            this._visitables.get((Object)"dependencies").add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
        }
        if (index < 0 || index >= this.dependencies.size()) {
            this.dependencies.add(builder);
        } else {
            this.dependencies.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDependencies(HelmDependency ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDependencies(Collection<HelmDependency> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDependencies(HelmDependency ... items) {
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDependencies(Collection<HelmDependency> items) {
        for (HelmDependency item : items) {
            HelmDependencyBuilder builder = new HelmDependencyBuilder(item);
            this._visitables.get((Object)"dependencies").remove(builder);
            if (this.dependencies == null) continue;
            this.dependencies.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDependencies(Predicate<HelmDependencyBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)this;
        }
        Iterator<HelmDependencyBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            HelmDependencyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> addNewDependency() {
        return new DependenciesNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> addNewDependencyLike(HelmDependency item) {
        return new DependenciesNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> setNewDependencyLike(Integer index, HelmDependency item) {
        return new DependenciesNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> editDependency(Integer index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public HelmChartConfigFluent.DependenciesNested<A> editMatchingDependency(Predicate<HelmDependencyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public String getValuesRootAlias() {
        return this.valuesRootAlias;
    }

    @Override
    public A withValuesRootAlias(String valuesRootAlias) {
        this.valuesRootAlias = valuesRootAlias;
        return (A)this;
    }

    @Override
    public Boolean hasValuesRootAlias() {
        return this.valuesRootAlias != null;
    }

    @Override
    public Boolean getCreateTarFile() {
        return this.createTarFile;
    }

    @Override
    public A withCreateTarFile(Boolean createTarFile) {
        this.createTarFile = createTarFile;
        return (A)this;
    }

    @Override
    public Boolean hasCreateTarFile() {
        return this.createTarFile != null;
    }

    @Override
    public Boolean getCreateValuesSchemaFile() {
        return this.createValuesSchemaFile;
    }

    @Override
    public A withCreateValuesSchemaFile(Boolean createValuesSchemaFile) {
        this.createValuesSchemaFile = createValuesSchemaFile;
        return (A)this;
    }

    @Override
    public Boolean hasCreateValuesSchemaFile() {
        return this.createValuesSchemaFile != null;
    }

    @Override
    public Boolean getCreateReadmeFile() {
        return this.createReadmeFile;
    }

    @Override
    public A withCreateReadmeFile(Boolean createReadmeFile) {
        this.createReadmeFile = createReadmeFile;
        return (A)this;
    }

    @Override
    public Boolean hasCreateReadmeFile() {
        return this.createReadmeFile != null;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public A withExtension(String extension) {
        this.extension = extension;
        return (A)this;
    }

    @Override
    public Boolean hasExtension() {
        return this.extension != null;
    }

    @Override
    public String getTarFileClassifier() {
        return this.tarFileClassifier;
    }

    @Override
    public A withTarFileClassifier(String tarFileClassifier) {
        this.tarFileClassifier = tarFileClassifier;
        return (A)this;
    }

    @Override
    public Boolean hasTarFileClassifier() {
        return this.tarFileClassifier != null;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public A withNotes(String notes) {
        this.notes = notes;
        return (A)this;
    }

    @Override
    public Boolean hasNotes() {
        return this.notes != null;
    }

    @Override
    public String getInputFolder() {
        return this.inputFolder;
    }

    @Override
    public A withInputFolder(String inputFolder) {
        this.inputFolder = inputFolder;
        return (A)this;
    }

    @Override
    public Boolean hasInputFolder() {
        return this.inputFolder != null;
    }

    @Override
    public String getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    public A withOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
        return (A)this;
    }

    @Override
    public Boolean hasOutputFolder() {
        return this.outputFolder != null;
    }

    @Override
    public A withValues(ValueReference ... values) {
        if (this.values != null) {
            this.values.clear();
        }
        if (values != null) {
            for (ValueReference item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public ValueReference[] getValues() {
        int size = this.values != null ? this.values.size() : 0;
        ValueReference[] result = new ValueReference[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.values) {
            result[index++] = (ValueReference)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ValueReference[] buildValues() {
        int size = this.values != null ? this.values.size() : 0;
        ValueReference[] result = new ValueReference[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.values) {
            result[index++] = (ValueReference)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ValueReference buildValue(Integer index) {
        return this.values.get(index).build();
    }

    @Override
    public ValueReference buildFirstValue() {
        return this.values.get(0).build();
    }

    @Override
    public ValueReference buildLastValue() {
        return this.values.get(this.values.size() - 1).build();
    }

    @Override
    public ValueReference buildMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        for (ValueReferenceBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        for (ValueReferenceBuilder item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToValues(Integer index, ValueReference item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
        this._visitables.get((Object)"values").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"values").size(), builder);
        this.values.add(index >= 0 ? index.intValue() : this.values.size(), builder);
        return (A)this;
    }

    @Override
    public A setToValues(Integer index, ValueReference item) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"values").size()) {
            this._visitables.get((Object)"values").add(builder);
        } else {
            this._visitables.get((Object)"values").set(index, builder);
        }
        if (index < 0 || index >= this.values.size()) {
            this.values.add(builder);
        } else {
            this.values.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToValues(ValueReference ... items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<ValueReference> items) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").add(builder);
            this.values.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(ValueReference ... items) {
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").remove(builder);
            if (this.values == null) continue;
            this.values.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<ValueReference> items) {
        for (ValueReference item : items) {
            ValueReferenceBuilder builder = new ValueReferenceBuilder(item);
            this._visitables.get((Object)"values").remove(builder);
            if (this.values == null) continue;
            this.values.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromValues(Predicate<ValueReferenceBuilder> predicate) {
        if (this.values == null) {
            return (A)this;
        }
        Iterator<ValueReferenceBuilder> each = this.values.iterator();
        List visitables = this._visitables.get((Object)"values");
        while (each.hasNext()) {
            ValueReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> addNewValue() {
        return new ValuesNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> addNewValueLike(ValueReference item) {
        return new ValuesNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> setNewValueLike(Integer index, ValueReference item) {
        return new ValuesNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> editValue(Integer index) {
        if (this.values.size() <= index) {
            throw new RuntimeException("Can't edit values. Index exceeds size.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> editFirstValue() {
        if (this.values.size() == 0) {
            throw new RuntimeException("Can't edit first values. The list is empty.");
        }
        return this.setNewValueLike(0, this.buildValue(0));
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> editLastValue() {
        int index = this.values.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last values. The list is empty.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    @Override
    public HelmChartConfigFluent.ValuesNested<A> editMatchingValue(Predicate<ValueReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.values.size(); ++i) {
            if (!predicate.test(this.values.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching values. No match found.");
        }
        return this.setNewValueLike(index, this.buildValue(index));
    }

    @Override
    @Deprecated
    public ValuesSchema getValuesSchema() {
        return this.valuesSchema != null ? this.valuesSchema.build() : null;
    }

    @Override
    public ValuesSchema buildValuesSchema() {
        return this.valuesSchema != null ? this.valuesSchema.build() : null;
    }

    @Override
    public A withValuesSchema(ValuesSchema valuesSchema) {
        this._visitables.get((Object)"valuesSchema").remove(this.valuesSchema);
        if (valuesSchema != null) {
            this.valuesSchema = new ValuesSchemaBuilder(valuesSchema);
            this._visitables.get((Object)"valuesSchema").add(this.valuesSchema);
        } else {
            this.valuesSchema = null;
            this._visitables.get((Object)"valuesSchema").remove(this.valuesSchema);
        }
        return (A)this;
    }

    @Override
    public Boolean hasValuesSchema() {
        return this.valuesSchema != null;
    }

    @Override
    public HelmChartConfigFluent.ValuesSchemaNested<A> withNewValuesSchema() {
        return new ValuesSchemaNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.ValuesSchemaNested<A> withNewValuesSchemaLike(ValuesSchema item) {
        return new ValuesSchemaNestedImpl(item);
    }

    @Override
    public HelmChartConfigFluent.ValuesSchemaNested<A> editValuesSchema() {
        return this.withNewValuesSchemaLike(this.getValuesSchema());
    }

    @Override
    public HelmChartConfigFluent.ValuesSchemaNested<A> editOrNewValuesSchema() {
        return this.withNewValuesSchemaLike(this.getValuesSchema() != null ? this.getValuesSchema() : new ValuesSchemaBuilder().build());
    }

    @Override
    public HelmChartConfigFluent.ValuesSchemaNested<A> editOrNewValuesSchemaLike(ValuesSchema item) {
        return this.withNewValuesSchemaLike(this.getValuesSchema() != null ? this.getValuesSchema() : item);
    }

    @Override
    public A withExpressions(HelmExpression ... expressions) {
        if (this.expressions != null) {
            this.expressions.clear();
        }
        if (expressions != null) {
            for (HelmExpression item : expressions) {
                this.addToExpressions(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public HelmExpression[] getExpressions() {
        int size = this.expressions != null ? this.expressions.size() : 0;
        HelmExpression[] result = new HelmExpression[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.expressions) {
            result[index++] = (HelmExpression)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HelmExpression[] buildExpressions() {
        int size = this.expressions != null ? this.expressions.size() : 0;
        HelmExpression[] result = new HelmExpression[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.expressions) {
            result[index++] = (HelmExpression)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public HelmExpression buildExpression(Integer index) {
        return this.expressions.get(index).build();
    }

    @Override
    public HelmExpression buildFirstExpression() {
        return this.expressions.get(0).build();
    }

    @Override
    public HelmExpression buildLastExpression() {
        return this.expressions.get(this.expressions.size() - 1).build();
    }

    @Override
    public HelmExpression buildMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        for (HelmExpressionBuilder item : this.expressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        for (HelmExpressionBuilder item : this.expressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToExpressions(Integer index, HelmExpression item) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
        this._visitables.get((Object)"expressions").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"expressions").size(), builder);
        this.expressions.add(index >= 0 ? index.intValue() : this.expressions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExpressions(Integer index, HelmExpression item) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"expressions").size()) {
            this._visitables.get((Object)"expressions").add(builder);
        } else {
            this._visitables.get((Object)"expressions").set(index, builder);
        }
        if (index < 0 || index >= this.expressions.size()) {
            this.expressions.add(builder);
        } else {
            this.expressions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExpressions(HelmExpression ... items) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExpressions(Collection<HelmExpression> items) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").add(builder);
            this.expressions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExpressions(HelmExpression ... items) {
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").remove(builder);
            if (this.expressions == null) continue;
            this.expressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExpressions(Collection<HelmExpression> items) {
        for (HelmExpression item : items) {
            HelmExpressionBuilder builder = new HelmExpressionBuilder(item);
            this._visitables.get((Object)"expressions").remove(builder);
            if (this.expressions == null) continue;
            this.expressions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExpressions(Predicate<HelmExpressionBuilder> predicate) {
        if (this.expressions == null) {
            return (A)this;
        }
        Iterator<HelmExpressionBuilder> each = this.expressions.iterator();
        List visitables = this._visitables.get((Object)"expressions");
        while (each.hasNext()) {
            HelmExpressionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasExpressions() {
        return this.expressions != null && !this.expressions.isEmpty();
    }

    @Override
    public A addNewExpression(String path, String expression) {
        return this.addToExpressions(new HelmExpression(path, expression));
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> addNewExpression() {
        return new ExpressionsNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> addNewExpressionLike(HelmExpression item) {
        return new ExpressionsNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> setNewExpressionLike(Integer index, HelmExpression item) {
        return new ExpressionsNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> editExpression(Integer index) {
        if (this.expressions.size() <= index) {
            throw new RuntimeException("Can't edit expressions. Index exceeds size.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> editFirstExpression() {
        if (this.expressions.size() == 0) {
            throw new RuntimeException("Can't edit first expressions. The list is empty.");
        }
        return this.setNewExpressionLike(0, this.buildExpression(0));
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> editLastExpression() {
        int index = this.expressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last expressions. The list is empty.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    @Override
    public HelmChartConfigFluent.ExpressionsNested<A> editMatchingExpression(Predicate<HelmExpressionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.expressions.size(); ++i) {
            if (!predicate.test(this.expressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching expressions. No match found.");
        }
        return this.setNewExpressionLike(index, this.buildExpression(index));
    }

    @Override
    public A withAddIfStatements(AddIfStatement ... addIfStatements) {
        if (this.addIfStatements != null) {
            this.addIfStatements.clear();
        }
        if (addIfStatements != null) {
            for (AddIfStatement item : addIfStatements) {
                this.addToAddIfStatements(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AddIfStatement[] getAddIfStatements() {
        int size = this.addIfStatements != null ? this.addIfStatements.size() : 0;
        AddIfStatement[] result = new AddIfStatement[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.addIfStatements) {
            result[index++] = (AddIfStatement)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AddIfStatement[] buildAddIfStatements() {
        int size = this.addIfStatements != null ? this.addIfStatements.size() : 0;
        AddIfStatement[] result = new AddIfStatement[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.addIfStatements) {
            result[index++] = (AddIfStatement)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AddIfStatement buildAddIfStatement(Integer index) {
        return this.addIfStatements.get(index).build();
    }

    @Override
    public AddIfStatement buildFirstAddIfStatement() {
        return this.addIfStatements.get(0).build();
    }

    @Override
    public AddIfStatement buildLastAddIfStatement() {
        return this.addIfStatements.get(this.addIfStatements.size() - 1).build();
    }

    @Override
    public AddIfStatement buildMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        for (AddIfStatementBuilder item : this.addIfStatements) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        for (AddIfStatementBuilder item : this.addIfStatements) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAddIfStatements(Integer index, AddIfStatement item) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
        this._visitables.get((Object)"addIfStatements").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"addIfStatements").size(), builder);
        this.addIfStatements.add(index >= 0 ? index.intValue() : this.addIfStatements.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddIfStatements(Integer index, AddIfStatement item) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"addIfStatements").size()) {
            this._visitables.get((Object)"addIfStatements").add(builder);
        } else {
            this._visitables.get((Object)"addIfStatements").set(index, builder);
        }
        if (index < 0 || index >= this.addIfStatements.size()) {
            this.addIfStatements.add(builder);
        } else {
            this.addIfStatements.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddIfStatements(AddIfStatement ... items) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddIfStatements(Collection<AddIfStatement> items) {
        if (this.addIfStatements == null) {
            this.addIfStatements = new ArrayList();
        }
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").add(builder);
            this.addIfStatements.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddIfStatements(AddIfStatement ... items) {
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").remove(builder);
            if (this.addIfStatements == null) continue;
            this.addIfStatements.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddIfStatements(Collection<AddIfStatement> items) {
        for (AddIfStatement item : items) {
            AddIfStatementBuilder builder = new AddIfStatementBuilder(item);
            this._visitables.get((Object)"addIfStatements").remove(builder);
            if (this.addIfStatements == null) continue;
            this.addIfStatements.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddIfStatements(Predicate<AddIfStatementBuilder> predicate) {
        if (this.addIfStatements == null) {
            return (A)this;
        }
        Iterator<AddIfStatementBuilder> each = this.addIfStatements.iterator();
        List visitables = this._visitables.get((Object)"addIfStatements");
        while (each.hasNext()) {
            AddIfStatementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddIfStatements() {
        return this.addIfStatements != null && !this.addIfStatements.isEmpty();
    }

    @Override
    public A addNewAddIfStatement(String property, String onResourceKind, String onResourceName, Boolean withDefaultValue, String description) {
        return this.addToAddIfStatements(new AddIfStatement(property, onResourceKind, onResourceName, withDefaultValue, description));
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatement() {
        return new AddIfStatementsNestedImpl();
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> addNewAddIfStatementLike(AddIfStatement item) {
        return new AddIfStatementsNestedImpl(-1, item);
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> setNewAddIfStatementLike(Integer index, AddIfStatement item) {
        return new AddIfStatementsNestedImpl(index, item);
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> editAddIfStatement(Integer index) {
        if (this.addIfStatements.size() <= index) {
            throw new RuntimeException("Can't edit addIfStatements. Index exceeds size.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> editFirstAddIfStatement() {
        if (this.addIfStatements.size() == 0) {
            throw new RuntimeException("Can't edit first addIfStatements. The list is empty.");
        }
        return this.setNewAddIfStatementLike(0, this.buildAddIfStatement(0));
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> editLastAddIfStatement() {
        int index = this.addIfStatements.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addIfStatements. The list is empty.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    @Override
    public HelmChartConfigFluent.AddIfStatementsNested<A> editMatchingAddIfStatement(Predicate<AddIfStatementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addIfStatements.size(); ++i) {
            if (!predicate.test(this.addIfStatements.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addIfStatements. No match found.");
        }
        return this.setNewAddIfStatementLike(index, this.buildAddIfStatement(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HelmChartConfigFluentImpl that = (HelmChartConfigFluentImpl)o;
        if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.home != null ? !this.home.equals(that.home) : that.home != null) {
            return false;
        }
        if (this.sources != null ? !this.sources.equals(that.sources) : that.sources != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.keywords != null ? !this.keywords.equals(that.keywords) : that.keywords != null) {
            return false;
        }
        if (this.maintainers != null ? !this.maintainers.equals(that.maintainers) : that.maintainers != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.appVersion != null ? !this.appVersion.equals(that.appVersion) : that.appVersion != null) {
            return false;
        }
        if (this.deprecated != null ? !this.deprecated.equals(that.deprecated) : that.deprecated != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.kubeVersion != null ? !this.kubeVersion.equals(that.kubeVersion) : that.kubeVersion != null) {
            return false;
        }
        if (this.dependencies != null ? !this.dependencies.equals(that.dependencies) : that.dependencies != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.valuesRootAlias != null ? !this.valuesRootAlias.equals(that.valuesRootAlias) : that.valuesRootAlias != null) {
            return false;
        }
        if (this.createTarFile != null ? !this.createTarFile.equals(that.createTarFile) : that.createTarFile != null) {
            return false;
        }
        if (this.createValuesSchemaFile != null ? !this.createValuesSchemaFile.equals(that.createValuesSchemaFile) : that.createValuesSchemaFile != null) {
            return false;
        }
        if (this.createReadmeFile != null ? !this.createReadmeFile.equals(that.createReadmeFile) : that.createReadmeFile != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        if (this.tarFileClassifier != null ? !this.tarFileClassifier.equals(that.tarFileClassifier) : that.tarFileClassifier != null) {
            return false;
        }
        if (this.notes != null ? !this.notes.equals(that.notes) : that.notes != null) {
            return false;
        }
        if (this.inputFolder != null ? !this.inputFolder.equals(that.inputFolder) : that.inputFolder != null) {
            return false;
        }
        if (this.outputFolder != null ? !this.outputFolder.equals(that.outputFolder) : that.outputFolder != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (this.valuesSchema != null ? !this.valuesSchema.equals(that.valuesSchema) : that.valuesSchema != null) {
            return false;
        }
        if (this.expressions != null ? !this.expressions.equals(that.expressions) : that.expressions != null) {
            return false;
        }
        return !(this.addIfStatements != null ? !this.addIfStatements.equals(that.addIfStatements) : that.addIfStatements != null);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.name, this.home, this.sources, this.version, this.description, this.keywords, this.maintainers, this.icon, this.apiVersion, this.condition, this.tags, this.appVersion, this.deprecated, this.annotations, this.kubeVersion, this.dependencies, this.type, this.valuesRootAlias, this.createTarFile, this.createValuesSchemaFile, this.createReadmeFile, this.extension, this.tarFileClassifier, this.notes, this.inputFolder, this.outputFolder, this.values, this.valuesSchema, this.expressions, this.addIfStatements, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.home != null) {
            sb.append("home:");
            sb.append(this.home + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.keywords != null && !this.keywords.isEmpty()) {
            sb.append("keywords:");
            sb.append(this.keywords + ",");
        }
        if (this.maintainers != null && !this.maintainers.isEmpty()) {
            sb.append("maintainers:");
            sb.append(this.maintainers + ",");
        }
        if (this.icon != null) {
            sb.append("icon:");
            sb.append(this.icon + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.condition != null) {
            sb.append("condition:");
            sb.append(this.condition + ",");
        }
        if (this.tags != null) {
            sb.append("tags:");
            sb.append(this.tags + ",");
        }
        if (this.appVersion != null) {
            sb.append("appVersion:");
            sb.append(this.appVersion + ",");
        }
        if (this.deprecated != null) {
            sb.append("deprecated:");
            sb.append(this.deprecated + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.kubeVersion != null) {
            sb.append("kubeVersion:");
            sb.append(this.kubeVersion + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.valuesRootAlias != null) {
            sb.append("valuesRootAlias:");
            sb.append(this.valuesRootAlias + ",");
        }
        if (this.createTarFile != null) {
            sb.append("createTarFile:");
            sb.append(this.createTarFile + ",");
        }
        if (this.createValuesSchemaFile != null) {
            sb.append("createValuesSchemaFile:");
            sb.append(this.createValuesSchemaFile + ",");
        }
        if (this.createReadmeFile != null) {
            sb.append("createReadmeFile:");
            sb.append(this.createReadmeFile + ",");
        }
        if (this.extension != null) {
            sb.append("extension:");
            sb.append(this.extension + ",");
        }
        if (this.tarFileClassifier != null) {
            sb.append("tarFileClassifier:");
            sb.append(this.tarFileClassifier + ",");
        }
        if (this.notes != null) {
            sb.append("notes:");
            sb.append(this.notes + ",");
        }
        if (this.inputFolder != null) {
            sb.append("inputFolder:");
            sb.append(this.inputFolder + ",");
        }
        if (this.outputFolder != null) {
            sb.append("outputFolder:");
            sb.append(this.outputFolder + ",");
        }
        if (this.values != null && !this.values.isEmpty()) {
            sb.append("values:");
            sb.append(this.values + ",");
        }
        if (this.valuesSchema != null) {
            sb.append("valuesSchema:");
            sb.append(this.valuesSchema + ",");
        }
        if (this.expressions != null && !this.expressions.isEmpty()) {
            sb.append("expressions:");
            sb.append(this.expressions + ",");
        }
        if (this.addIfStatements != null && !this.addIfStatements.isEmpty()) {
            sb.append("addIfStatements:");
            sb.append(this.addIfStatements);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withEnabled() {
        return this.withEnabled(true);
    }

    @Override
    public A withDeprecated() {
        return this.withDeprecated(true);
    }

    @Override
    public A withCreateTarFile() {
        return this.withCreateTarFile(true);
    }

    @Override
    public A withCreateValuesSchemaFile() {
        return this.withCreateValuesSchemaFile(true);
    }

    @Override
    public A withCreateReadmeFile() {
        return this.withCreateReadmeFile(true);
    }

    class AddIfStatementsNestedImpl<N>
    extends AddIfStatementFluentImpl<HelmChartConfigFluent.AddIfStatementsNested<N>>
    implements HelmChartConfigFluent.AddIfStatementsNested<N>,
    Nested<N> {
        AddIfStatementBuilder builder;
        Integer index;

        AddIfStatementsNestedImpl(Integer index, AddIfStatement item) {
            this.index = index;
            this.builder = new AddIfStatementBuilder(this, item);
        }

        AddIfStatementsNestedImpl() {
            this.index = -1;
            this.builder = new AddIfStatementBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToAddIfStatements(this.index, this.builder.build());
        }

        @Override
        public N endAddIfStatement() {
            return this.and();
        }
    }

    class ExpressionsNestedImpl<N>
    extends HelmExpressionFluentImpl<HelmChartConfigFluent.ExpressionsNested<N>>
    implements HelmChartConfigFluent.ExpressionsNested<N>,
    Nested<N> {
        HelmExpressionBuilder builder;
        Integer index;

        ExpressionsNestedImpl(Integer index, HelmExpression item) {
            this.index = index;
            this.builder = new HelmExpressionBuilder(this, item);
        }

        ExpressionsNestedImpl() {
            this.index = -1;
            this.builder = new HelmExpressionBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToExpressions(this.index, this.builder.build());
        }

        @Override
        public N endExpression() {
            return this.and();
        }
    }

    class ValuesSchemaNestedImpl<N>
    extends ValuesSchemaFluentImpl<HelmChartConfigFluent.ValuesSchemaNested<N>>
    implements HelmChartConfigFluent.ValuesSchemaNested<N>,
    Nested<N> {
        ValuesSchemaBuilder builder;

        ValuesSchemaNestedImpl(ValuesSchema item) {
            this.builder = new ValuesSchemaBuilder(this, item);
        }

        ValuesSchemaNestedImpl() {
            this.builder = new ValuesSchemaBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.withValuesSchema(this.builder.build());
        }

        @Override
        public N endValuesSchema() {
            return this.and();
        }
    }

    class ValuesNestedImpl<N>
    extends ValueReferenceFluentImpl<HelmChartConfigFluent.ValuesNested<N>>
    implements HelmChartConfigFluent.ValuesNested<N>,
    Nested<N> {
        ValueReferenceBuilder builder;
        Integer index;

        ValuesNestedImpl(Integer index, ValueReference item) {
            this.index = index;
            this.builder = new ValueReferenceBuilder(this, item);
        }

        ValuesNestedImpl() {
            this.index = -1;
            this.builder = new ValueReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToValues(this.index, this.builder.build());
        }

        @Override
        public N endValue() {
            return this.and();
        }
    }

    class DependenciesNestedImpl<N>
    extends HelmDependencyFluentImpl<HelmChartConfigFluent.DependenciesNested<N>>
    implements HelmChartConfigFluent.DependenciesNested<N>,
    Nested<N> {
        HelmDependencyBuilder builder;
        Integer index;

        DependenciesNestedImpl(Integer index, HelmDependency item) {
            this.index = index;
            this.builder = new HelmDependencyBuilder(this, item);
        }

        DependenciesNestedImpl() {
            this.index = -1;
            this.builder = new HelmDependencyBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToDependencies(this.index, this.builder.build());
        }

        @Override
        public N endDependency() {
            return this.and();
        }
    }

    class AnnotationsNestedImpl<N>
    extends AnnotationFluentImpl<HelmChartConfigFluent.AnnotationsNested<N>>
    implements HelmChartConfigFluent.AnnotationsNested<N>,
    Nested<N> {
        AnnotationBuilder builder;
        Integer index;

        AnnotationsNestedImpl(Integer index, Annotation item) {
            this.index = index;
            this.builder = new AnnotationBuilder(this, item);
        }

        AnnotationsNestedImpl() {
            this.index = -1;
            this.builder = new AnnotationBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToAnnotations(this.index, this.builder.build());
        }

        @Override
        public N endAnnotation() {
            return this.and();
        }
    }

    class MaintainersNestedImpl<N>
    extends MaintainerFluentImpl<HelmChartConfigFluent.MaintainersNested<N>>
    implements HelmChartConfigFluent.MaintainersNested<N>,
    Nested<N> {
        MaintainerBuilder builder;
        Integer index;

        MaintainersNestedImpl(Integer index, Maintainer item) {
            this.index = index;
            this.builder = new MaintainerBuilder(this, item);
        }

        MaintainersNestedImpl() {
            this.index = -1;
            this.builder = new MaintainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)HelmChartConfigFluentImpl.this.setToMaintainers(this.index, this.builder.build());
        }

        @Override
        public N endMaintainer() {
            return this.and();
        }
    }
}

