/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.util;

import com.fasterxml.jackson.core.type.TypeReference;
import io.dekorate.ConfigReference;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.ValuesSchemaProperty;
import io.dekorate.helm.model.ValuesSchema;
import io.dekorate.helm.util.HelmConfigUtils;
import io.dekorate.helm.util.HelmValueHolder;
import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public final class ValuesSchemaUtils {
    private ValuesSchemaUtils() {
    }

    public static Map<String, Object> createSchema(HelmChartConfig helmConfig, Map<String, HelmValueHolder> prodValues) {
        io.dekorate.helm.model.ValuesSchemaProperty property;
        ValuesSchema schema = new ValuesSchema();
        schema.setTitle(helmConfig.getValuesSchema().getTitle());
        for (Map.Entry<String, HelmValueHolder> value : prodValues.entrySet()) {
            ConfigReference configReference = value.getValue().configReference;
            String[] tree = HelmConfigUtils.deductProperty(helmConfig, value.getKey()).split(Pattern.quote("."));
            io.dekorate.helm.model.ValuesSchemaProperty parent = null;
            Map<String, io.dekorate.helm.model.ValuesSchemaProperty> location = schema.getProperties();
            for (int index = 0; index < tree.length - 1; ++index) {
                String part = tree[index];
                io.dekorate.helm.model.ValuesSchemaProperty next = location.get(part);
                if (next == null) {
                    next = new io.dekorate.helm.model.ValuesSchemaProperty();
                    next.setType("object");
                    location.put(part, next);
                }
                parent = next;
                location = next.getProperties();
            }
            String propertyName = tree[tree.length - 1];
            Object propertyValue = value.getValue().value;
            property = location.getOrDefault(propertyName, new io.dekorate.helm.model.ValuesSchemaProperty());
            property.setDescription(configReference.getDescription());
            property.setPattern(configReference.getPattern());
            property.setEnumValues(configReference.getEnumValues());
            property.setMaximum(configReference.getMaximum());
            property.setMinimum(configReference.getMinimum());
            if (configReference.isRequired()) {
                if (parent == null) {
                    schema.getRequired().add(propertyName);
                } else {
                    parent.getRequired().add(propertyName);
                }
            }
            if (propertyValue == null) {
                property.setType("null");
            } else if (propertyValue instanceof Integer) {
                property.setType("integer");
            } else if (propertyValue instanceof Number) {
                property.setType("number");
            } else if (propertyValue instanceof Collection) {
                property.setType("array");
            } else if (propertyValue instanceof Boolean) {
                property.setType("boolean");
            } else {
                property.setType("string");
            }
            location.put(propertyName, property);
        }
        for (ValuesSchemaProperty propertyFromConfig : helmConfig.getValuesSchema().getProperties()) {
            String[] tree = HelmConfigUtils.deductProperty(helmConfig, propertyFromConfig.getName()).split(Pattern.quote("."));
            io.dekorate.helm.model.ValuesSchemaProperty parent = null;
            Map<String, io.dekorate.helm.model.ValuesSchemaProperty> location = schema.getProperties();
            for (int index = 0; index < tree.length - 1; ++index) {
                String part = tree[index];
                io.dekorate.helm.model.ValuesSchemaProperty next = location.get(part);
                if (next == null) {
                    next = new io.dekorate.helm.model.ValuesSchemaProperty();
                    next.setType("object");
                    location.put(part, next);
                }
                parent = next;
                location = next.getProperties();
            }
            String propertyName = tree[tree.length - 1];
            property = location.getOrDefault(propertyName, new io.dekorate.helm.model.ValuesSchemaProperty());
            if (Strings.isNotNullOrEmpty((String)propertyFromConfig.getDescription())) {
                property.setDescription(propertyFromConfig.getDescription());
            }
            if (Strings.isNotNullOrEmpty((String)propertyFromConfig.getPattern())) {
                property.setPattern(propertyFromConfig.getPattern());
            }
            if (propertyFromConfig.getMaximum() != Integer.MAX_VALUE) {
                property.setMaximum(propertyFromConfig.getMaximum());
            }
            if (propertyFromConfig.getMinimum() != Integer.MIN_VALUE) {
                property.setMinimum(propertyFromConfig.getMinimum());
            }
            if (propertyFromConfig.isRequired()) {
                if (parent == null) {
                    schema.getRequired().add(propertyName);
                } else {
                    parent.getRequired().add(propertyName);
                }
            }
            if (Strings.isNotNullOrEmpty((String)propertyFromConfig.getType())) {
                property.setType(propertyFromConfig.getType());
            }
            location.put(propertyName, property);
        }
        return (Map)Serialization.unmarshal((String)Serialization.asJson((Object)schema), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

