/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import io.dekorate.ConfigReference;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.helm.config.AddIfStatement;
import io.dekorate.helm.config.Annotation;
import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.config.HelmExpression;
import io.dekorate.helm.config.ValueReference;
import io.dekorate.helm.model.Chart;
import io.dekorate.helm.model.HelmDependency;
import io.dekorate.helm.model.Maintainer;
import io.dekorate.helm.util.HelmConfigUtils;
import io.dekorate.helm.util.HelmTarArchiver;
import io.dekorate.helm.util.HelmValueHolder;
import io.dekorate.helm.util.MapUtils;
import io.dekorate.helm.util.ReadmeBuilder;
import io.dekorate.helm.util.ValuesSchemaUtils;
import io.dekorate.project.Project;
import io.dekorate.utils.Exec;
import io.dekorate.utils.Maps;
import io.dekorate.utils.Serialization;
import io.dekorate.utils.Strings;
import io.github.yamlpath.YamlExpressionParser;
import io.github.yamlpath.YamlPath;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HelmWriterSessionListener
implements SessionListener,
WithProject,
WithSession {
    private static final String YAML = ".yaml";
    private static final String YAML_REG_EXP = ".*?\\.ya?ml$";
    private static final String CHART_FILENAME = "Chart.yaml";
    private static final String VALUES = "values";
    private static final String TEMPLATES = "templates";
    private static final String CHARTS = "charts";
    private static final String NOTES = "NOTES.txt";
    private static final String VALUES_SCHEMA = "values.schema.json";
    private static final String README = "README.md";
    private static final List<String> ADDITIONAL_CHART_FILES = Arrays.asList("LICENSE", "app-readme.md", "questions.yml", "questions.yaml", "requirements.yml", "requirements.yaml", "crds");
    private static final String KIND = "kind";
    private static final String METADATA = "metadata";
    private static final String NAME = "name";
    private static final String START_TAG = "{{";
    private static final String END_TAG = "}}";
    private static final String VALUES_START_TAG = "{{ .Values.";
    private static final String VALUES_END_TAG = " }}";
    private static final String EMPTY = "";
    private static final String IF_STATEMENT_START_TAG = "{{- if .Values.%s }}";
    private static final String TEMPLATE_FUNCTION_START_TAG = "{{- define";
    private static final String TEMPLATE_FUNCTION_END_TAG = "{{- end }}";
    private static final String HELM_HELPER_PREFIX = "_";
    private static final boolean APPEND = true;
    private static final String SEPARATOR_TOKEN = ":LINE_SEPARATOR:";
    private static final String SEPARATOR_QUOTES = ":DOUBLE_QUOTES";
    private static final String START_EXPRESSION_TOKEN = ":START:";
    private static final String END_EXPRESSION_TOKEN = ":END:";
    private static final Logger LOGGER = LoggerFactory.getLogger();

    public void onClosed() {
        Session session = this.getSession();
        Project project = this.getProject();
        Path outputDir = project.getBuildInfo().getClassOutputDir().resolve(project.getDekorateOutputDir());
        session.getConfigurationRegistry().get(HelmChartConfig.class).ifPresent(helmConfig -> {
            Path baseDir = this.getProject().getBuildInfo().getResourceDir();
            if (this.getProject().getDekorateInputDir() != null) {
                baseDir = baseDir.resolve(this.getProject().getDekorateInputDir());
            }
            Path inputDir = baseDir.resolve(helmConfig.getInputFolder());
            List<ConfigReference> configReferences = Stream.of(helmConfig.getValues()).map(this::toConfigReference).collect(Collectors.toList());
            this.writeHelmFiles(session, project, (HelmChartConfig)((Object)helmConfig), configReferences, inputDir, outputDir.resolve(helmConfig.getOutputFolder()), (Collection<File>)HelmWriterSessionListener.listYamls(outputDir));
        });
    }

    public Map<String, String> writeHelmFiles(Session session, Project project, HelmChartConfig helmConfig, List<ConfigReference> configReferences, Path inputDir, Path outputDir, Collection<File> generatedFiles) {
        HashMap<String, String> artifacts = new HashMap<String, String>();
        if (helmConfig.isEnabled()) {
            this.validateHelmConfig(helmConfig);
            List<ConfigReference> valuesReferences = this.mergeValuesReferencesFromDecorators(helmConfig, configReferences, session);
            try {
                LOGGER.info(String.format("Creating Helm Chart \"%s\"", helmConfig.getName()));
                HashMap<String, HelmValueHolder> prodValues = new HashMap<String, HelmValueHolder>();
                HashMap<String, Map<String, HelmValueHolder>> valuesByProfile = new HashMap<String, Map<String, HelmValueHolder>>();
                artifacts.putAll(this.processTemplates(helmConfig, inputDir, outputDir, generatedFiles, valuesReferences, prodValues, valuesByProfile));
                artifacts.putAll(this.createChartYaml(helmConfig, project, inputDir, outputDir));
                artifacts.putAll(this.createValuesYaml(helmConfig, valuesReferences, inputDir, outputDir, prodValues, valuesByProfile));
                artifacts.putAll(this.createEmptyChartFolder(helmConfig, outputDir));
                artifacts.putAll(this.addNotesIntoTemplatesFolder(helmConfig, inputDir, outputDir));
                artifacts.putAll(this.addAdditionalResources(helmConfig, inputDir, outputDir));
                if (helmConfig.isCreateTarFile()) {
                    this.fetchDependencies(helmConfig, outputDir);
                    artifacts.putAll(this.createTarball(helmConfig, project, outputDir, artifacts));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error writing resources", e);
            }
        }
        return artifacts;
    }

    private Map<String, String> addAdditionalResources(HelmChartConfig helmConfig, Path inputDir, Path outputDir) throws IOException {
        if (inputDir == null || !inputDir.toFile().exists()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (File source : inputDir.toFile().listFiles()) {
            if (!ADDITIONAL_CHART_FILES.stream().anyMatch(source.getName()::equalsIgnoreCase)) continue;
            artifacts.putAll(this.addAdditionalResource(helmConfig, outputDir, source));
        }
        return artifacts;
    }

    private Map<String, String> addAdditionalResource(HelmChartConfig helmConfig, Path outputDir, File source) throws IOException {
        if (!source.exists()) {
            return Collections.emptyMap();
        }
        Path destination = this.getChartOutputDir(helmConfig, outputDir).resolve(source.getName());
        if (source.isDirectory()) {
            Files.createDirectory(destination, new FileAttribute[0]);
            for (File file : source.listFiles()) {
                Files.copy(new FileInputStream(file), destination.resolve(file.getName()), new CopyOption[0]);
            }
        } else {
            Files.copy(new FileInputStream(source), destination, new CopyOption[0]);
        }
        return Collections.singletonMap(destination.toString(), EMPTY);
    }

    private void fetchDependencies(HelmChartConfig helmConfig, Path outputDir) {
        if (helmConfig.getDependencies() != null && helmConfig.getDependencies().length > 0) {
            Path chartFolder = this.getChartOutputDir(helmConfig, outputDir);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            boolean success = Exec.inPath((Path)chartFolder).redirectingOutput((OutputStream)out).commands(new String[]{"helm", "dependency", "build"});
            if (success) {
                LOGGER.info("Dependencies successfully fetched");
            } else {
                throw new RuntimeException("Error fetching Helm dependencies. Cause: " + new String(out.toByteArray()));
            }
        }
    }

    private void validateHelmConfig(HelmChartConfig helmConfig) {
        if (Strings.isNullOrEmpty((String)helmConfig.getName())) {
            throw new RuntimeException("Helm Chart name is required!");
        }
    }

    private Map<String, String> addNotesIntoTemplatesFolder(HelmChartConfig helmConfig, Path inputDir, Path outputDir) throws IOException {
        InputStream notesInputStream;
        File notesInInputDir = inputDir.resolve(NOTES).toFile();
        if (notesInInputDir.exists()) {
            notesInputStream = new FileInputStream(notesInInputDir);
        } else {
            if (Strings.isNullOrEmpty((String)helmConfig.getNotes())) {
                return Collections.emptyMap();
            }
            notesInputStream = this.getResourceFromClasspath(helmConfig.getNotes());
        }
        if (notesInputStream == null) {
            throw new RuntimeException("Could not find the notes template file in the classpath at " + helmConfig.getNotes());
        }
        Path chartOutputDir = this.getChartOutputDir(helmConfig, outputDir).resolve(TEMPLATES).resolve(NOTES);
        Files.copy(notesInputStream, chartOutputDir, new CopyOption[0]);
        return Collections.singletonMap(chartOutputDir.toString(), EMPTY);
    }

    private InputStream getResourceFromClasspath(String notes) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(notes);
        if (is == null) {
            is = HelmWriterSessionListener.class.getResourceAsStream(notes);
        }
        return is;
    }

    private Map<String, String> createEmptyChartFolder(HelmChartConfig helmConfig, Path outputDir) throws IOException {
        Path emptyChartsDir = this.getChartOutputDir(helmConfig, outputDir).resolve(CHARTS);
        Files.createDirectories(emptyChartsDir, new FileAttribute[0]);
        return Collections.singletonMap(emptyChartsDir.toString(), EMPTY);
    }

    private List<ConfigReference> mergeValuesReferencesFromDecorators(HelmChartConfig helmConfig, List<ConfigReference> configReferencesFromConfig, Session session) {
        LinkedList<ConfigReference> configReferences = new LinkedList<ConfigReference>();
        configReferences.addAll(configReferencesFromConfig);
        for (AddIfStatement addIfStatement : helmConfig.getAddIfStatements()) {
            configReferences.add(new ConfigReference.Builder(HelmConfigUtils.deductProperty(helmConfig, addIfStatement.getProperty()), new String[0]).withDescription(addIfStatement.getDescription()).withValue((Object)addIfStatement.getWithDefaultValue()).build());
        }
        List configReferencesFromDecorators = session.getResourceRegistry().getConfigReferences().stream().flatMap(decorator -> decorator.getConfigReferences().stream()).collect(Collectors.toList());
        Collections.reverse(configReferencesFromDecorators);
        configReferences.addAll(configReferencesFromDecorators);
        return configReferences;
    }

    private boolean valueHasPath(ConfigReference valueReference) {
        return valueReference.getPaths() != null && valueReference.getPaths().length > 0;
    }

    private ConfigReference toConfigReference(ValueReference valueReference) {
        return new ConfigReference.Builder(valueReference.getProperty(), valueReference.getPaths()).withValue((Object)(Strings.isNullOrEmpty((String)valueReference.getValue()) ? null : valueReference.getValue())).withDescription(valueReference.getDescription()).withExpression(valueReference.getExpression()).withProfile(valueReference.getProfile()).withMinimum(valueReference.getMinimum().intValue()).withMaximum(valueReference.getMaximum().intValue()).withPattern(valueReference.getPattern()).withRequired(valueReference.isRequired()).build();
    }

    private Map<String, String> createValuesYaml(HelmChartConfig helmConfig, List<ConfigReference> configReferences, Path inputDir, Path outputDir, Map<String, HelmValueHolder> prodValues, Map<String, Map<String, HelmValueHolder>> valuesByProfile) throws IOException {
        for (ConfigReference configReference : configReferences) {
            if (this.valueHasPath(configReference)) continue;
            if (configReference.getValue() == null) {
                throw new RuntimeException("The value mapping for " + configReference.getProperty() + " does not have either a path or a default value. ");
            }
            this.getValues(prodValues, valuesByProfile, configReference).put(HelmConfigUtils.deductProperty(helmConfig, configReference.getProperty()), new HelmValueHolder(configReference.getValue(), configReference));
        }
        HashMap<String, String> artifacts = new HashMap<String, String>();
        for (Map.Entry<String, Map<String, HelmValueHolder>> entry : valuesByProfile.entrySet()) {
            String profile = entry.getKey();
            Map<String, HelmValueHolder> values = entry.getValue();
            for (Map.Entry<String, HelmValueHolder> prodValue : prodValues.entrySet()) {
                if (values.containsKey(prodValue.getKey())) continue;
                values.put(prodValue.getKey(), prodValue.getValue());
            }
            artifacts.putAll(this.writeFileAsYaml(this.mergeWithFileIfExists(inputDir, "values.yaml", this.toValuesMap(values)), this.getChartOutputDir(helmConfig, outputDir).resolve("values." + profile + YAML)));
        }
        artifacts.putAll(this.writeFileAsYaml(this.mergeWithFileIfExists(inputDir, "values.yaml", this.toValuesMap(prodValues)), this.getChartOutputDir(helmConfig, outputDir).resolve("values.yaml")));
        if (helmConfig.isCreateValuesSchemaFile()) {
            Map<String, Object> map = ValuesSchemaUtils.createSchema(helmConfig, prodValues);
            artifacts.putAll(this.writeFileAsJson(this.mergeWithFileIfExists(inputDir, VALUES_SCHEMA, MapUtils.toMultiValueSortedMap(map)), this.getChartOutputDir(helmConfig, outputDir).resolve(VALUES_SCHEMA)));
        } else {
            artifacts.putAll(this.addAdditionalResource(helmConfig, outputDir, inputDir.resolve(VALUES_SCHEMA).toFile()));
        }
        if (helmConfig.isCreateReadmeFile()) {
            String string = ReadmeBuilder.build(helmConfig, prodValues);
            artifacts.putAll(this.writeFile(string, this.getChartOutputDir(helmConfig, outputDir).resolve(README)));
        } else {
            artifacts.putAll(this.addAdditionalResource(helmConfig, outputDir, inputDir.resolve(README).toFile()));
        }
        return artifacts;
    }

    private Map<String, Object> toValuesMap(Map<String, HelmValueHolder> holder) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, HelmValueHolder> value : holder.entrySet()) {
            values.put(value.getKey(), value.getValue().value);
        }
        return MapUtils.toMultiValueSortedMap(values);
    }

    private Map<String, Object> mergeWithFileIfExists(Path inputDir, String file, Map<String, Object> values) {
        File templateValuesFile = inputDir.resolve(file).toFile();
        if (templateValuesFile.exists()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map yaml = (Map)Serialization.unmarshal((File)templateValuesFile, (TypeReference)new TypeReference<Map<String, Object>>(){});
            result.putAll(yaml);
            Maps.merge(values, result);
            Maps.merge(result, values);
            return result;
        }
        return values;
    }

    private Map<String, String> createTarball(HelmChartConfig helmConfig, Project project, Path outputDir, Map<String, String> artifacts) throws IOException {
        File tarballFile = outputDir.resolve(String.format("%s-%s%s.%s", helmConfig.getName(), this.getVersion(helmConfig, project), Strings.isNullOrEmpty((String)helmConfig.getTarFileClassifier()) ? EMPTY : "-" + helmConfig.getTarFileClassifier(), helmConfig.getExtension())).toFile();
        LOGGER.debug(String.format("Creating Helm configuration Tarball: '%s'", tarballFile));
        Path helmSources = this.getChartOutputDir(helmConfig, outputDir);
        ArrayList<File> files = new ArrayList<File>();
        for (String filePath : artifacts.keySet()) {
            File file = new File(filePath);
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            files.add(file);
        }
        HelmTarArchiver.createTarBall(tarballFile, helmSources.toFile(), files, helmConfig.getExtension(), tae -> tae.setName(String.format("%s/%s", helmConfig.getName(), tae.getName())));
        return Collections.singletonMap(tarballFile.toString(), null);
    }

    private String getVersion(HelmChartConfig helmConfig, Project project) {
        if (Strings.isNullOrEmpty((String)helmConfig.getVersion())) {
            return project.getBuildInfo().getVersion();
        }
        return helmConfig.getVersion();
    }

    private Map<String, String> processTemplates(HelmChartConfig helmConfig, Path inputDir, Path outputDir, Collection<File> generatedFiles, List<ConfigReference> valuesReferences, Map<String, HelmValueHolder> prodValues, Map<String, Map<String, HelmValueHolder>> valuesByProfile) throws IOException {
        HashMap<String, String> templates = new HashMap<String, String>();
        Path templatesDir = this.getChartOutputDir(helmConfig, outputDir).resolve(TEMPLATES);
        Files.createDirectories(templatesDir, new FileAttribute[0]);
        List<Map<Object, Object>> resources = this.replaceValuesInYamls(helmConfig, generatedFiles, valuesReferences, prodValues, valuesByProfile);
        Map<String, String> functionsByResource = this.processUserDefinedTemplates(inputDir, templates, templatesDir);
        for (Map<Object, Object> resource : resources) {
            if (helmConfig.getExpressions() != null) {
                YamlExpressionParser parser = new YamlExpressionParser(Arrays.asList(resource));
                for (HelmExpression expressionConfig : helmConfig.getExpressions()) {
                    if (expressionConfig.getPath() == null || expressionConfig.getExpression() == null) continue;
                    HelmWriterSessionListener.readAndSet(parser, expressionConfig.getPath(), expressionConfig.getExpression());
                }
            }
            String kind = (String)resource.get(KIND);
            Path targetFile = templatesDir.resolve(kind.toLowerCase() + YAML);
            String functions = functionsByResource.get(kind.toLowerCase() + YAML);
            String adaptedString = Serialization.yamlMapper().writeValueAsString(resource);
            if (functions != null) {
                adaptedString = functions + System.lineSeparator() + adaptedString;
            }
            for (AddIfStatement addIfStatement : helmConfig.getAddIfStatements()) {
                if (!Strings.isNullOrEmpty((String)addIfStatement.getOnResourceKind()) && !Strings.equals((String)addIfStatement.getOnResourceKind(), (String)kind) || !Strings.isNullOrEmpty((String)addIfStatement.getOnResourceName()) && !Strings.equals((String)addIfStatement.getOnResourceName(), (String)this.getNameFromResource(resource))) continue;
                adaptedString = String.format(IF_STATEMENT_START_TAG, HelmConfigUtils.deductProperty(helmConfig, addIfStatement.getProperty())) + System.lineSeparator() + adaptedString + System.lineSeparator() + TEMPLATE_FUNCTION_END_TAG + System.lineSeparator();
            }
            adaptedString = adaptedString.replaceAll(Pattern.quote("\"{{"), START_TAG).replaceAll(Pattern.quote("}}\""), END_TAG).replaceAll("\":START:", EMPTY).replaceAll(":END:\"", EMPTY).replaceAll(SEPARATOR_QUOTES, "\"").replaceAll(SEPARATOR_TOKEN, System.lineSeparator()).replaceAll("\\\\\\n(\\s)*\\\\", EMPTY);
            this.writeFile(adaptedString, targetFile);
            templates.put(targetFile.toString(), adaptedString);
        }
        return templates;
    }

    private String getNameFromResource(Map<Object, Object> resource) {
        Object name;
        Object metadata = resource.get(METADATA);
        if (metadata != null && metadata instanceof Map && (name = ((Map)metadata).get(NAME)) != null) {
            return name.toString();
        }
        return null;
    }

    private Map<String, String> processUserDefinedTemplates(Path inputDir, Map<String, String> templates, Path templatesDir) throws IOException {
        File[] userTemplates;
        HashMap<String, String> functionsByResource = new HashMap<String, String>();
        File inputTemplates = inputDir.resolve(TEMPLATES).toFile();
        if (inputTemplates.exists() && (userTemplates = inputTemplates.listFiles()) != null) {
            for (File userTemplateFile : userTemplates) {
                if (userTemplateFile.getName().startsWith(HELM_HELPER_PREFIX)) {
                    Path output = templatesDir.resolve(userTemplateFile.getName());
                    Files.copy(new FileInputStream(userTemplateFile), output, new CopyOption[0]);
                    templates.put(output.toString(), EMPTY);
                    continue;
                }
                String[] userResource = Strings.read((InputStream)new FileInputStream(userTemplateFile)).split(System.lineSeparator());
                StringBuilder sb = new StringBuilder();
                boolean isFunction = false;
                for (String lineUserResource : userResource) {
                    if (!lineUserResource.contains(TEMPLATE_FUNCTION_START_TAG) && !isFunction) continue;
                    isFunction = !lineUserResource.contains(TEMPLATE_FUNCTION_END_TAG);
                    sb.append(lineUserResource + System.lineSeparator());
                }
                functionsByResource.put(userTemplateFile.getName(), sb.toString());
            }
        }
        return functionsByResource;
    }

    private List<Map<Object, Object>> replaceValuesInYamls(HelmChartConfig helmConfig, Collection<File> generatedFiles, List<ConfigReference> valuesReferences, Map<String, HelmValueHolder> prodValues, Map<String, Map<String, HelmValueHolder>> valuesByProfile) throws IOException {
        LinkedList<Map<Object, Object>> allResources = new LinkedList<Map<Object, Object>>();
        for (File generatedFile : generatedFiles) {
            if (!generatedFile.getName().toLowerCase().matches(YAML_REG_EXP)) continue;
            YamlExpressionParser parser = YamlPath.from((InputStream[])new InputStream[]{new FileInputStream(generatedFile)});
            HashMap<String, Object> seen = new HashMap<String, Object>();
            for (ConfigReference valueReference : valuesReferences) {
                String valueReferenceProperty = HelmConfigUtils.deductProperty(helmConfig, valueReference.getProperty());
                if (seen.containsKey(valueReferenceProperty)) {
                    if (!Strings.isNotNullOrEmpty((String)valueReference.getProfile())) continue;
                    Object value = Optional.ofNullable(valueReference.getValue()).orElse(seen.get(valueReferenceProperty));
                    this.getValues(prodValues, valuesByProfile, valueReference).put(valueReferenceProperty, new HelmValueHolder(value, valueReference));
                    continue;
                }
                for (String path : valueReference.getPaths()) {
                    String expression = Optional.ofNullable(valueReference.getExpression()).filter(Strings::isNotNullOrEmpty).orElse(VALUES_START_TAG + valueReferenceProperty + VALUES_END_TAG);
                    Object found = HelmWriterSessionListener.readAndSet(parser, path, expression);
                    Object value = Optional.ofNullable(valueReference.getValue()).orElse(found);
                    if (value == null) continue;
                    seen.put(valueReferenceProperty, value);
                    this.getValues(prodValues, valuesByProfile, valueReference).put(valueReferenceProperty, new HelmValueHolder(value, valueReference));
                }
            }
            allResources.addAll(parser.getResources());
        }
        return allResources;
    }

    private Map<String, HelmValueHolder> getValues(Map<String, HelmValueHolder> prodValues, Map<String, Map<String, HelmValueHolder>> valuesByProfile, ConfigReference valueReference) {
        String valueProfile = valueReference.getProfile();
        Map<String, HelmValueHolder> values = prodValues;
        if (Strings.isNotNullOrEmpty((String)valueProfile) && (values = valuesByProfile.get(valueProfile)) == null) {
            values = new HashMap<String, HelmValueHolder>();
            valuesByProfile.put(valueProfile, values);
        }
        return values;
    }

    private Map<String, String> createChartYaml(HelmChartConfig helmConfig, Project project, Path inputDir, Path outputDir) throws IOException {
        Chart chart = new Chart();
        chart.setName(helmConfig.getName());
        chart.setVersion(this.getVersion(helmConfig, project));
        chart.setDescription(helmConfig.getDescription());
        chart.setHome(helmConfig.getHome());
        chart.setSources(Arrays.asList(helmConfig.getSources()));
        chart.setMaintainers(Arrays.stream(helmConfig.getMaintainers()).map(m -> new Maintainer(m.getName(), m.getEmail(), m.getUrl())).collect(Collectors.toList()));
        chart.setIcon(helmConfig.getIcon());
        chart.setApiVersion(helmConfig.getApiVersion());
        chart.setCondition(helmConfig.getCondition());
        chart.setTags(helmConfig.getTags());
        chart.setAppVersion(helmConfig.getAppVersion());
        if (helmConfig.isDeprecated()) {
            chart.setDeprecated(helmConfig.isDeprecated());
        }
        chart.setAnnotations(Arrays.stream(helmConfig.getAnnotations()).collect(Collectors.toMap(Annotation::getKey, Annotation::getValue)));
        chart.setKubeVersion(helmConfig.getKubeVersion());
        chart.setKeywords(Arrays.asList(helmConfig.getKeywords()));
        chart.setDependencies(Arrays.stream(helmConfig.getDependencies()).map(d -> new HelmDependency(d.getName(), Strings.defaultIfEmpty((String)d.getAlias(), (String)d.getName()), d.getVersion(), d.getRepository(), d.getCondition(), d.getTags(), d.isEnabled())).collect(Collectors.toList()));
        chart.setType(helmConfig.getType());
        Path yml = this.getChartOutputDir(helmConfig, outputDir).resolve(CHART_FILENAME).normalize();
        File userChartFile = inputDir.resolve(CHART_FILENAME).toFile();
        Object chartContent = chart;
        if (userChartFile.exists()) {
            chartContent = this.mergeWithFileIfExists(inputDir, CHART_FILENAME, MapUtils.toMultiValueUnsortedMap((Map)Serialization.yamlMapper().readValue(Serialization.asYaml((Object)chart), Map.class)));
        }
        return this.writeFileAsYaml(chartContent, yml);
    }

    private Map<String, String> writeFileAsYaml(Object data, Path file) throws IOException {
        String value = Serialization.asYaml((Object)data);
        return this.writeFile(value, file);
    }

    private Map<String, String> writeFileAsJson(Object data, Path file) throws IOException {
        String value = Serialization.asJson((Object)data);
        return this.writeFile(value, file);
    }

    private Map<String, String> writeFile(String value, Path file) throws IOException {
        try (FileWriter writer = new FileWriter(file.toFile(), true);){
            writer.write(value);
            Map<String, String> map = Collections.singletonMap(file.toString(), value);
            return map;
        }
    }

    private Path getChartOutputDir(HelmChartConfig helmConfig, Path outputDir) {
        return outputDir.resolve(helmConfig.getName());
    }

    private static List<File> listYamls(Path directory) {
        return Stream.of((Object[])Optional.ofNullable(directory.toFile().listFiles()).orElse(new File[0])).filter(File::isFile).filter(f -> f.getName().toLowerCase().matches(YAML_REG_EXP)).collect(Collectors.toList());
    }

    private static Object readAndSet(YamlExpressionParser parser, String path, String expression) {
        Set found = parser.readAndReplace(path, (Object)(START_EXPRESSION_TOKEN + expression.replaceAll(Pattern.quote(System.lineSeparator()), SEPARATOR_TOKEN).replaceAll(Pattern.quote("\""), SEPARATOR_QUOTES) + END_EXPRESSION_TOKEN));
        return found.stream().findFirst().orElse(null);
    }
}

