/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.helm.util;

import io.dekorate.helm.config.HelmChartConfig;
import io.dekorate.helm.util.HelmValueHolder;
import io.dekorate.utils.Strings;
import java.util.Map;
import java.util.TreeSet;

public final class ReadmeBuilder {
    private static final String H1 = "# ";
    private static final String H2 = "## ";
    private static final String TABLE_SEPARATOR = "|";
    private static final String TABLE_HEADER_LINE = " - ";
    private static final String SPACE = " ";
    private static final String CODE_BLOCK = "```";
    private static final String TIP = "> **Tip**: ";
    private final StringBuilder sb = new StringBuilder();

    private ReadmeBuilder() {
    }

    private void writeHeader(String level, String line, Object ... args) {
        this.writeLine(level + line, args);
        this.writeLine();
    }

    private void writeTableHeader(String ... columnNames) {
        StringBuilder header = new StringBuilder();
        StringBuilder line = new StringBuilder();
        for (String columnName : columnNames) {
            header.append(TABLE_SEPARATOR).append(SPACE).append(columnName).append(SPACE);
            line.append(TABLE_SEPARATOR).append(SPACE).append(TABLE_HEADER_LINE).append(SPACE);
        }
        this.sb.append((CharSequence)header).append(TABLE_SEPARATOR).append(System.lineSeparator());
        this.sb.append((CharSequence)line).append(TABLE_SEPARATOR).append(System.lineSeparator());
    }

    private void writeTableRow(Object ... values) {
        StringBuilder row = new StringBuilder();
        for (Object value : values) {
            String actualValue = SPACE;
            if (value != null) {
                actualValue = Strings.defaultIfEmpty((String)value.toString(), (String)SPACE);
            }
            row.append(TABLE_SEPARATOR).append(SPACE).append(actualValue).append(SPACE);
        }
        this.sb.append((CharSequence)row).append(TABLE_SEPARATOR).append(System.lineSeparator());
    }

    private void writeLine(String line, Object ... args) {
        if (Strings.isNotNullOrEmpty((String)line)) {
            this.sb.append(String.format(line, args));
        }
        this.writeLine();
    }

    private void writeLine() {
        this.sb.append(System.lineSeparator());
    }

    private void writeCodeBlock(String ... lines) {
        this.writeLine(CODE_BLOCK, new Object[0]);
        for (String line : lines) {
            this.writeLine(line, new Object[0]);
        }
        this.writeLine(CODE_BLOCK, new Object[0]);
    }

    private void writeTip(String message) {
        this.writeLine(TIP + message, new Object[0]);
    }

    public static String build(HelmChartConfig helmConfig, Map<String, HelmValueHolder> values) {
        ReadmeBuilder builder = new ReadmeBuilder();
        builder.writeHeader(H1, helmConfig.getName(), new Object[0]);
        builder.writeLine(helmConfig.getDescription(), new Object[0]);
        builder.writeHeader(H2, "Configuration", new Object[0]);
        builder.writeLine("The following table lists the configurable parameters and their default values.", new Object[0]);
        builder.writeTableHeader("Parameter", "Description", "Default");
        TreeSet<String> keys = new TreeSet<String>(values.keySet());
        for (String key : keys) {
            HelmValueHolder value = values.get(key);
            builder.writeTableRow(ReadmeBuilder.literal(key), value.configReference.getDescription(), value.value);
        }
        builder.writeLine("Specify each parameter using the `--set key=value[,key=value]` argument to `helm install`.", new Object[0]);
        builder.writeLine("Alternatively, a YAML file that specifies the values for the above parameters can be provided while installing the chart. For example,", new Object[0]);
        builder.writeCodeBlock("$ helm install --name chart-name -f values.yaml .");
        builder.writeTip("You can use the default [values.yaml](values.yaml)");
        return builder.sb.toString();
    }

    private static String literal(Object value) {
        return "`" + value + "`";
    }
}

